/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import java.util.List;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.metadata.ClassAnnotationInformation;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.ejb3.resourceadapterbinding.metadata.EJBBoundResourceAdapterBindingMetaData;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.ejb3.annotation.ResourceAdapter;
import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;

public class ResourceAdaptorMergingProcessor
extends AbstractMergingProcessor<MessageDrivenComponentDescription> {
    public ResourceAdaptorMergingProcessor() {
        super(MessageDrivenComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, MessageDrivenComponentDescription componentConfiguration) throws DeploymentUnitProcessingException {
        EEModuleClassDescription clazz = applicationClasses.getClassByName(componentClass.getName());
        if (clazz == null) {
            return;
        }
        ClassAnnotationInformation resourceAdapter = clazz.getAnnotationInformation(ResourceAdapter.class);
        if (resourceAdapter == null || resourceAdapter.getClassLevelAnnotations().isEmpty()) {
            return;
        }
        String configuredAdapterName = (String)resourceAdapter.getClassLevelAnnotations().get(0);
        String adapterName = this.addEarPrefixIfRelativeName(configuredAdapterName, deploymentUnit, componentClass);
        componentConfiguration.setResourceAdapterName(adapterName);
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, MessageDrivenComponentDescription componentConfiguration) throws DeploymentUnitProcessingException {
        String ejbName = componentConfiguration.getEJBName();
        EjbJarMetaData metaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        if (metaData == null) {
            return;
        }
        AssemblyDescriptorMetaData assemblyDescriptor = metaData.getAssemblyDescriptor();
        if (assemblyDescriptor == null) {
            return;
        }
        List resourceAdapterBindingDataList = assemblyDescriptor.getAny(EJBBoundResourceAdapterBindingMetaData.class);
        String configuredAdapterName = null;
        if (resourceAdapterBindingDataList != null) {
            for (EJBBoundResourceAdapterBindingMetaData resourceAdapterBindingData : resourceAdapterBindingDataList) {
                if ("*".equals(resourceAdapterBindingData.getEjbName()) && configuredAdapterName == null) {
                    configuredAdapterName = resourceAdapterBindingData.getResourceAdapterName();
                    continue;
                }
                if (!ejbName.equals(resourceAdapterBindingData.getEjbName())) continue;
                configuredAdapterName = resourceAdapterBindingData.getResourceAdapterName();
            }
        }
        if (configuredAdapterName != null) {
            String adapterName = this.addEarPrefixIfRelativeName(configuredAdapterName, deploymentUnit, componentClass);
            componentConfiguration.setResourceAdapterName(adapterName);
        }
    }

    private String addEarPrefixIfRelativeName(String configuredName, DeploymentUnit deploymentUnit, Class<?> componentClass) throws DeploymentUnitProcessingException {
        if (!configuredName.startsWith("#")) {
            return configuredName;
        }
        DeploymentUnit parent = deploymentUnit.getParent();
        if (parent == null) {
            throw EjbLogger.ROOT_LOGGER.relativeResourceAdapterNameInStandaloneModule(deploymentUnit.getName(), componentClass.getName(), configuredName);
        }
        return parent.getName() + configuredName;
    }
}

