/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.spi.impl;

import java.io.Serializable;
import javax.ejb.NoSuchEJBException;
import org.jboss.as.ejb3.cache.Cache;
import org.jboss.as.ejb3.cache.Cacheable;
import org.jboss.as.ejb3.cache.spi.BackingCache;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntry;
import org.jboss.ejb.client.Affinity;

public abstract class AbstractCache<K extends Serializable, V extends Cacheable<K>, E extends BackingCacheEntry<K, V>>
implements Cache<K, V> {
    private final BackingCache<K, V, E> backingCache;

    protected AbstractCache(BackingCache<K, V, E> backingCache) {
        this.backingCache = backingCache;
    }

    @Override
    public K createIdentifier() {
        return (K)((Serializable)this.backingCache.createIdentifier());
    }

    @Override
    public V create() {
        return this.backingCache.create().getUnderlyingItem();
    }

    @Override
    public void discard(K key) {
        this.backingCache.discard(key);
    }

    @Override
    public V get(K key) throws NoSuchEJBException {
        E entry = this.backingCache.get(key);
        return entry != null ? (V)entry.getUnderlyingItem() : null;
    }

    @Override
    public boolean contains(K key) {
        try {
            return this.backingCache.peek(key) != null;
        }
        catch (NoSuchEJBException e) {
            return false;
        }
    }

    @Override
    public void release(V object) {
        this.backingCache.release((Serializable)object.getId());
    }

    @Override
    public void remove(K key) {
        this.backingCache.remove(key);
    }

    @Override
    public void start() {
        this.backingCache.start();
    }

    @Override
    public void stop() {
        this.backingCache.stop();
    }

    @Override
    public Affinity getStrictAffinity() {
        return this.backingCache.getStrictAffinity();
    }

    @Override
    public Affinity getWeakAffinity(K key) {
        return this.backingCache.getWeakAffinity(key);
    }

    @Override
    public boolean hasAffinity(K key) {
        return this.backingCache.hasAffinity(key);
    }

    @Override
    public int getCacheSize() {
        return this.backingCache.getCacheSize();
    }

    @Override
    public int getPassivatedCount() {
        return this.backingCache.getPassivatedCount();
    }

    @Override
    public int getTotalSize() {
        return this.backingCache.getTotalSize();
    }
}

