/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.RunAs;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextFactory;

public class SecurityContextAssociation {
    private static boolean SERVER = true;
    private static SecurityContext securityContext = null;
    private static RuntimePermission SetSecurityContextPermission = new RuntimePermission("org.jboss.security.setSecurityContext");
    private static RuntimePermission GetSecurityContextPermission = new RuntimePermission("org.jboss.security.getSecurityContext");
    private static RuntimePermission ClearSecurityContextPermission = new RuntimePermission("org.jboss.security.clearSecurityContext");
    private static final RuntimePermission SetRunAsIdentity = new RuntimePermission("org.jboss.security.setRunAsRole");
    private static final RuntimePermission GetContextInfo = new RuntimePermission("org.jboss.security.accessContextInfo:get");
    private static final RuntimePermission SetContextInfo = new RuntimePermission("org.jboss.security.accessContextInfo:set");
    public static final String SECURITYCONTEXT_THREADLOCAL = "org.jboss.security.context.ThreadLocal";
    private static final String SECURITYASSOCIATION_THREADLOCAL = "org.jboss.security.SecurityAssociation.ThreadLocal";
    private static ThreadLocal<SecurityContext> securityContextLocal;

    public static boolean isClient() {
        return !SERVER;
    }

    public static void setClient() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(SecurityContextAssociation.class.getName() + ".setClient"));
        }
        SERVER = false;
    }

    public static void setSecurityContext(SecurityContext sc) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SetSecurityContextPermission);
        }
        if (!SERVER) {
            securityContext = sc;
        } else if (sc == null) {
            securityContextLocal.remove();
        } else {
            securityContextLocal.set(sc);
        }
    }

    public static SecurityContext getSecurityContext() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GetSecurityContextPermission);
        }
        if (!SERVER) {
            return securityContext;
        }
        return securityContextLocal.get();
    }

    public static void clearSecurityContext() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ClearSecurityContextPermission);
        }
        if (!SERVER) {
            securityContext = null;
        } else {
            securityContextLocal.remove();
        }
    }

    public static void pushRunAsIdentity(RunAs runAs) {
        SecurityContext sc;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SetRunAsIdentity);
        }
        if ((sc = SecurityContextAssociation.getSecurityContext()) != null) {
            sc.setOutgoingRunAs(runAs);
        }
    }

    public static RunAs popRunAsIdentity() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SetRunAsIdentity);
        }
        SecurityContext sc = SecurityContextAssociation.getSecurityContext();
        RunAs ra = null;
        if (sc != null) {
            ra = sc.getOutgoingRunAs();
            sc.setOutgoingRunAs(null);
        }
        return ra;
    }

    public static RunAs peekRunAsIdentity() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(SecurityContextAssociation.class.getName() + ".peekRunAsIdentity"));
        }
        RunAs ra = null;
        SecurityContext sc = SecurityContextAssociation.getSecurityContext();
        if (sc != null) {
            ra = sc.getOutgoingRunAs();
        }
        return ra;
    }

    public static Object getContextInfo(String key) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GetContextInfo);
        }
        if (key == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("key");
        }
        SecurityContext sc = SecurityContextAssociation.getSecurityContext();
        if (sc != null) {
            return sc.getData().get(key);
        }
        return null;
    }

    public static Object setContextInfo(String key, Object value) {
        SecurityContext sc;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SetContextInfo);
        }
        if ((sc = SecurityContextAssociation.getSecurityContext()) != null) {
            return sc.getData().put(key, value);
        }
        return null;
    }

    private static String getSystemProperty(final String propertyName, final String defaultString) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(propertyName, defaultString);
            }
        });
    }

    public static Subject getSubject() {
        SecurityContext sc;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GetSecurityContextPermission);
        }
        if ((sc = SecurityContextAssociation.getSecurityContext()) != null) {
            return sc.getUtil().getSubject();
        }
        return null;
    }

    public static Principal getPrincipal() {
        SecurityContext sc;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GetSecurityContextPermission);
        }
        if ((sc = SecurityContextAssociation.getSecurityContext()) != null) {
            return sc.getUtil().getUserPrincipal();
        }
        return null;
    }

    public static void setPrincipal(Principal principal) {
        SecurityContext securityContext;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SetSecurityContextPermission);
        }
        if ((securityContext = SecurityContextAssociation.getSecurityContext()) == null) {
            try {
                securityContext = SecurityContextFactory.createSecurityContext("CLIENT_SIDE");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            SecurityContextAssociation.setSecurityContext(securityContext);
        }
        Object credential = securityContext.getUtil().getCredential();
        Subject subj = securityContext.getUtil().getSubject();
        securityContext.getUtil().createSubjectInfo(principal, credential, subj);
    }

    public static Object getCredential() {
        SecurityContext sc;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GetSecurityContextPermission);
        }
        if ((sc = SecurityContextAssociation.getSecurityContext()) != null) {
            return sc.getUtil().getCredential();
        }
        return null;
    }

    public static void setCredential(Object credential) {
        SecurityContext securityContext;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SetSecurityContextPermission);
        }
        if ((securityContext = SecurityContextAssociation.getSecurityContext()) == null) {
            try {
                securityContext = SecurityContextFactory.createSecurityContext("CLIENT_SIDE");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            SecurityContextAssociation.setSecurityContext(securityContext);
        }
        Principal principal = securityContext.getUtil().getUserPrincipal();
        Subject subj = securityContext.getUtil().getSubject();
        securityContext.getUtil().createSubjectInfo(principal, credential, subj);
    }

    static {
        String saflag = SecurityContextAssociation.getSystemProperty(SECURITYASSOCIATION_THREADLOCAL, "false");
        String scflag = SecurityContextAssociation.getSystemProperty(SECURITYCONTEXT_THREADLOCAL, "false");
        boolean useThreadLocal = Boolean.valueOf(saflag) != false || Boolean.valueOf(scflag) != false;
        securityContextLocal = useThreadLocal ? new ThreadLocal() : new InheritableThreadLocal<SecurityContext>();
    }
}

