/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxr.extension;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.jaxr.JAXRConfiguration;
import org.jboss.dmr.ModelNode;

public class JAXRPropertyWrite
extends AbstractWriteAttributeHandler<Void> {
    private final JAXRConfiguration config;

    public JAXRPropertyWrite(JAXRConfiguration config, AttributeDefinition attribute) {
        super(new AttributeDefinition[]{attribute});
        this.config = config;
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder handbackHolder) throws OperationFailedException {
        String propName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        String propValue = resolvedValue.asString();
        JAXRPropertyWrite.applyUpdateToConfig(this.config, propName, propValue);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        String propName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        String propValue = valueToRestore.asString();
        JAXRPropertyWrite.applyUpdateToConfig(this.config, propName, propValue);
    }

    public static void applyUpdateToConfig(JAXRConfiguration config, String propName, String propValue) {
        config.applyUpdateToConfig(propName, propValue);
    }
}

