/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.csiv2;

import org.jboss.as.jacorb.JacORBLogger;
import org.jboss.as.jacorb.JacORBMessages;
import org.jboss.as.jacorb.csiv2.CSIv2Policy;
import org.jboss.as.jacorb.csiv2.CSIv2Util;
import org.jboss.as.jacorb.service.CorbaORBService;
import org.jboss.as.jacorb.service.IORSecConfigMetaDataService;
import org.jboss.metadata.ejb.jboss.IORSecurityConfigMetaData;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;

public class CSIv2IORInterceptor
extends LocalObject
implements IORInterceptor {
    private static final int MIN_SSL_OPTIONS = 26;
    private TaggedComponent defaultSSLComponent;
    private TaggedComponent defaultCSIComponent;

    public CSIv2IORInterceptor(Codec codec) {
        String sslPortString = CorbaORBService.getORBProperty("OASSLPort");
        int sslPort = sslPortString == null ? 0 : Integer.parseInt(sslPortString);
        try {
            SSL ssl = new SSL(26, 0, (short)sslPort);
            ORB orb = ORB.init();
            Any any = orb.create_any();
            SSLHelper.insert((Any)any, (SSL)ssl);
            byte[] componentData = codec.encode_value(any);
            this.defaultSSLComponent = new TaggedComponent(20, componentData);
            IORSecurityConfigMetaData iorSecurityConfigMetaData = IORSecConfigMetaDataService.getCurrent();
            if (iorSecurityConfigMetaData == null) {
                iorSecurityConfigMetaData = new IORSecurityConfigMetaData();
            }
            this.defaultCSIComponent = CSIv2Util.createSecurityTaggedComponent(iorSecurityConfigMetaData, codec, sslPort, orb);
        }
        catch (InvalidTypeForEncoding e) {
            throw JacORBMessages.MESSAGES.unexpectedException(e);
        }
    }

    public void destroy() {
    }

    public void establish_components(IORInfo info) {
        CSIv2Policy csiv2Policy = null;
        try {
            csiv2Policy = (CSIv2Policy)info.get_effective_policy(-2023406815);
        }
        catch (BAD_PARAM e) {
            JacORBLogger.ROOT_LOGGER.csiv2PolicyNotFoundInIORInfo();
        }
        catch (Exception e) {
            JacORBLogger.ROOT_LOGGER.failedToFetchCSIv2Policy(e);
        }
        boolean interopIONA = "on".equalsIgnoreCase(CorbaORBService.getORBProperty("iona"));
        if (csiv2Policy != null) {
            TaggedComponent csiv2Component;
            TaggedComponent sslComponent = csiv2Policy.getSSLTaggedComponent();
            if (sslComponent != null && !interopIONA) {
                info.add_ior_component_to_profile(sslComponent, 0);
            }
            if ((csiv2Component = csiv2Policy.getSecurityTaggedComponent()) != null) {
                info.add_ior_component_to_profile(csiv2Component, 0);
            }
        } else {
            if (this.defaultSSLComponent != null && !interopIONA) {
                info.add_ior_component_to_profile(this.defaultSSLComponent, 0);
            }
            if (this.defaultCSIComponent != null) {
                info.add_ior_component_to_profile(this.defaultCSIComponent, 0);
            }
        }
    }

    public String name() {
        return CSIv2IORInterceptor.class.getName();
    }
}

