/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.transport;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.scout.transport.SecurityActions;
import org.apache.ws.scout.transport.Transport;
import org.apache.ws.scout.transport.TransportException;
import org.apache.ws.scout.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RMITransport
implements Transport {
    private static Log log = LogFactory.getLog(RMITransport.class);

    @Override
    public Element send(Element request, URI endpointURI) throws TransportException {
        Element response = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("\nRequest message:\n" + XMLUtils.convertNodeToXMLString(request)));
            log.debug((Object)("Calling " + endpointURI + " using rmi"));
        }
        try {
            String factoryURLPkgs;
            String host = endpointURI.getHost();
            int port = endpointURI.getPort();
            String scheme = endpointURI.getScheme();
            String service = endpointURI.getPath();
            String className = endpointURI.getQuery();
            String methodName = endpointURI.getFragment();
            Properties env = new Properties();
            String factoryInitial = SecurityActions.getProperty("java.naming.factory.initial");
            if (factoryInitial == null) {
                factoryInitial = "org.jnp.interfaces.NamingContextFactory";
            }
            if ((factoryURLPkgs = SecurityActions.getProperty("java.naming.factory.url.pkgs")) == null) {
                factoryURLPkgs = "org.jboss.naming";
            }
            env.setProperty("java.naming.factory.initial", factoryInitial);
            env.setProperty("java.naming.factory.url.pkgs", factoryURLPkgs);
            env.setProperty("java.naming.provider.url", scheme + "://" + host + ":" + port);
            log.debug((Object)("Initial Context using env=" + env.toString()));
            InitialContext context = new InitialContext(env);
            log.debug((Object)("Calling service=" + service + ", Class = " + className + ", Method=" + methodName));
            Object requestHandler = context.lookup(service);
            Class<?> c = Class.forName(className);
            Method method = c.getMethod(methodName, Element.class);
            Node node = (Node)method.invoke(requestHandler, request);
            if (node.getFirstChild() != null) {
                response = (Element)node.getFirstChild();
            }
        }
        catch (Exception ex) {
            throw new TransportException(ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\nResponse message:\n" + XMLUtils.convertNodeToXMLString(response)));
        }
        return response;
    }

    @Override
    public String send(String request, URI endpointURI) throws TransportException {
        String response = null;
        log.debug((Object)("\nRequest message:\n" + request));
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document document = parser.parse(request);
            Element element = document.getDocumentElement();
            response = XMLUtils.convertNodeToXMLString(this.send(element, endpointURI));
        }
        catch (Exception ex) {
            throw new TransportException(ex);
        }
        log.debug((Object)("\nResponse message:\n" + response));
        return response;
    }
}

