/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.WebVirtualHostDefinition;
import org.jboss.dmr.ModelNode;

public class WriteDefaultWebModule
extends ReloadRequiredWriteAttributeHandler {
    static final WriteDefaultWebModule INSTANCE = new WriteDefaultWebModule();

    public WriteDefaultWebModule() {
        super(new AttributeDefinition[]{WebVirtualHostDefinition.DEFAULT_WEB_MODULE});
    }

    protected void validateUpdatedModel(OperationContext context, Resource model) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ModelNode virtualHost = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
                if (virtualHost.hasDefined("default-web-module") && virtualHost.hasDefined("enable-welcome-root") && Boolean.parseBoolean(virtualHost.get("enable-welcome-root").toString())) {
                    throw new OperationFailedException(WebMessages.MESSAGES.noWelcomeWebappWithDefaultWebModule());
                }
                context.stepCompleted();
            }
        }, OperationContext.Stage.MODEL);
    }
}

