/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.cli;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.handlers.DefaultFilenameTabCompleter;
import org.jboss.as.cli.handlers.FilenameTabCompleter;
import org.jboss.as.cli.handlers.SimpleTabCompleter;
import org.jboss.as.cli.handlers.WindowsFilenameTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.impl.FileSystemPathArgument;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.util.SimpleTable;
import org.jboss.as.patching.PatchMessages;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.cli.CandidatesProviders;
import org.jboss.as.patching.metadata.Identity;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchElement;
import org.jboss.as.patching.metadata.PatchXml;
import org.jboss.as.patching.tool.PatchOperationBuilder;
import org.jboss.as.patching.tool.PatchOperationTarget;
import org.jboss.dmr.ModelNode;

public class PatchHandler
extends CommandHandlerWithHelp {
    static final String PATCH = "patch";
    static final String APPLY = "apply";
    static final String ROLLBACK = "rollback";
    static final String HISTORY = "history";
    static final String INFO = "info";
    static final String INSPECT = "inspect";
    private final ArgumentWithValue host;
    private final ArgumentWithValue action = new ArgumentWithValue((CommandHandlerWithArguments)this, (CommandLineCompleter)new SimpleTabCompleter(new String[]{"apply", "rollback", "history", "info", "inspect"}), 0, "--action");
    private final ArgumentWithoutValue path;
    private final ArgumentWithValue patchId;
    private final ArgumentWithoutValue rollbackTo;
    private final ArgumentWithValue resetConfiguration;
    private final ArgumentWithoutValue overrideModules;
    private final ArgumentWithoutValue overrideAll;
    private final ArgumentWithValue override;
    private final ArgumentWithValue preserve;
    private final ArgumentWithoutValue distribution;
    private final ArgumentWithoutValue modulePath;
    private final ArgumentWithoutValue bundlePath;
    private static final String lineSeparator = System.getSecurityManager() == null ? System.getProperty("line.separator") : AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("line.separator");
        }
    });
    private final ArgumentWithoutValue verbose;
    private static final String HOME = "JBOSS_HOME";
    private static final String HOME_DIR = "jboss.home.dir";

    public PatchHandler(CommandContext context) {
        super(PATCH, false);
        this.host = new ArgumentWithValue((CommandHandlerWithArguments)this, (CommandLineCompleter)new DefaultCompleter(CandidatesProviders.HOSTS), "--host"){

            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                boolean connected = ctx.getControllerHost() != null;
                return connected && ctx.isDomainMode() && super.canAppearNext(ctx);
            }
        };
        this.overrideModules = new ArgumentWithoutValue((CommandHandlerWithArguments)this, "--override-modules"){

            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.APPLY, PatchHandler.ROLLBACK})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.overrideModules.addRequiredPreceding((CommandArgument)this.action);
        this.overrideAll = new ArgumentWithoutValue((CommandHandlerWithArguments)this, "--override-all"){

            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.APPLY, PatchHandler.ROLLBACK})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.overrideAll.addRequiredPreceding((CommandArgument)this.action);
        this.override = new ArgumentWithValue((CommandHandlerWithArguments)this, "--override"){

            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.APPLY, PatchHandler.ROLLBACK})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.override.addRequiredPreceding((CommandArgument)this.action);
        this.preserve = new ArgumentWithValue((CommandHandlerWithArguments)this, "--preserve"){

            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.APPLY, PatchHandler.ROLLBACK})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.preserve.addRequiredPreceding((CommandArgument)this.action);
        WindowsFilenameTabCompleter pathCompleter = Util.isWindows() ? new WindowsFilenameTabCompleter(context) : new DefaultFilenameTabCompleter(context);
        this.path = new FileSystemPathArgument((CommandHandlerWithArguments)this, (FilenameTabCompleter)pathCompleter, 1, "--path"){

            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.APPLY, PatchHandler.INSPECT})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.path.addRequiredPreceding((CommandArgument)this.action);
        this.patchId = new ArgumentWithValue((CommandHandlerWithArguments)this, 1, "--patch-id"){

            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.INFO, PatchHandler.ROLLBACK})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.patchId.addRequiredPreceding((CommandArgument)this.action);
        this.rollbackTo = new ArgumentWithoutValue((CommandHandlerWithArguments)this, "--rollback-to"){

            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.ROLLBACK})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.rollbackTo.addRequiredPreceding((CommandArgument)this.action);
        this.resetConfiguration = new ArgumentWithValue((CommandHandlerWithArguments)this, (CommandLineCompleter)SimpleTabCompleter.BOOLEAN, "--reset-configuration"){

            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.ROLLBACK})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.resetConfiguration.addRequiredPreceding((CommandArgument)this.action);
        this.distribution = new FileSystemPathArgument((CommandHandlerWithArguments)this, (FilenameTabCompleter)pathCompleter, "--distribution"){

            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                return false;
            }
        };
        this.modulePath = new FileSystemPathArgument((CommandHandlerWithArguments)this, (FilenameTabCompleter)pathCompleter, "--module-path"){

            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                return false;
            }
        };
        this.bundlePath = new FileSystemPathArgument((CommandHandlerWithArguments)this, (FilenameTabCompleter)pathCompleter, "--bundle-path"){

            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                return false;
            }
        };
        this.verbose = new ArgumentWithoutValue((CommandHandlerWithArguments)this, "--verbose", "-v"){

            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.INFO, PatchHandler.INSPECT})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.verbose.addRequiredPreceding((CommandArgument)this.action);
        this.verbose.addRequiredPreceding((CommandArgument)this.patchId);
    }

    private boolean canOnlyAppearAfterActions(CommandContext ctx, String ... actions) {
        String actionStr = this.action.getValue(ctx.getParsedCommandLine());
        if (actionStr == null || actions.length == 0) {
            return false;
        }
        return Arrays.asList(actions).contains(actionStr);
    }

    protected void doHandle(CommandContext ctx) throws CommandLineException {
        ModelNode response;
        ParsedCommandLine parsedLine = ctx.getParsedCommandLine();
        String action = this.action.getValue(parsedLine);
        if (INSPECT.equals(action)) {
            this.doInspect(ctx);
            return;
        }
        PatchOperationTarget target = this.createPatchOperationTarget(ctx);
        PatchOperationBuilder builder = this.createPatchOperationBuilder(parsedLine);
        try {
            response = builder.execute(target);
        }
        catch (Exception e) {
            throw new CommandLineException(action + " failed", (Throwable)e);
        }
        if (!Util.isSuccess((ModelNode)response)) {
            ModelNode fd = response.get("failure-description");
            if (!fd.isDefined()) {
                throw new CommandLineException("Failed to apply patch: " + response.asString());
            }
            if (fd.has("conflicts")) {
                StringBuilder buf = new StringBuilder();
                buf.append(fd.get("message").asString()).append(": ");
                ModelNode conflicts = fd.get("conflicts");
                String title = "";
                if (conflicts.has("bundles")) {
                    this.formatConflictsList(buf, conflicts, "", "bundles");
                    title = ", ";
                }
                if (conflicts.has("modules")) {
                    this.formatConflictsList(buf, conflicts, title, "modules");
                    title = ", ";
                }
                if (conflicts.has("misc")) {
                    this.formatConflictsList(buf, conflicts, title, "misc");
                }
                buf.append(lineSeparator).append("Use the --override-all, --override=[] or --preserve=[] arguments in order to resolve the conflict.");
                throw new CommandLineException(buf.toString());
            }
            throw new CommandLineException(Util.getFailureDescription((ModelNode)response));
        }
        if (INFO.equals(action)) {
            if (this.patchId.getValue(parsedLine) != null) {
                ModelNode result = response.get("result");
                if (!result.isDefined()) {
                    return;
                }
                SimpleTable table = new SimpleTable(2);
                table.addLine(new String[]{"Patch ID:", result.get("patch-id").asString()});
                table.addLine(new String[]{"Type:", result.get("type").asString()});
                table.addLine(new String[]{"Identity name:", result.get("identity-name").asString()});
                table.addLine(new String[]{"Identity version:", result.get("identity-version").asString()});
                table.addLine(new String[]{"Description:", result.get("description").asString()});
                if (result.hasDefined("link")) {
                    table.addLine(new String[]{"Link:", result.get("link").asString()});
                }
                ctx.printLine(table.toString(false));
                ModelNode elements = result.get("elements");
                if (elements.isDefined()) {
                    ctx.printLine("");
                    ctx.printLine("ELEMENTS");
                    for (ModelNode e : elements.asList()) {
                        table = new SimpleTable(2);
                        table.addLine(new String[]{"Patch ID:", e.get("patch-id").asString()});
                        table.addLine(new String[]{"Name:", e.get("name").asString()});
                        table.addLine(new String[]{"Type:", e.get("type").asString()});
                        table.addLine(new String[]{"Description:", e.get("description").asString()});
                        ctx.printLine("");
                        ctx.printLine(table.toString(false));
                    }
                }
            } else {
                ctx.printLine(response.toJSONString(false));
            }
        } else {
            ctx.printLine(response.toJSONString(false));
        }
    }

    protected void doInspect(CommandContext ctx) throws CommandLineException {
        Patch patch;
        ParsedCommandLine parsedLine = ctx.getParsedCommandLine();
        String patchPath = this.path.getValue(parsedLine, true);
        File patchFile = new File(patchPath);
        if (!patchFile.exists()) {
            throw new CommandLineException("Failed to locate " + patchFile.getAbsolutePath());
        }
        ZipFile patchZip = null;
        InputStream is = null;
        try {
            patchZip = new ZipFile(patchFile);
            ZipEntry patchXmlEntry = patchZip.getEntry("patch.xml");
            if (patchXmlEntry == null) {
                throw new CommandLineException("Failed to locate patch.xml inside " + patchFile.getAbsolutePath());
            }
            is = patchZip.getInputStream(patchXmlEntry);
            patch = PatchXml.parse(is).resolvePatch(null, null);
        }
        catch (ZipException e) {
            throw new CommandLineException("Failed to open " + patchFile.getAbsolutePath(), (Throwable)e);
        }
        catch (IOException e) {
            throw new CommandLineException("Failed to open " + patchFile.getAbsolutePath(), (Throwable)e);
        }
        catch (PatchingException e) {
            throw new CommandLineException("Failed to resolve parsed patch", (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new CommandLineException("Failed to parse patch.xml", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            if (patchZip != null) {
                try {
                    patchZip.close();
                }
                catch (IOException e) {}
            }
        }
        Identity identity = patch.getIdentity();
        SimpleTable table = new SimpleTable(2);
        table.addLine(new String[]{"Patch ID:", patch.getPatchId()});
        table.addLine(new String[]{"Type:", identity.getPatchType().getName()});
        table.addLine(new String[]{"Identity name:", identity.getName()});
        table.addLine(new String[]{"Identity version:", identity.getVersion()});
        table.addLine(new String[]{"Description:", patch.getDescription() == null ? "n/a" : patch.getDescription()});
        if (patch.getLink() != null) {
            table.addLine(new String[]{"Link:", patch.getLink()});
        }
        ctx.printLine(table.toString(false));
        if (this.verbose.isPresent(parsedLine)) {
            ctx.printLine("");
            ctx.printLine("ELEMENTS");
            for (PatchElement e : patch.getElements()) {
                table = new SimpleTable(2);
                table.addLine(new String[]{"Patch ID:", e.getId()});
                table.addLine(new String[]{"Name:", e.getProvider().getName()});
                table.addLine(new String[]{"Type:", e.getProvider().isAddOn() ? "add-on" : "layer"});
                table.addLine(new String[]{"Description:", e.getDescription()});
                ctx.printLine("");
                ctx.printLine(table.toString(false));
            }
        }
    }

    protected void formatConflictsList(StringBuilder buf, ModelNode conflicts, String title, String contentType) {
        buf.append(title);
        List list = conflicts.get(contentType).asList();
        int i = 0;
        while (i < list.size()) {
            ModelNode item = (ModelNode)list.get(i++);
            buf.append(item.asString());
            if (i >= list.size()) continue;
            buf.append(", ");
        }
    }

    private PatchOperationBuilder createPatchOperationBuilder(ParsedCommandLine args) throws CommandFormatException {
        PatchOperationBuilder builder;
        String action = this.action.getValue(args, true);
        if (APPLY.equals(action)) {
            String path = this.path.getValue(args, true);
            File f = new File(path);
            if (!f.exists()) {
                throw new CommandFormatException("Path " + f.getAbsolutePath() + " doesn't exist.");
            }
            if (f.isDirectory()) {
                throw new CommandFormatException(f.getAbsolutePath() + " is a directory.");
            }
            builder = PatchOperationBuilder.Factory.patch(f);
        } else if (ROLLBACK.equals(action)) {
            boolean resetConfig;
            String resetConfigValue = this.resetConfiguration.getValue(args, true);
            if ("true".equalsIgnoreCase(resetConfigValue)) {
                resetConfig = true;
            } else if ("false".equalsIgnoreCase(resetConfigValue)) {
                resetConfig = false;
            } else {
                throw new CommandFormatException("Unexpected value for --reset-configuration (only true and false are allowed): " + resetConfigValue);
            }
            if (this.patchId.isPresent(args)) {
                String id = this.patchId.getValue(args, true);
                boolean rollbackTo = this.rollbackTo.isPresent(args);
                builder = PatchOperationBuilder.Factory.rollback(id, rollbackTo, resetConfig);
            } else {
                builder = PatchOperationBuilder.Factory.rollbackLast(resetConfig);
            }
        } else {
            if (INFO.equals(action)) {
                String pId = this.patchId.getValue(args);
                PatchOperationBuilder builder2 = pId == null ? PatchOperationBuilder.Factory.info() : PatchOperationBuilder.Factory.info(pId, this.verbose.isPresent(args));
                return builder2;
            }
            if (HISTORY.equals(action)) {
                PatchOperationBuilder builder3 = PatchOperationBuilder.Factory.history();
                return builder3;
            }
            throw new CommandFormatException("Unrecognized action '" + action + "'");
        }
        if (this.overrideModules.isPresent(args)) {
            builder.ignoreModuleChanges();
        }
        if (this.overrideAll.isPresent(args)) {
            builder.overrideAll();
        }
        if (this.override.isPresent(args)) {
            String overrideList = this.override.getValue(args);
            if (overrideList == null || overrideList.isEmpty()) {
                throw new CommandFormatException(this.override.getFullName() + " is missing value.");
            }
            for (String path : overrideList.split(",+")) {
                builder.overrideItem(path);
            }
        }
        if (this.preserve.isPresent(args)) {
            String preserveList = this.preserve.getValue(args);
            if (preserveList == null || preserveList.isEmpty()) {
                throw new CommandFormatException(this.preserve.getFullName() + " is missing value.");
            }
            for (String path : preserveList.split(",+")) {
                builder.preserveItem(path);
            }
        }
        return builder;
    }

    private PatchOperationTarget createPatchOperationTarget(CommandContext ctx) throws CommandLineException {
        PatchOperationTarget target;
        boolean connected;
        boolean bl = connected = ctx.getControllerHost() != null;
        if (connected) {
            if (ctx.isDomainMode()) {
                String hostName = this.host.getValue(ctx.getParsedCommandLine(), true);
                target = PatchOperationTarget.createHost(hostName, ctx.getModelControllerClient());
            } else {
                target = PatchOperationTarget.createStandalone(ctx.getModelControllerClient());
            }
        } else {
            ParsedCommandLine args = ctx.getParsedCommandLine();
            String jbossHome = this.getJBossHome(args);
            File root = new File(jbossHome);
            List<File> modules = PatchHandler.getFSArgument(this.modulePath, args, root, "modules");
            List<File> bundles = PatchHandler.getFSArgument(this.bundlePath, args, root, "bundles");
            try {
                target = PatchOperationTarget.createLocal(root, modules, bundles);
            }
            catch (Exception e) {
                throw new CommandLineException("Unable to apply patch to local JBOSS_HOME=" + jbossHome, (Throwable)e);
            }
        }
        return target;
    }

    private String getJBossHome(ParsedCommandLine args) {
        String resolved;
        String targetDistro = this.distribution.getValue(args);
        if (targetDistro != null) {
            return targetDistro;
        }
        String string = resolved = System.getSecurityManager() == null ? System.getenv(HOME) : AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getenv(PatchHandler.HOME);
            }
        });
        if (resolved == null) {
            String string2 = resolved = System.getSecurityManager() == null ? System.getProperty(HOME_DIR) : AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(PatchHandler.HOME_DIR);
                }
            });
        }
        if (resolved == null) {
            throw PatchMessages.MESSAGES.cliFailedToResolveDistribution();
        }
        return resolved;
    }

    private static List<File> getFSArgument(ArgumentWithoutValue arg, ParsedCommandLine args, File root, String param) {
        String value = arg.getValue(args);
        if (value != null) {
            String[] values = value.split(Pattern.quote(File.pathSeparator));
            if (values.length == 1) {
                return Collections.singletonList(new File(value));
            }
            ArrayList<File> resolved = new ArrayList<File>(values.length);
            for (String path : values) {
                resolved.add(new File(path));
            }
            return resolved;
        }
        return Collections.singletonList(new File(root, param));
    }
}

