/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.subsystem;

import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.jboss.as.cmp.keygenerator.KeyGeneratorFactory;
import org.jboss.as.cmp.keygenerator.hilo.HiLoKeyGeneratorFactory;
import org.jboss.as.cmp.subsystem.AbstractKeyGeneratorAdd;
import org.jboss.as.cmp.subsystem.HiLoKeyGeneratorResourceDefinition;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.txn.service.TransactionManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

class HiLoKeyGeneratorAdd
extends AbstractKeyGeneratorAdd {
    static HiLoKeyGeneratorAdd INSTANCE = new HiLoKeyGeneratorAdd();

    HiLoKeyGeneratorAdd() {
    }

    @Override
    protected Service<KeyGeneratorFactory> getKeyGeneratorFactory(OperationContext context, ModelNode model) throws OperationFailedException {
        HiLoKeyGeneratorFactory factory = new HiLoKeyGeneratorFactory();
        ModelNode node = HiLoKeyGeneratorResourceDefinition.BLOCK_SIZE.resolveModelAttribute(context, model);
        if (node.isDefined()) {
            factory.setBlockSize(node.asLong());
        }
        if ((node = HiLoKeyGeneratorResourceDefinition.CREATE_TABLE.resolveModelAttribute(context, model)).isDefined()) {
            factory.setCreateTable(node.asBoolean());
        }
        if ((node = HiLoKeyGeneratorResourceDefinition.CREATE_TABLE_DDL.resolveModelAttribute(context, model)).isDefined()) {
            factory.setCreateTableDdl(node.asString());
        }
        if ((node = HiLoKeyGeneratorResourceDefinition.DROP_TABLE.resolveModelAttribute(context, model)).isDefined()) {
            factory.setDropTable(node.asBoolean());
        }
        if ((node = HiLoKeyGeneratorResourceDefinition.ID_COLUMN.resolveModelAttribute(context, model)).isDefined()) {
            factory.setIdColumnName(node.asString());
        }
        if ((node = HiLoKeyGeneratorResourceDefinition.SELECT_HI_DDL.resolveModelAttribute(context, model)).isDefined()) {
            factory.setSelectHiSql(node.asString());
        }
        if ((node = HiLoKeyGeneratorResourceDefinition.SEQUENCE_COLUMN.resolveModelAttribute(context, model)).isDefined()) {
            factory.setSequenceColumn(node.asString());
        }
        if ((node = HiLoKeyGeneratorResourceDefinition.SEQUENCE_NAME.resolveModelAttribute(context, model)).isDefined()) {
            factory.setSequenceName(node.asString());
        }
        if ((node = HiLoKeyGeneratorResourceDefinition.TABLE_NAME.resolveModelAttribute(context, model)).isDefined()) {
            factory.setTableName(node.asString());
        }
        return factory;
    }

    @Override
    protected ServiceName getServiceName(String name) {
        return HiLoKeyGeneratorFactory.SERVICE_NAME.append(new String[]{name});
    }

    @Override
    protected void addDependencies(ModelNode operation, Service<KeyGeneratorFactory> keyGeneratorFactory, ServiceBuilder<KeyGeneratorFactory> factoryServiceBuilder) {
        HiLoKeyGeneratorFactory hiloFactory = (HiLoKeyGeneratorFactory)HiLoKeyGeneratorFactory.class.cast(keyGeneratorFactory);
        factoryServiceBuilder.addDependency(AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{operation.get("data-source").asString()}), DataSource.class, hiloFactory.getDataSourceInjector());
        factoryServiceBuilder.addDependency(TransactionManagerService.SERVICE_NAME, TransactionManager.class, hiloFactory.getTransactionManagerInjector());
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (SimpleAttributeDefinition attribute : HiLoKeyGeneratorResourceDefinition.ATTRIBUTES) {
            attribute.validateAndSet(operation, model);
        }
    }
}

