/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.service;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.appclient.logging.AppClientLogger;
import org.jboss.as.appclient.service.ApplicationClientDeploymentService;
import org.jboss.as.appclient.service.LazyConnectionContextSelector;
import org.jboss.as.appclient.service.SecurityActions;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.naming.InjectedEENamespaceContextSelector;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.ejb.client.ContextSelector;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.remoting.ConfigBasedEJBClientContextSelector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ApplicationClientStartService
implements Service<ApplicationClientStartService> {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"appClientStart"});
    private final InjectedValue<ApplicationClientDeploymentService> applicationClientDeploymentServiceInjectedValue = new InjectedValue();
    private final InjectedValue<Component> applicationClientComponent = new InjectedValue();
    private final InjectedEENamespaceContextSelector namespaceContextSelectorInjectedValue;
    private final List<SetupAction> setupActions;
    private final Method mainMethod;
    private final String[] parameters;
    private final ClassLoader classLoader;
    private final ContextSelector<EJBClientContext> contextSelector;
    final String hostUrl;
    private Thread thread;
    private ComponentInstance instance;

    public ApplicationClientStartService(Method mainMethod, String[] parameters, InjectedEENamespaceContextSelector namespaceContextSelectorInjectedValue, ClassLoader classLoader, List<SetupAction> setupActions, String hostUrl, CallbackHandler callbackHandler) {
        this.mainMethod = mainMethod;
        this.parameters = parameters;
        this.namespaceContextSelectorInjectedValue = namespaceContextSelectorInjectedValue;
        this.classLoader = classLoader;
        this.hostUrl = hostUrl;
        this.setupActions = setupActions;
        this.contextSelector = new LazyConnectionContextSelector(hostUrl, callbackHandler);
    }

    public ApplicationClientStartService(Method mainMethod, String[] parameters, InjectedEENamespaceContextSelector namespaceContextSelectorInjectedValue, ClassLoader classLoader, List<SetupAction> setupActions, EJBClientConfiguration configuration) {
        this.mainMethod = mainMethod;
        this.parameters = parameters;
        this.namespaceContextSelectorInjectedValue = namespaceContextSelectorInjectedValue;
        this.classLoader = classLoader;
        this.hostUrl = null;
        this.setupActions = setupActions;
        this.contextSelector = new ConfigBasedEJBClientContextSelector(configuration);
    }

    public synchronized void start(StartContext context) throws StartException {
        final ServiceContainer serviceContainer = context.getController().getServiceContainer();
        this.thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ClassLoader oldTccl = SecurityActions.getContextClassLoader();
                try {
                    try {
                        try {
                            SecurityActions.setContextClassLoader(ApplicationClientStartService.this.classLoader);
                            AccessController.doPrivileged(new SetSelectorAction(ApplicationClientStartService.this.contextSelector));
                            ((ApplicationClientDeploymentService)ApplicationClientStartService.this.applicationClientDeploymentServiceInjectedValue.getValue()).getDeploymentCompleteLatch().await();
                            NamespaceContextSelector.setDefault((NamespaceContextSelector)ApplicationClientStartService.this.namespaceContextSelectorInjectedValue);
                            try {
                                for (SetupAction action : ApplicationClientStartService.this.setupActions) {
                                    action.setup(Collections.emptyMap());
                                }
                                ApplicationClientStartService.this.instance = ((Component)ApplicationClientStartService.this.applicationClientComponent.getValue()).createInstance();
                                ApplicationClientStartService.this.mainMethod.invoke(null, new Object[]{ApplicationClientStartService.this.parameters});
                            }
                            finally {
                                ListIterator iterator = ApplicationClientStartService.this.setupActions.listIterator(ApplicationClientStartService.this.setupActions.size());
                                Throwable error = null;
                                while (iterator.hasPrevious()) {
                                    SetupAction action = (SetupAction)iterator.previous();
                                    try {
                                        action.teardown(Collections.emptyMap());
                                    }
                                    catch (Throwable e) {
                                        error = e;
                                    }
                                }
                                if (error != null) {
                                    throw new RuntimeException(error);
                                }
                            }
                        }
                        catch (Exception e) {
                            AppClientLogger.ROOT_LOGGER.exceptionRunningAppClient(e, e.getClass().getSimpleName());
                        }
                        finally {
                            SecurityActions.setContextClassLoader(oldTccl);
                        }
                    }
                    finally {
                        if (ApplicationClientStartService.this.contextSelector instanceof LazyConnectionContextSelector) {
                            ((LazyConnectionContextSelector)ApplicationClientStartService.this.contextSelector).close();
                        }
                    }
                }
                finally {
                    serviceContainer.shutdown();
                }
            }
        });
        this.thread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (serviceContainer != null) {
                    serviceContainer.shutdown();
                }
            }
        }));
    }

    public synchronized void stop(StopContext context) {
        if (this.instance != null) {
            this.instance.destroy();
        }
        this.thread.interrupt();
        this.thread = null;
    }

    public ApplicationClientStartService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<ApplicationClientDeploymentService> getApplicationClientDeploymentServiceInjectedValue() {
        return this.applicationClientDeploymentServiceInjectedValue;
    }

    public InjectedValue<Component> getApplicationClientComponent() {
        return this.applicationClientComponent;
    }

    private static final class SetSelectorAction
    implements PrivilegedAction<ContextSelector<EJBClientContext>> {
        private final ContextSelector<EJBClientContext> selector;

        private SetSelectorAction(ContextSelector<EJBClientContext> selector) {
            this.selector = selector;
        }

        @Override
        public ContextSelector<EJBClientContext> run() {
            return EJBClientContext.setSelector(this.selector);
        }
    }
}

