/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.ejb;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.as.weld.WeldBootstrapService;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.jboss.weld.context.WeldCreationalContext;
import org.jboss.weld.context.ejb.EjbLiteral;
import org.jboss.weld.context.ejb.EjbRequestContext;
import org.jboss.weld.manager.BeanManagerImpl;

public class EjbRequestScopeActivationInterceptor
implements Serializable,
Interceptor {
    private volatile EjbRequestContext requestContext;
    private volatile BeanManagerImpl beanManager;
    private final ServiceName weldContainerServiceName;

    public EjbRequestScopeActivationInterceptor(ServiceName weldContainerServiceName) {
        this.weldContainerServiceName = weldContainerServiceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        if (this.beanManager == null) {
            WeldBootstrapService weldContainer = (WeldBootstrapService)EjbRequestScopeActivationInterceptor.currentServiceContainer().getRequiredService(this.weldContainerServiceName).getValue();
            this.beanManager = (BeanManagerImpl)weldContainer.getBeanManager();
        }
        try {
            this.beanManager.getContext(RequestScoped.class);
            return context.proceed();
        }
        catch (ContextNotActiveException exception) {
            if (this.requestContext == null) {
                Bean bean = this.beanManager.resolve(this.beanManager.getBeans(EjbRequestContext.class, new Annotation[]{EjbLiteral.INSTANCE}));
                WeldCreationalContext ctx = this.beanManager.createCreationalContext((Contextual)bean);
                this.requestContext = (EjbRequestContext)this.beanManager.getReference(bean, EjbRequestContext.class, (CreationalContext)ctx);
            }
            try {
                this.requestContext.associate((Object)context.getInvocationContext());
                this.requestContext.activate();
                Object object = context.proceed();
                return object;
            }
            finally {
                this.requestContext.invalidate();
                this.requestContext.deactivate();
                this.requestContext.dissociate((Object)context.getInvocationContext());
            }
        }
    }

    private static ServiceContainer currentServiceContainer() {
        if (System.getSecurityManager() == null) {
            return CurrentServiceContainer.getServiceContainer();
        }
        return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
    }

    public static class Factory
    implements InterceptorFactory {
        private final Interceptor interceptor;

        public Factory(ServiceName weldContainerServiceName) {
            this.interceptor = new EjbRequestScopeActivationInterceptor(weldContainerServiceName);
        }

        public Interceptor create(InterceptorFactoryContext context) {
            return this.interceptor;
        }
    }
}

