/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.as.cli.CliEvent;
import org.jboss.as.cli.CliEventListener;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.OperationCommand;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.HeadersArgumentValueConverter;
import org.jboss.as.cli.impl.RequestParameterArgument;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.operation.impl.HeadersCompleter;
import org.jboss.as.cli.parsing.ParserUtil;
import org.jboss.as.cli.util.SimpleTable;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public abstract class BaseOperationCommand
extends CommandHandlerWithHelp
implements OperationCommand,
CliEventListener {
    protected List<RequestParameterArgument> params = new ArrayList<RequestParameterArgument>();
    protected OperationRequestAddress requiredAddress;
    private boolean dependsOnProfile;
    private Boolean addressAvailable;
    private String requiredType;
    protected final ArgumentWithValue headers;

    public BaseOperationCommand(CommandContext ctx, String command, boolean connectionRequired) {
        super(command, connectionRequired);
        ctx.addEventListener(this);
        this.headers = new ArgumentWithValue((CommandHandlerWithArguments)this, (CommandLineCompleter)HeadersCompleter.INSTANCE, HeadersArgumentValueConverter.INSTANCE, "--headers");
    }

    protected void addRequiredPath(String requiredPath) {
        if (requiredPath == null) {
            throw new IllegalArgumentException("Required path can't be null.");
        }
        DefaultOperationRequestAddress requiredAddress = new DefaultOperationRequestAddress();
        DefaultCallbackHandler handler = new DefaultCallbackHandler(requiredAddress);
        try {
            ParserUtil.parseOperationRequest(requiredPath, handler);
        }
        catch (CommandFormatException e) {
            throw new IllegalArgumentException("Failed to parse nodeType: " + e.getMessage());
        }
        this.addRequiredPath(requiredAddress);
    }

    protected void addRequiredPath(OperationRequestAddress requiredPath) {
        if (requiredPath == null) {
            throw new IllegalArgumentException("Required path can't be null.");
        }
        if (this.requiredAddress != null) {
            throw new IllegalStateException("Only one required address is allowed, atm.");
        }
        this.requiredAddress = requiredPath;
        Iterator iterator = this.requiredAddress.iterator();
        if (iterator.hasNext()) {
            String firstType = ((OperationRequestAddress.Node)iterator.next()).getType();
            boolean bl = this.dependsOnProfile = "subsystem".equals(firstType) || "profile".equals(firstType);
        }
        if (this.requiredAddress.endsOnType()) {
            this.requiredType = this.requiredAddress.toParentNode().getType();
        }
    }

    protected boolean isDependsOnProfile() {
        return this.dependsOnProfile;
    }

    protected OperationRequestAddress getRequiredAddress() {
        return this.requiredAddress;
    }

    protected String getRequiredType() {
        return this.requiredType;
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        if (!super.isAvailable(ctx)) {
            return false;
        }
        if (this.requiredAddress == null) {
            return true;
        }
        if (this.dependsOnProfile && ctx.isDomainMode()) {
            return true;
        }
        if (this.addressAvailable != null) {
            return this.addressAvailable;
        }
        ModelControllerClient client = ctx.getModelControllerClient();
        if (client == null) {
            return false;
        }
        ModelNode request = new ModelNode();
        ModelNode address = request.get("address");
        if (this.requiredType == null) {
            ModelNode response;
            address.setEmptyList();
            request.get("operation").set("validate-address");
            ModelNode addressValue = request.get("value");
            for (OperationRequestAddress.Node node : this.requiredAddress) {
                addressValue.add(node.getType(), node.getName());
            }
            try {
                response = ctx.getModelControllerClient().execute(request);
            }
            catch (IOException e) {
                return false;
            }
            ModelNode result = response.get("result");
            if (!result.isDefined()) {
                return false;
            }
            ModelNode valid = result.get("valid");
            if (!valid.isDefined()) {
                return false;
            }
            this.addressAvailable = valid.asBoolean();
        } else {
            ModelNode result;
            for (OperationRequestAddress.Node node : this.requiredAddress) {
                address.add(node.getType(), node.getName());
            }
            request.get("operation").set("read-children-types");
            try {
                result = ctx.getModelControllerClient().execute(request);
            }
            catch (IOException e) {
                return false;
            }
            this.addressAvailable = Util.listContains(result, this.requiredType);
        }
        return this.addressAvailable;
    }

    @Override
    public void cliEvent(CliEvent event, CommandContext ctx) {
        if (event == CliEvent.DISCONNECTED) {
            this.addressAvailable = null;
        }
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        ModelNode response;
        ModelNode request = this.buildRequest(ctx);
        ModelControllerClient client = ctx.getModelControllerClient();
        try {
            response = client.execute(request);
        }
        catch (Exception e) {
            throw new CommandFormatException("Failed to perform operation: " + e.getLocalizedMessage());
        }
        if (!Util.isSuccess(response)) {
            throw new CommandFormatException(Util.getFailureDescription(response));
        }
        this.handleResponse(ctx, response, "composite".equals(request.get("operation").asString()));
    }

    @Override
    public ModelNode buildRequest(CommandContext ctx) throws CommandFormatException {
        this.recognizeArguments(ctx);
        return this.buildRequestWOValidation(ctx);
    }

    protected ModelNode buildRequestWOValidation(CommandContext ctx) throws CommandFormatException {
        ModelNode request = this.buildRequestWithoutHeaders(ctx);
        this.addHeaders(ctx, request);
        return request;
    }

    protected abstract ModelNode buildRequestWithoutHeaders(CommandContext var1) throws CommandFormatException;

    protected void addHeaders(CommandContext ctx, ModelNode request) throws CommandFormatException {
        if (!this.headers.isPresent(ctx.getParsedCommandLine())) {
            return;
        }
        String headersValue = this.headers.getValue(ctx.getParsedCommandLine());
        ModelNode headersNode = this.headers.getValueConverter().fromString(ctx, headersValue);
        ModelNode opHeaders = request.get("operation-headers");
        opHeaders.set(headersNode);
    }

    protected void handleResponse(CommandContext ctx, ModelNode response, boolean composite) throws CommandLineException {
        this.displayResponseHeaders(ctx, response);
    }

    protected void displayResponseHeaders(CommandContext ctx, ModelNode response) {
        if (response.has("response-headers")) {
            ModelNode headers = response.get("response-headers");
            Set keys = headers.keys();
            SimpleTable table = new SimpleTable(2);
            for (String key : keys) {
                table.addLine(new String[]{key + ':', headers.get(key).asString()});
            }
            StringBuilder buf = new StringBuilder();
            table.append(buf, true);
            ctx.printLine(buf.toString());
        }
    }

    @Override
    public void addArgument(CommandArgument arg) {
        super.addArgument(arg);
        if (arg instanceof RequestParameterArgument) {
            this.params.add((RequestParameterArgument)arg);
        }
    }

    protected void setParams(CommandContext ctx, ModelNode request) throws CommandFormatException {
        for (RequestParameterArgument arg : this.params) {
            arg.set(ctx.getParsedCommandLine(), request);
        }
    }
}

