/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.validator.MessageFactory;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class LongRangeValidator
implements Validator,
StateHolder {
    public static final String VALIDATOR_ID = "javax.faces.LongRange";
    public static final String MAXIMUM_MESSAGE_ID = "javax.faces.validator.LongRangeValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "javax.faces.validator.LongRangeValidator.MINIMUM";
    public static final String NOT_IN_RANGE_MESSAGE_ID = "javax.faces.validator.LongRangeValidator.NOT_IN_RANGE";
    public static final String TYPE_MESSAGE_ID = "javax.faces.validator.LongRangeValidator.TYPE";
    private Long maximum;
    private Long minimum;
    private boolean transientValue = false;

    public LongRangeValidator() {
    }

    public LongRangeValidator(long l) {
        this.setMaximum(l);
    }

    public LongRangeValidator(long l, long l2) {
        this.setMaximum(l);
        this.setMinimum(l2);
    }

    public long getMaximum() {
        return this.maximum != null ? this.maximum : 0L;
    }

    public void setMaximum(long l) {
        this.maximum = l;
    }

    public long getMinimum() {
        return this.minimum != null ? this.minimum : 0L;
    }

    public void setMinimum(long l) {
        this.minimum = l;
    }

    public void validate(FacesContext facesContext, UIComponent uIComponent, Object object) throws ValidatorException {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException();
        }
        if (object != null) {
            try {
                long l = LongRangeValidator.longValue(object);
                if (this.isMaximumSet() && l > this.maximum) {
                    if (this.isMinimumSet()) {
                        throw new ValidatorException(MessageFactory.getMessage(facesContext, NOT_IN_RANGE_MESSAGE_ID, LongRangeValidator.stringValue(uIComponent, this.minimum, facesContext), LongRangeValidator.stringValue(uIComponent, this.maximum, facesContext), MessageFactory.getLabel(facesContext, uIComponent)));
                    }
                    throw new ValidatorException(MessageFactory.getMessage(facesContext, MAXIMUM_MESSAGE_ID, LongRangeValidator.stringValue(uIComponent, this.maximum, facesContext), MessageFactory.getLabel(facesContext, uIComponent)));
                }
                if (this.isMinimumSet() && l < this.minimum) {
                    if (this.isMaximumSet()) {
                        throw new ValidatorException(MessageFactory.getMessage(facesContext, NOT_IN_RANGE_MESSAGE_ID, LongRangeValidator.stringValue(uIComponent, this.minimum, facesContext), LongRangeValidator.stringValue(uIComponent, this.maximum, facesContext), MessageFactory.getLabel(facesContext, uIComponent)));
                    }
                    throw new ValidatorException(MessageFactory.getMessage(facesContext, MINIMUM_MESSAGE_ID, LongRangeValidator.stringValue(uIComponent, this.minimum, facesContext), MessageFactory.getLabel(facesContext, uIComponent)));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ValidatorException(MessageFactory.getMessage(facesContext, TYPE_MESSAGE_ID, MessageFactory.getLabel(facesContext, uIComponent)), (Throwable)numberFormatException);
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof LongRangeValidator)) {
            return false;
        }
        LongRangeValidator longRangeValidator = (LongRangeValidator)object;
        return this.getMaximum() == longRangeValidator.getMaximum() && this.getMinimum() == longRangeValidator.getMinimum() && this.isMaximumSet() == longRangeValidator.isMaximumSet() && this.isMinimumSet() == longRangeValidator.isMinimumSet();
    }

    public int hashCode() {
        int n = Long.valueOf(this.getMinimum()).hashCode() + Long.valueOf(this.getMaximum()).hashCode() + Boolean.valueOf(this.isMinimumSet()).hashCode() + Boolean.valueOf(this.isMaximumSet()).hashCode();
        return n;
    }

    private static long longValue(Object object) throws NumberFormatException {
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        return Long.parseLong(object.toString());
    }

    private static String stringValue(UIComponent uIComponent, Long l, FacesContext facesContext) {
        Converter converter = facesContext.getApplication().createConverter("javax.faces.Number");
        return converter.getAsString(facesContext, uIComponent, l);
    }

    private boolean isMinimumSet() {
        return this.minimum != null;
    }

    private boolean isMaximumSet() {
        return this.maximum != null;
    }

    public Object saveState(FacesContext facesContext) {
        Object[] objectArray = new Object[]{this.maximum, this.minimum};
        return objectArray;
    }

    public void restoreState(FacesContext facesContext, Object object) {
        Object[] objectArray = (Object[])object;
        this.maximum = (Long)objectArray[0];
        this.minimum = (Long)objectArray[1];
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean bl) {
        this.transientValue = bl;
    }
}

