/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import javax.jms.JMSException;
import javax.jms.TextMessage;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.jms.client.HornetQMessage;

public class HornetQTextMessage
extends HornetQMessage
implements TextMessage {
    public static final byte TYPE = 3;
    private SimpleString text;

    public HornetQTextMessage(ClientSession session) {
        super((byte)3, session);
    }

    public HornetQTextMessage(ClientMessage message, ClientSession session) {
        super(message, session);
    }

    public HornetQTextMessage(TextMessage foreign, ClientSession session) throws JMSException {
        super(foreign, (byte)3, session);
        this.setText(foreign.getText());
    }

    @Override
    public byte getType() {
        return 3;
    }

    @Override
    public void setText(String text) throws JMSException {
        this.checkWrite();
        HornetQBuffer buff = this.message.getBodyBuffer();
        buff.clear();
        this.text = text != null ? new SimpleString(text) : null;
        buff.writeNullableSimpleString(this.text);
    }

    @Override
    public String getText() throws JMSException {
        if (this.text != null) {
            return this.text.toString();
        }
        return null;
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.text = null;
    }

    @Override
    public void doBeforeSend() throws Exception {
        super.doBeforeSend();
    }

    @Override
    public void doBeforeReceive() throws HornetQException {
        super.doBeforeReceive();
        this.text = this.message.getBodyBuffer().readNullableSimpleString();
    }
}

