/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.dependencies;

import javax.xml.namespace.QName;
import org.jboss.as.server.DeployerChainAddHandler;
import org.jboss.as.server.ServerLogger;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentCompleteServiceProcessor;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.deployment.dependencies.DeploymentDependencies;
import org.jboss.as.server.deployment.dependencies.DeploymentDependenciesParserV_1_0;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXmlParserRegisteringProcessor;
import org.jboss.msc.service.ServiceName;

public class DeploymentDependenciesProcessor
implements DeploymentUnitProcessor {
    private static final QName ROOT_1_0 = new QName("urn:jboss:deployment-dependencies:1.0", "jboss-deployment-dependencies");

    public static void registerJBossXMLParsers() {
        DeployerChainAddHandler.addDeploymentProcessor("server", Phase.STRUCTURE, 2581, new JBossAllXmlParserRegisteringProcessor<DeploymentDependencies>(ROOT_1_0, DeploymentDependencies.ATTACHMENT_KEY, DeploymentDependenciesParserV_1_0.INSTANCE));
    }

    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit parent;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.hasAttachment(DeploymentDependencies.ATTACHMENT_KEY)) {
            if (deploymentUnit.getParent() != null) {
                ServerLogger.DEPLOYMENT_LOGGER.deploymentDependenciesAreATopLevelElement(deploymentUnit.getName());
            } else {
                this.processDependencies(phaseContext, deploymentUnit);
            }
        }
        if (deploymentUnit.getParent() != null && (parent = deploymentUnit.getParent()).hasAttachment(DeploymentDependencies.ATTACHMENT_KEY)) {
            this.processDependencies(phaseContext, parent);
        }
    }

    private void processDependencies(DeploymentPhaseContext phaseContext, DeploymentUnit deploymentUnit) {
        DeploymentDependencies deps = deploymentUnit.getAttachment(DeploymentDependencies.ATTACHMENT_KEY);
        if (!deps.getDependencies().isEmpty()) {
            for (String deployment : deps.getDependencies()) {
                ServiceName name = DeploymentCompleteServiceProcessor.serviceName(Services.deploymentUnitName(deployment));
                phaseContext.addToAttachmentList(Attachments.NEXT_PHASE_DEPS, name);
            }
        }
    }

    @Override
    public void undeploy(DeploymentUnit context) {
    }
}

