/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.persistence.ValidationMode;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolverHolder;
import javax.sql.DataSource;
import javax.validation.ValidatorFactory;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.jpa.JpaLogger;
import org.jboss.as.jpa.JpaMessages;
import org.jboss.as.jpa.config.Configuration;
import org.jboss.as.jpa.config.PersistenceProviderDeploymentHolder;
import org.jboss.as.jpa.config.PersistenceUnitMetadataHolder;
import org.jboss.as.jpa.config.PersistenceUnitsInApplication;
import org.jboss.as.jpa.container.TransactionScopedEntityManager;
import org.jboss.as.jpa.persistenceprovider.PersistenceProviderLoader;
import org.jboss.as.jpa.processor.JpaAttachments;
import org.jboss.as.jpa.processor.PersistenceProviderAdaptorLoader;
import org.jboss.as.jpa.service.JPAService;
import org.jboss.as.jpa.service.PersistenceUnitServiceImpl;
import org.jboss.as.jpa.spi.ManagementAdaptor;
import org.jboss.as.jpa.spi.PersistenceProviderAdaptor;
import org.jboss.as.jpa.spi.PersistenceUnitMetadata;
import org.jboss.as.jpa.subsystem.PersistenceUnitRegistryImpl;
import org.jboss.as.jpa.validator.SerializableValidatorFactory;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentModelUtils;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.JPADeploymentMarker;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.dmr.ModelNode;
import org.jboss.jandex.Index;
import org.jboss.metadata.web.jboss.ValveMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.inject.CastingInjector;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class PersistenceUnitServiceHandler {
    public static final String ENTITYMANAGERFACTORY_JNDI_PROPERTY = "jboss.entity.manager.factory.jndi.name";
    public static final String ENTITYMANAGER_JNDI_PROPERTY = "jboss.entity.manager.jndi.name";
    private static final AttachmentKey<Map<String, PersistenceProviderAdaptor>> providerAdaptorMapKey = AttachmentKey.create(Map.class);
    private static final String SCOPED_UNIT_NAME = "scoped-unit-name";
    private static AttachmentKey<AttachmentList<PersistenceAdaptorRemoval>> REMOVAL_KEY = AttachmentKey.createList(PersistenceAdaptorRemoval.class);

    public static void deploy(DeploymentPhaseContext phaseContext, boolean startEarly) throws DeploymentUnitProcessingException {
        PersistenceUnitServiceHandler.handleWarDeployment(phaseContext, startEarly);
        PersistenceUnitServiceHandler.handleEarDeployment(phaseContext, startEarly);
        PersistenceUnitServiceHandler.handleJarDeployment(phaseContext, startEarly);
        if (startEarly) {
            PersistenceUnitServiceHandler.nextPhaseDependsOnPersistenceUnit(phaseContext);
        }
    }

    public static void undeploy(DeploymentUnit context) {
        List removals = context.getAttachmentList(REMOVAL_KEY);
        if (removals != null) {
            for (PersistenceAdaptorRemoval removal : removals) {
                removal.cleanup();
            }
            context.removeAttachment(REMOVAL_KEY);
        }
    }

    private static void handleJarDeployment(DeploymentPhaseContext phaseContext, boolean startEarly) throws DeploymentUnitProcessingException {
        PersistenceUnitMetadataHolder holder;
        ResourceRoot deploymentRoot;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!PersistenceUnitServiceHandler.isEarDeployment(deploymentUnit) && !PersistenceUnitServiceHandler.isWarDeployment(deploymentUnit) && JPADeploymentMarker.isJPADeployment((DeploymentUnit)deploymentUnit) && (deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)) != null && (holder = (PersistenceUnitMetadataHolder)deploymentRoot.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS)) != null && holder.getPersistenceUnits().size() > 0) {
            ArrayList<PersistenceUnitMetadataHolder> puList = new ArrayList<PersistenceUnitMetadataHolder>(1);
            puList.add(holder);
            JpaLogger.JPA_LOGGER.tracef("install persistence unit definition for jar %s", (Object)deploymentRoot.getRootName());
            PersistenceUnitServiceHandler.addPuService(phaseContext, puList, startEarly);
        }
    }

    private static void handleWarDeployment(DeploymentPhaseContext phaseContext, boolean startEarly) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (PersistenceUnitServiceHandler.isWarDeployment(deploymentUnit) && JPADeploymentMarker.isJPADeployment((DeploymentUnit)deploymentUnit)) {
            PersistenceUnitMetadataHolder holder;
            ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
            ArrayList<PersistenceUnitMetadataHolder> puList = new ArrayList<PersistenceUnitMetadataHolder>(1);
            if (deploymentRoot != null && (holder = (PersistenceUnitMetadataHolder)deploymentRoot.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS)) != null && holder.getPersistenceUnits().size() > 0) {
                puList.add(holder);
            }
            List resourceRoots = deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS);
            for (ResourceRoot resourceRoot : resourceRoots) {
                if (!resourceRoot.getRoot().getName().toLowerCase(Locale.ENGLISH).endsWith(".jar") || (holder = (PersistenceUnitMetadataHolder)resourceRoot.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS)) == null || holder.getPersistenceUnits().size() <= 0) continue;
                puList.add(holder);
            }
            WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
            if (warMetaData != null && warMetaData.getMergedJBossWebMetaData() != null) {
                ArrayList<ValveMetaData> valves = warMetaData.getMergedJBossWebMetaData().getValves();
                if (valves == null) {
                    valves = new ArrayList<ValveMetaData>();
                    warMetaData.getMergedJBossWebMetaData().setValves(valves);
                }
                ValveMetaData valve = new ValveMetaData();
                valve.setModule("org.jboss.as.jpa");
                valve.setValveClass("org.jboss.as.jpa.interceptor.WebNonTxEmCloserValve");
                valves.add(valve);
            }
            JpaLogger.JPA_LOGGER.tracef("install persistence unit definitions for war %s", (Object)deploymentRoot.getRootName());
            PersistenceUnitServiceHandler.addPuService(phaseContext, puList, startEarly);
        }
    }

    private static void handleEarDeployment(DeploymentPhaseContext phaseContext, boolean startEarly) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (PersistenceUnitServiceHandler.isEarDeployment(deploymentUnit) && JPADeploymentMarker.isJPADeployment((DeploymentUnit)deploymentUnit)) {
            List deploymentRoots = DeploymentUtils.allResourceRoots((DeploymentUnit)deploymentUnit);
            for (ResourceRoot root : deploymentRoots) {
                PersistenceUnitMetadataHolder holder;
                if (SubDeploymentMarker.isSubDeployment((ResourceRoot)root)) continue;
                ArrayList<PersistenceUnitMetadataHolder> puList = new ArrayList<PersistenceUnitMetadataHolder>(1);
                if (root != null && (holder = (PersistenceUnitMetadataHolder)root.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS)) != null && holder.getPersistenceUnits().size() > 0) {
                    puList.add(holder);
                }
                JpaLogger.JPA_LOGGER.tracef("install persistence unit definitions for ear %s", (Object)root.getRootName());
                PersistenceUnitServiceHandler.addPuService(phaseContext, puList, startEarly);
            }
        }
    }

    private static void addPuService(DeploymentPhaseContext phaseContext, ArrayList<PersistenceUnitMetadataHolder> puList, boolean startEarly) throws DeploymentUnitProcessingException {
        if (puList.size() > 0) {
            DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
            Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
            EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
            Collection components = eeModuleDescription.getComponentDescriptions();
            if (module == null) {
                JpaLogger.ROOT_LOGGER.failedToGetModuleAttachment(deploymentUnit);
                return;
            }
            ServiceTarget serviceTarget = phaseContext.getServiceTarget();
            ModuleClassLoader classLoader = module.getClassLoader();
            PersistenceProviderDeploymentHolder persistenceProviderDeploymentHolder = PersistenceUnitServiceHandler.getPersistenceProviderDeploymentHolder(deploymentUnit);
            for (PersistenceUnitMetadataHolder holder : puList) {
                PersistenceUnitServiceHandler.setAnnotationIndexes(holder, deploymentUnit);
                for (PersistenceUnitMetadata pu : holder.getPersistenceUnits()) {
                    String jpaContainerManaged = pu.getProperties().getProperty("jboss.as.jpa.managed");
                    boolean deployPU = jpaContainerManaged == null ? true : Boolean.parseBoolean(jpaContainerManaged);
                    boolean needClassTransformer = Configuration.needClassFileTransformer(pu);
                    boolean startThisPu = false;
                    if (deployPU) {
                        if (startEarly) {
                            if (!needClassTransformer) {
                                JpaLogger.JPA_LOGGER.tracef("persistence unit %s in deployment %s is configured to not need class transformer to be set, no class rewriting will be allowed", (Object)pu.getPersistenceUnitName(), (Object)deploymentUnit.getName());
                            } else {
                                startThisPu = true;
                            }
                        } else if (!needClassTransformer) {
                            startThisPu = true;
                        }
                        if (!startThisPu) continue;
                        PersistenceUnitServiceHandler.deployPersistenceUnit(phaseContext, deploymentUnit, eeModuleDescription, components, serviceTarget, classLoader, persistenceProviderDeploymentHolder, pu, startEarly);
                        continue;
                    }
                    JpaLogger.JPA_LOGGER.tracef("persistence unit %s in deployment %s is not container managed (%s is set to false)", (Object)pu.getPersistenceUnitName(), (Object)deploymentUnit.getName(), (Object)"jboss.as.jpa.managed");
                }
            }
        }
    }

    private static void deployPersistenceUnit(DeploymentPhaseContext phaseContext, DeploymentUnit deploymentUnit, EEModuleDescription eeModuleDescription, Collection<ComponentDescription> components, ServiceTarget serviceTarget, ModuleClassLoader classLoader, PersistenceProviderDeploymentHolder persistenceProviderDeploymentHolder, final PersistenceUnitMetadata pu, boolean startEarly) throws DeploymentUnitProcessingException {
        pu.setClassLoader((ClassLoader)classLoader);
        try {
            BinderService binderService;
            ContextNames.BindInfo bindingInfo;
            String jndiName;
            String defaultJtaDataSource;
            HashMap<String, ValidatorFactory> properties = new HashMap<String, ValidatorFactory>();
            if (!ValidationMode.NONE.equals((Object)pu.getValidationMode())) {
                ValidatorFactory validatorFactory = SerializableValidatorFactory.validatorFactory();
                properties.put("javax.persistence.validation.factory", validatorFactory);
            }
            PersistenceProviderAdaptor adaptor = PersistenceUnitServiceHandler.getPersistenceProviderAdaptor(pu, persistenceProviderDeploymentHolder, deploymentUnit);
            PersistenceProvider provider = null;
            if (persistenceProviderDeploymentHolder != null && persistenceProviderDeploymentHolder.getProvider() != null) {
                List<PersistenceProvider> providerList = persistenceProviderDeploymentHolder.getProvider();
                for (PersistenceProvider persistenceProvider : providerList) {
                    if (!persistenceProvider.getClass().getName().equals(pu.getPersistenceProviderClassName())) continue;
                    provider = persistenceProvider;
                    JpaLogger.JPA_LOGGER.tracef("deployment %s is using its own copy of %s", (Object)deploymentUnit.getName(), (Object)pu.getPersistenceProviderClassName());
                    break;
                }
            }
            if (provider == null) {
                provider = PersistenceUnitServiceHandler.lookupProvider(pu);
            }
            PersistenceUnitServiceImpl service = new PersistenceUnitServiceImpl((ClassLoader)classLoader, pu, adaptor, provider, PersistenceUnitRegistryImpl.INSTANCE, deploymentUnit.getServiceName());
            deploymentUnit.addToAttachmentList(REMOVAL_KEY, (Object)new PersistenceAdaptorRemoval(pu, adaptor));
            adaptor.addProviderProperties(properties, pu);
            ServiceName puServiceName = PersistenceUnitServiceImpl.getPUServiceName(pu);
            deploymentUnit.putAttachment(JpaAttachments.PERSISTENCE_UNIT_SERVICE_KEY, (Object)puServiceName);
            deploymentUnit.addToAttachmentList(Attachments.DEPLOYMENT_COMPLETE_SERVICES, (Object)puServiceName);
            PersistenceUnitServiceHandler.addPUServiceDependencyToComponents(components, puServiceName);
            deploymentUnit.addToAttachmentList(Attachments.WEB_DEPENDENCIES, (Object)puServiceName);
            ServiceBuilder builder = serviceTarget.addService(puServiceName, (Service)service);
            boolean useDefaultDataSource = true;
            String jtaDataSource = PersistenceUnitServiceHandler.adjustJndi(pu.getJtaDataSourceName());
            String nonJtaDataSource = PersistenceUnitServiceHandler.adjustJndi(pu.getNonJtaDataSourceName());
            if (jtaDataSource != null && jtaDataSource.length() > 0) {
                if (jtaDataSource.startsWith("java:")) {
                    builder.addDependency(ContextNames.bindInfoForEnvEntry((String)eeModuleDescription.getApplicationName(), (String)eeModuleDescription.getModuleName(), (String)eeModuleDescription.getModuleName(), (boolean)false, (String)jtaDataSource).getBinderServiceName(), ManagedReferenceFactory.class, (Injector)new ManagedReferenceFactoryInjector(service.getJtaDataSourceInjector()));
                    useDefaultDataSource = false;
                } else {
                    builder.addDependency(AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{jtaDataSource}), (Injector)new CastingInjector(service.getJtaDataSourceInjector(), DataSource.class));
                    useDefaultDataSource = false;
                }
            }
            if (nonJtaDataSource != null && nonJtaDataSource.length() > 0) {
                if (nonJtaDataSource.startsWith("java:")) {
                    builder.addDependency(ContextNames.bindInfoForEnvEntry((String)eeModuleDescription.getApplicationName(), (String)eeModuleDescription.getModuleName(), (String)eeModuleDescription.getModuleName(), (boolean)false, (String)nonJtaDataSource).getBinderServiceName(), ManagedReferenceFactory.class, (Injector)new ManagedReferenceFactoryInjector(service.getNonJtaDataSourceInjector()));
                    useDefaultDataSource = false;
                } else {
                    builder.addDependency(AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{nonJtaDataSource}), (Injector)new CastingInjector(service.getNonJtaDataSourceInjector(), DataSource.class));
                    useDefaultDataSource = false;
                }
            }
            if (useDefaultDataSource && (defaultJtaDataSource = PersistenceUnitServiceHandler.adjustJndi(JPAService.getDefaultDataSourceName())) != null && defaultJtaDataSource.length() > 0) {
                builder.addDependency(AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{defaultJtaDataSource}), (Injector)new CastingInjector(service.getJtaDataSourceInjector(), DataSource.class));
                JpaLogger.JPA_LOGGER.tracef("%s is using the default data source '%s'", (Object)puServiceName, (Object)defaultJtaDataSource);
            }
            adaptor.addProviderDependencies(phaseContext.getServiceRegistry(), serviceTarget, builder, pu);
            if (pu.getProperties().containsKey(ENTITYMANAGER_JNDI_PROPERTY)) {
                jndiName = pu.getProperties().get(ENTITYMANAGER_JNDI_PROPERTY).toString();
                bindingInfo = jndiName.startsWith("java:") ? ContextNames.bindInfoForEnvEntry((String)eeModuleDescription.getApplicationName(), (String)eeModuleDescription.getModuleName(), (String)eeModuleDescription.getModuleName(), (boolean)false, (String)jndiName) : ContextNames.bindInfoFor((String)jndiName);
                JpaLogger.JPA_LOGGER.tracef("binding the transaction scoped entity manager to jndi name '%s'", (Object)bindingInfo.getAbsoluteJndiName());
                binderService = new BinderService(bindingInfo.getBindName());
                serviceTarget.addService(bindingInfo.getBinderServiceName(), (Service)binderService).addDependency(bindingInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector()).addDependency(puServiceName, PersistenceUnitServiceImpl.class, (Injector)new Injector<PersistenceUnitServiceImpl>(){

                    public void inject(PersistenceUnitServiceImpl value) throws InjectionException {
                        binderService.getManagedObjectInjector().inject((Object)new ValueManagedReferenceFactory((Value)new ImmediateValue((Object)new TransactionScopedEntityManager(pu.getScopedPersistenceUnitName(), new HashMap(), value.getEntityManagerFactory()))));
                    }

                    public void uninject() {
                        binderService.getNamingStoreInjector().uninject();
                    }
                }).install();
            }
            if (pu.getProperties().containsKey(ENTITYMANAGERFACTORY_JNDI_PROPERTY)) {
                jndiName = pu.getProperties().get(ENTITYMANAGERFACTORY_JNDI_PROPERTY).toString();
                bindingInfo = jndiName.startsWith("java:") ? ContextNames.bindInfoForEnvEntry((String)eeModuleDescription.getApplicationName(), (String)eeModuleDescription.getModuleName(), (String)eeModuleDescription.getModuleName(), (boolean)false, (String)jndiName) : ContextNames.bindInfoFor((String)jndiName);
                JpaLogger.JPA_LOGGER.tracef("binding the entity manager factory to jndi name '%s'", (Object)bindingInfo.getAbsoluteJndiName());
                binderService = new BinderService(bindingInfo.getBindName());
                serviceTarget.addService(bindingInfo.getBinderServiceName(), (Service)binderService).addDependency(bindingInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector()).addDependency(puServiceName, PersistenceUnitServiceImpl.class, (Injector)new Injector<PersistenceUnitServiceImpl>(){

                    public void inject(PersistenceUnitServiceImpl value) throws InjectionException {
                        binderService.getManagedObjectInjector().inject((Object)new ValueManagedReferenceFactory((Value)new ImmediateValue((Object)value.getEntityManagerFactory())));
                    }

                    public void uninject() {
                        binderService.getNamingStoreInjector().uninject();
                    }
                }).install();
            }
            builder.setInitialMode(ServiceController.Mode.ACTIVE).addInjection(service.getPropertiesInjector(), properties);
            Services.addServerExecutorDependency((ServiceBuilder)builder, service.getExecutorInjector(), (boolean)false);
            builder.install();
            JpaLogger.JPA_LOGGER.tracef("added PersistenceUnitService for '%s'.  PU is ready for injector action.", (Object)puServiceName);
            PersistenceUnitServiceHandler.addManagementConsole(deploymentUnit, pu, adaptor);
        }
        catch (ServiceRegistryException e) {
            throw JpaMessages.MESSAGES.failedToAddPersistenceUnit((Throwable)e, pu.getPersistenceUnitName());
        }
    }

    private static void setAnnotationIndexes(PersistenceUnitMetadataHolder puHolder, DeploymentUnit deploymentUnit) {
        HashMap<URL, Index> annotationIndexes = new HashMap<URL, Index>();
        do {
            for (ResourceRoot root : DeploymentUtils.allResourceRoots((DeploymentUnit)deploymentUnit)) {
                Index index = (Index)root.getAttachment(Attachments.ANNOTATION_INDEX);
                if (index == null) continue;
                try {
                    JpaLogger.JPA_LOGGER.tracef("adding '%s' to annotation index map", (Object)root.getRoot().toURL());
                    annotationIndexes.put(root.getRoot().toURL(), index);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        } while ((deploymentUnit = deploymentUnit.getParent()) != null);
        for (PersistenceUnitMetadata pu : puHolder.getPersistenceUnits()) {
            pu.setAnnotationIndex(annotationIndexes);
        }
    }

    private static String adjustJndi(String dataSourceName) {
        if (dataSourceName != null && dataSourceName.length() > 0 && !dataSourceName.startsWith("java:")) {
            if (dataSourceName.startsWith("jboss/")) {
                return "java:" + dataSourceName;
            }
            return "java:/" + dataSourceName;
        }
        return dataSourceName;
    }

    private static PersistenceProviderAdaptor getPersistenceProviderAdaptor(PersistenceUnitMetadata pu, PersistenceProviderDeploymentHolder persistenceProviderDeploymentHolder, DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        String adaptorModule = pu.getProperties().getProperty("jboss.as.jpa.adapterModule");
        PersistenceProviderAdaptor adaptor = null;
        if (persistenceProviderDeploymentHolder != null) {
            adaptor = persistenceProviderDeploymentHolder.getAdapter();
        }
        if (adaptor == null) {
            if (adaptorModule == null && (pu.getPersistenceProviderClassName() == null || pu.getPersistenceProviderClassName().equals("org.hibernate.ejb.HibernatePersistence"))) {
                adaptorModule = "org.jboss.as.jpa.hibernate:4";
            }
            if ((adaptor = PersistenceUnitServiceHandler.getPerDeploymentSharedPersistenceProviderAdaptor(deploymentUnit, adaptorModule)) == null) {
                try {
                    adaptor = PersistenceProviderAdaptorLoader.loadPersistenceAdapterModule(adaptorModule);
                }
                catch (ModuleLoadException e) {
                    throw new DeploymentUnitProcessingException("persistence provider adapter module load error " + adaptorModule, (Throwable)e);
                }
                adaptor = PersistenceUnitServiceHandler.savePerDeploymentSharedPersistenceProviderAdaptor(deploymentUnit, adaptorModule, adaptor);
            }
        }
        if (adaptor == null) {
            throw JpaMessages.MESSAGES.failedToGetAdapter(pu.getPersistenceProviderClassName());
        }
        return adaptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PersistenceProviderAdaptor savePerDeploymentSharedPersistenceProviderAdaptor(DeploymentUnit deploymentUnit, String adaptorModule, PersistenceProviderAdaptor adaptor) {
        if (deploymentUnit.getParent() != null) {
            deploymentUnit = deploymentUnit.getParent();
        }
        DeploymentUnit deploymentUnit2 = deploymentUnit;
        synchronized (deploymentUnit2) {
            Map map = (Map)deploymentUnit.getAttachment(providerAdaptorMapKey);
            PersistenceProviderAdaptor current = (PersistenceProviderAdaptor)map.get(adaptorModule);
            if (current == null) {
                map.put(adaptorModule, adaptor);
                current = adaptor;
            }
            return current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PersistenceProviderAdaptor getPerDeploymentSharedPersistenceProviderAdaptor(DeploymentUnit deploymentUnit, String adaptorModule) {
        if (deploymentUnit.getParent() != null) {
            deploymentUnit = deploymentUnit.getParent();
        }
        DeploymentUnit deploymentUnit2 = deploymentUnit;
        synchronized (deploymentUnit2) {
            HashMap map = (HashMap)deploymentUnit.getAttachment(providerAdaptorMapKey);
            if (map == null) {
                map = new HashMap();
                deploymentUnit.putAttachment(providerAdaptorMapKey, map);
            }
            return (PersistenceProviderAdaptor)map.get(adaptorModule);
        }
    }

    private static PersistenceProvider lookupProvider(PersistenceUnitMetadata pu) throws DeploymentUnitProcessingException {
        PersistenceProvider provider;
        String persistenceProviderModule = pu.getProperties().getProperty("jboss.as.jpa.providerModule");
        String persistenceProviderClassName = pu.getPersistenceProviderClassName();
        if (persistenceProviderClassName == null) {
            persistenceProviderClassName = "org.hibernate.ejb.HibernatePersistence";
        }
        if (persistenceProviderModule == null) {
            persistenceProviderModule = Configuration.getProviderModuleNameFromProviderClassName(persistenceProviderClassName);
        }
        if ((provider = PersistenceUnitServiceHandler.getProviderByName(pu, persistenceProviderModule)) == null && persistenceProviderModule != null) {
            try {
                PersistenceProviderLoader.loadProviderModuleByName(persistenceProviderModule);
                provider = PersistenceUnitServiceHandler.getProviderByName(pu, persistenceProviderModule);
            }
            catch (ModuleLoadException e) {
                throw JpaMessages.MESSAGES.cannotLoadPersistenceProviderModule((Throwable)e, persistenceProviderModule, persistenceProviderClassName);
            }
        }
        if (provider == null) {
            throw JpaMessages.MESSAGES.persistenceProviderNotFound(persistenceProviderClassName);
        }
        return provider;
    }

    private static PersistenceProvider getProviderByName(PersistenceUnitMetadata pu, String persistenceProviderModule) {
        String providerName = pu.getPersistenceProviderClassName();
        List providers = PersistenceProviderResolverHolder.getPersistenceProviderResolver().getPersistenceProviders();
        for (PersistenceProvider provider : providers) {
            if (!provider.getClass().getName().equals(providerName)) continue;
            if (providerName.equals("org.hibernate.ejb.HibernatePersistence")) {
                if (!(persistenceProviderModule.equals("org.hibernate:3") ? PersistenceUnitServiceHandler.isHibernate3(provider) : !PersistenceUnitServiceHandler.isHibernate3(provider))) continue;
                return provider;
            }
            return provider;
        }
        return null;
    }

    private static boolean isHibernate3(PersistenceProvider provider) {
        boolean result = false;
        try {
            Class<?> targetCls = provider.getClass().getClassLoader().loadClass("org.hibernate.Version");
            Method m = targetCls.getMethod("getVersionString", new Class[0]);
            Object version = m.invoke(null, new Object[0]);
            JpaLogger.JPA_LOGGER.tracef("lookup provider checking provider version (%s)", version);
            if (version instanceof String && ((String)version).startsWith("3.")) {
                result = true;
            }
        }
        catch (ClassNotFoundException ignore) {
        }
        catch (NoSuchMethodException ignore) {
        }
        catch (InvocationTargetException ignore) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return result;
    }

    private static void nextPhaseDependsOnPersistenceUnit(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit topDeploymentUnit = DeploymentUtils.getTopDeploymentUnit((DeploymentUnit)phaseContext.getDeploymentUnit());
        PersistenceUnitsInApplication persistenceUnitsInApplication = (PersistenceUnitsInApplication)topDeploymentUnit.getAttachment(PersistenceUnitsInApplication.PERSISTENCE_UNITS_IN_APPLICATION);
        for (PersistenceUnitMetadataHolder holder : persistenceUnitsInApplication.getPersistenceUnitHolders()) {
            for (PersistenceUnitMetadata pu : holder.getPersistenceUnits()) {
                String jpaContainerManaged = pu.getProperties().getProperty("jboss.as.jpa.managed");
                boolean deployPU = jpaContainerManaged == null ? true : Boolean.parseBoolean(jpaContainerManaged);
                if (!deployPU) continue;
                ServiceName puServiceName = PersistenceUnitServiceImpl.getPUServiceName(pu);
                PersistenceProviderDeploymentHolder persistenceProviderDeploymentHolder = PersistenceUnitServiceHandler.getPersistenceProviderDeploymentHolder(phaseContext.getDeploymentUnit());
                PersistenceProviderAdaptor adaptor = PersistenceUnitServiceHandler.getPersistenceProviderAdaptor(pu, persistenceProviderDeploymentHolder, phaseContext.getDeploymentUnit());
                if (!Configuration.needClassFileTransformer(pu)) continue;
                phaseContext.addToAttachmentList(Attachments.NEXT_PHASE_DEPS, (Object)puServiceName);
            }
        }
    }

    static boolean isEarDeployment(DeploymentUnit context) {
        return DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)context);
    }

    static boolean isWarDeployment(DeploymentUnit context) {
        return DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)context);
    }

    private static void addPUServiceDependencyToComponents(Collection<ComponentDescription> components, ServiceName puServiceName) {
        if (components == null || components.isEmpty()) {
            return;
        }
        for (ComponentDescription component : components) {
            JpaLogger.JPA_LOGGER.debugf("Adding dependency on PU service %s for component %s", (Object)puServiceName, (Object)component.getComponentClassName());
            component.addDependency(puServiceName, ServiceBuilder.DependencyType.REQUIRED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addManagementConsole(DeploymentUnit deploymentUnit, PersistenceUnitMetadata pu, PersistenceProviderAdaptor adaptor) {
        ManagementAdaptor managementAdaptor = adaptor.getManagementAdaptor();
        if (managementAdaptor != null && adaptor.doesScopedPersistenceUnitNameIdentifyCacheRegionName(pu)) {
            Resource subsystemResource;
            Resource deploymentResource;
            String providerLabel = managementAdaptor.getIdentificationLabel();
            String scopedPersistenceUnitName = pu.getScopedPersistenceUnitName();
            Resource providerResource = managementAdaptor.createPersistenceUnitResource(scopedPersistenceUnitName, providerLabel);
            ModelNode perPuNode = providerResource.getModel();
            perPuNode.get(SCOPED_UNIT_NAME).set(pu.getScopedPersistenceUnitName());
            Resource resource = deploymentResource = (Resource)deploymentUnit.getAttachment(DeploymentModelUtils.DEPLOYMENT_RESOURCE);
            synchronized (resource) {
                subsystemResource = PersistenceUnitServiceHandler.getOrCreateResource(deploymentResource, PathElement.pathElement((String)"subsystem", (String)"jpa"));
            }
            resource = subsystemResource;
            synchronized (resource) {
                subsystemResource.registerChild(PathElement.pathElement((String)providerLabel, (String)scopedPersistenceUnitName), providerResource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Resource getOrCreateResource(Resource parent, PathElement element) {
        Resource resource = parent;
        synchronized (resource) {
            if (parent.hasChild(element)) {
                return parent.requireChild(element);
            }
            Resource resource2 = Resource.Factory.create();
            parent.registerChild(element, resource2);
            return resource2;
        }
    }

    private static PersistenceProviderDeploymentHolder getPersistenceProviderDeploymentHolder(DeploymentUnit deploymentUnit) {
        deploymentUnit = DeploymentUtils.getTopDeploymentUnit((DeploymentUnit)deploymentUnit);
        return (PersistenceProviderDeploymentHolder)deploymentUnit.getAttachment(JpaAttachments.DEPLOYED_PERSISTENCE_PROVIDER);
    }

    private static class PersistenceAdaptorRemoval {
        final PersistenceUnitMetadata pu;
        final PersistenceProviderAdaptor adaptor;

        public PersistenceAdaptorRemoval(PersistenceUnitMetadata pu, PersistenceProviderAdaptor adaptor) {
            this.pu = pu;
            this.adaptor = adaptor;
        }

        private void cleanup() {
            this.adaptor.cleanup(this.pu);
        }
    }

    private static class ManagedReferenceFactoryInjector
    implements Injector<ManagedReferenceFactory> {
        private volatile ManagedReference reference;
        private final Injector<DataSource> dataSourceInjector;

        public ManagedReferenceFactoryInjector(Injector<DataSource> dataSourceInjector) {
            this.dataSourceInjector = dataSourceInjector;
        }

        public void inject(ManagedReferenceFactory value) throws InjectionException {
            this.reference = value.getReference();
            this.dataSourceInjector.inject((Object)((DataSource)this.reference.getInstance()));
        }

        public void uninject() {
            this.reference.release();
            this.reference = null;
            this.dataSourceInjector.uninject();
        }
    }
}

