/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.configadmin.parser;

import java.util.List;
import org.jboss.as.configadmin.ConfigAdminLogger;
import org.jboss.as.configadmin.service.ConfigAdminServiceImpl;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

class ConfigAdminAdd
extends AbstractAddStepHandler {
    static final ConfigAdminAdd INSTANCE = new ConfigAdminAdd();

    private ConfigAdminAdd() {
    }

    static ModelNode createAddSubsystemOperation() {
        ModelNode addop = new ModelNode();
        addop.get("operation").set("add");
        addop.get("address").add("subsystem", "configadmin");
        return addop;
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, final ServiceVerificationHandler verificationHandler, final List<ServiceController<?>> newControllers) {
        ConfigAdminLogger.LOGGER.activatingSubsystem();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceTarget serviceTarget = context.getServiceTarget();
                newControllers.add(ConfigAdminServiceImpl.addService(serviceTarget, new ServiceListener[]{verificationHandler}));
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
        ConfigAdminLogger.LOGGER.debugf("Activated ConfigAdmin Subsystem", new Object[0]);
    }
}

