/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.security;

import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.Subject;
import org.jboss.as.core.security.SubjectUserInfo;
import org.jboss.as.domain.http.server.HttpServerLogger;
import org.jboss.as.domain.http.server.security.PrincipalUtil;
import org.jboss.as.domain.http.server.security.SubjectHttpPrincipal;
import org.jboss.as.domain.management.AuthenticationMechanism;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.com.sun.net.httpserver.Authenticator;
import org.jboss.com.sun.net.httpserver.HttpExchange;
import org.jboss.com.sun.net.httpserver.HttpPrincipal;
import org.jboss.com.sun.net.httpserver.HttpsExchange;

public class ClientCertAuthenticator
extends Authenticator {
    private final SecurityRealm securityRealm;
    private final String realm;

    public ClientCertAuthenticator(SecurityRealm securityRealm) {
        this.securityRealm = securityRealm;
        this.realm = securityRealm.getName();
    }

    public Authenticator.Result authenticate(HttpExchange exchange) {
        HttpsExchange httpsExch;
        SSLSession session;
        Authenticator.Failure response = null;
        if (exchange instanceof HttpsExchange && (session = (httpsExch = (HttpsExchange)exchange).getSSLSession()) != null) {
            try {
                Principal p = session.getPeerPrincipal();
                response = new Authenticator.Success((HttpPrincipal)new SubjectHttpPrincipal(p.getName(), this.realm));
            }
            catch (SSLPeerUnverifiedException e) {
                // empty catch block
            }
        }
        if (response != null) {
            if (response instanceof Authenticator.Success) {
                SubjectHttpPrincipal principal = (SubjectHttpPrincipal)((Authenticator.Success)response).getPrincipal();
                try {
                    HashSet<SubjectHttpPrincipal> principalCol = new HashSet<SubjectHttpPrincipal>();
                    principalCol.add(principal);
                    SubjectUserInfo userInfo = this.securityRealm.getAuthorizingCallbackHandler(AuthenticationMechanism.CLIENT_CERT).createSubjectUserInfo(principalCol);
                    Subject subject = userInfo.getSubject();
                    PrincipalUtil.addInetPrincipal(exchange, subject.getPrincipals());
                    principal.setSubject(subject);
                }
                catch (IOException e) {
                    HttpServerLogger.ROOT_LOGGER.debug("Unable to create SubjectUserInfo", e);
                    response = new Authenticator.Failure(500);
                }
            }
        } else {
            response = new Authenticator.Failure(403);
        }
        return response;
    }
}

