/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.jboss.resteasy.plugins.providers.jaxb.AbstractJAXBProvider;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBUnmarshalException;
import org.jboss.resteasy.plugins.providers.jaxb.SecureUnmarshaller;
import org.jboss.resteasy.util.Types;
import org.xml.sax.InputSource;

@Provider
@Produces(value={"application/*+xml", "text/*+xml"})
@Consumes(value={"application/*+xml", "text/*+xml"})
public class JAXBElementProvider
extends AbstractJAXBProvider<JAXBElement<?>> {
    @Override
    protected boolean isReadWritable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JAXBElement.class.equals(type);
    }

    @Override
    public JAXBElement<?> readFrom(Class<JAXBElement<?>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        JAXBElement result;
        Class typeArg = Object.class;
        if (genericType != null) {
            typeArg = Types.getTypeArgument((Type)genericType);
        }
        JAXBContext jaxb = null;
        try {
            jaxb = this.findJAXBContext(typeArg, annotations, mediaType, true);
        }
        catch (JAXBException e) {
            throw new JAXBUnmarshalException(e);
        }
        try {
            Unmarshaller unmarshaller = jaxb.createUnmarshaller();
            unmarshaller = JAXBElementProvider.decorateUnmarshaller(type, annotations, mediaType, unmarshaller);
            if (this.needsSecurity()) {
                unmarshaller = new SecureUnmarshaller(unmarshaller, this.isDisableExternalEntities(), this.isEnableSecureProcessingFeature(), this.isDisableDTDs());
                SAXSource source = null;
                source = JAXBElementProvider.getCharset(mediaType) == null ? new SAXSource(new InputSource(new InputStreamReader(entityStream, "UTF-8"))) : new SAXSource(new InputSource(entityStream));
                result = unmarshaller.unmarshal((Source)source, typeArg);
            } else if (JAXBElementProvider.getCharset(mediaType) == null) {
                InputSource is = new InputSource(entityStream);
                is.setEncoding("UTF-8");
                StreamSource source = new StreamSource(new InputStreamReader(entityStream, "UTF-8"));
                source.setInputStream(entityStream);
                result = unmarshaller.unmarshal((Source)source, typeArg);
            } else {
                JAXBElement e;
                result = e = unmarshaller.unmarshal((Source)new StreamSource(entityStream), typeArg);
            }
        }
        catch (JAXBException e) {
            throw new JAXBUnmarshalException(e);
        }
        JAXBElement element = result;
        return element;
    }

    @Override
    public void writeTo(JAXBElement<?> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream outputStream) throws IOException {
        Class typeArg = Object.class;
        if (genericType != null) {
            typeArg = Types.getTypeArgument((Type)genericType);
        }
        super.writeTo(t, typeArg, genericType, annotations, mediaType, httpHeaders, outputStream);
    }
}

