/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.DocumentUtil;
import org.picketlink.common.util.SystemPropertiesUtil;
import org.picketlink.identity.federation.core.util.IDFedLSInputResolver;
import org.picketlink.identity.federation.core.util.SchemaManagerUtil;
import org.picketlink.identity.federation.core.util.SecurityActions;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JAXPValidationUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    protected static Validator validator;
    protected static SchemaFactory schemaFactory;

    public static void validate(String str) throws SAXException, IOException {
        JAXPValidationUtil.validator().validate(new StreamSource(str));
    }

    public static void validate(InputStream stream) throws SAXException, IOException {
        JAXPValidationUtil.validator().validate(new StreamSource(stream));
    }

    public static void checkSchemaValidation(Node samlDocument) throws ProcessingException {
        if (SecurityActions.getSystemProperty("picketlink.schema.validate", "false").equalsIgnoreCase("true")) {
            try {
                JAXPValidationUtil.validate(DocumentUtil.getNodeAsStream((Node)samlDocument));
            }
            catch (Exception e) {
                throw logger.processingError((Throwable)e);
            }
        }
    }

    public static Validator validator() throws SAXException, IOException {
        SystemPropertiesUtil.ensure();
        if (validator == null) {
            Schema schema = JAXPValidationUtil.getSchema();
            if (schema == null) {
                throw logger.nullValueError("schema");
            }
            validator = schema.newValidator();
            validator.setErrorHandler(new CustomErrorHandler());
        }
        return validator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Schema getSchema() throws IOException {
        boolean tccl_jaxp = SystemPropertiesUtil.getSystemProperty((String)"picketlink.jaxp.tccl", (String)"false").equalsIgnoreCase("true");
        ClassLoader prevTCCL = SecurityActions.getTCCL();
        try {
            if (tccl_jaxp) {
                SecurityActions.setTCCL(JAXPValidationUtil.class.getClassLoader());
            }
            schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setResourceResolver(new IDFedLSInputResolver());
            schemaFactory.setErrorHandler(new CustomErrorHandler());
        }
        finally {
            if (tccl_jaxp) {
                SecurityActions.setTCCL(prevTCCL);
            }
        }
        Schema schemaGrammar = null;
        try {
            schemaGrammar = schemaFactory.newSchema(JAXPValidationUtil.sources());
        }
        catch (SAXException e) {
            logger.xmlCouldNotGetSchema((Throwable)e);
        }
        return schemaGrammar;
    }

    private static Source[] sources() throws IOException {
        List<String> schemas = SchemaManagerUtil.getSchemas();
        Source[] sourceArr = new Source[schemas.size()];
        int i = 0;
        for (String schema : schemas) {
            URL url = SecurityActions.loadResource(JAXPValidationUtil.class, schema);
            if (url == null) {
                throw logger.nullValueError("schema url:" + schema);
            }
            sourceArr[i++] = new StreamSource(url.openStream());
        }
        return sourceArr;
    }

    private static class CustomErrorHandler
    implements ErrorHandler {
        private CustomErrorHandler() {
        }

        @Override
        public void error(SAXParseException ex) throws SAXException {
            this.logException(ex);
            if (!ex.getMessage().contains("null")) {
                throw ex;
            }
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXException {
            this.logException(ex);
            throw ex;
        }

        @Override
        public void warning(SAXParseException ex) throws SAXException {
            this.logException(ex);
        }

        private void logException(SAXParseException sax) {
            StringBuilder builder = new StringBuilder();
            if (logger.isTraceEnabled()) {
                builder.append("[line:").append(sax.getLineNumber()).append(",").append("::col=").append(sax.getColumnNumber()).append("]");
                builder.append("[publicID:").append(sax.getPublicId()).append(",systemId=").append(sax.getSystemId()).append("]");
                builder.append(":").append(sax.getLocalizedMessage());
                logger.trace(builder.toString());
            }
        }
    }
}

