/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.logmanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import org.jboss.logmanager.config.PropertyConfigurable;
import org.jboss.logmanager.config.ValueExpression;

public interface PropertySorter {
    public static final PropertySorter NO_OP = new PropertySorter(){

        @Override
        public boolean isReorderRequired(PropertyConfigurable configurable) {
            return false;
        }

        @Override
        public void sort(PropertyConfigurable configurable) {
        }
    };

    public boolean isReorderRequired(PropertyConfigurable var1);

    public void sort(PropertyConfigurable var1);

    public static class DefaultPropertySorter
    implements PropertySorter {
        private final Comparator<String> comparator;

        public DefaultPropertySorter(Comparator<String> comparator) {
            this.comparator = comparator;
        }

        @Override
        public boolean isReorderRequired(PropertyConfigurable configurable) {
            List names = configurable.getPropertyNames();
            ArrayList sortedNames = new ArrayList(names);
            Collections.sort(sortedNames, this.comparator);
            return !((Object)names).equals(sortedNames);
        }

        @Override
        public void sort(PropertyConfigurable configurable) {
            ArrayList sortedNames = new ArrayList(configurable.getPropertyNames());
            Collections.sort(sortedNames, this.comparator);
            LinkedHashMap<String, ValueExpression> orderedValues = new LinkedHashMap<String, ValueExpression>(sortedNames.size());
            for (String name : sortedNames) {
                orderedValues.put(name, configurable.getPropertyValueExpression(name));
                configurable.removeProperty(name);
            }
            for (String name : orderedValues.keySet()) {
                ValueExpression value = (ValueExpression)orderedValues.get(name);
                configurable.setPropertyValueExpression(name, value.getValue());
            }
        }
    }
}

