/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Manifest;
import org.apache.log4j.JBossLogManagerFacade;
import org.apache.log4j.xml.DOMConfigurator;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.as.logging.LoggingLogger;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.LoggingProfileContextSelector;
import org.jboss.as.logging.SecurityActions;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.PropertyConfigurator;
import org.jboss.modules.Module;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;

public class LoggingDeploymentUnitProcessor
implements DeploymentUnitProcessor {
    static final LoggingDeploymentUnitProcessor INSTANCE = new LoggingDeploymentUnitProcessor();
    public static final String PER_DEPLOYMENT_LOGGING = "org.jboss.as.logging.per-deployment";
    public static final AttachmentKey<LogContext> LOG_CONTEXT_KEY = AttachmentKey.create(LogContext.class);
    private static final String ENCODING = "utf-8";
    private static final String LOGGING_PROFILE = "Logging-Profile";
    private static final String LOG4J_PROPERTIES = "log4j.properties";
    private static final String LOG4J_XML = "log4j.xml";
    private static final String JBOSS_LOG4J_XML = "jboss-log4j.xml";
    private static final String DEFAULT_PROPERTIES = "logging.properties";
    private static final String JBOSS_PROPERTIES = "jboss-logging.properties";
    private static final Object CONTEXT_LOCK = new Object();

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.hasAttachment(Attachments.MODULE) && deploymentUnit.hasAttachment(Attachments.DEPLOYMENT_ROOT)) {
            ResourceRoot root = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
            if (SubDeploymentMarker.isSubDeployment((ResourceRoot)root)) {
                return;
            }
            if (!this.processDeploymentLogging(deploymentUnit, root)) {
                this.processLoggingProfiles(deploymentUnit, root);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
        if (LoggingDeploymentUnitProcessor.hasRegisteredLogContext(context) && context.hasAttachment(Attachments.MODULE)) {
            ResourceRoot root = (ResourceRoot)context.getAttachment(Attachments.DEPLOYMENT_ROOT);
            if (SubDeploymentMarker.isSubDeployment((ResourceRoot)root)) {
                return;
            }
            Module module = (Module)context.getAttachment(Attachments.MODULE);
            this.unregisterLogContext(context, module);
            List<DeploymentUnit> subDeployments = LoggingDeploymentUnitProcessor.getSubDeployments(context);
            for (DeploymentUnit subDeployment : subDeployments) {
                Module subDeploymentModule = (Module)subDeployment.getAttachment(Attachments.MODULE);
                this.unregisterLogContext(subDeployment, subDeploymentModule);
            }
        }
    }

    public static boolean hasRegisteredLogContext(DeploymentUnit deploymentUnit) {
        return deploymentUnit.hasAttachment(LOG_CONTEXT_KEY);
    }

    private boolean processLoggingProfiles(DeploymentUnit deploymentUnit, ResourceRoot root) throws DeploymentUnitProcessingException {
        List<DeploymentUnit> subDeployments = LoggingDeploymentUnitProcessor.getSubDeployments(deploymentUnit);
        String loggingProfile = this.findLoggingProfile(root);
        if (loggingProfile != null) {
            LoggingProfileContextSelector loggingProfileContext = LoggingProfileContextSelector.getInstance();
            if (loggingProfileContext.exists(loggingProfile)) {
                Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
                LogContext logContext = loggingProfileContext.get(loggingProfile);
                LoggingLogger.ROOT_LOGGER.tracef("Registering log context '%s' on '%s' for profile '%s'", logContext, root, loggingProfile);
                this.registerLogContext(deploymentUnit, module, logContext);
                for (DeploymentUnit subDeployment : subDeployments) {
                    if (!subDeployment.hasAttachment(Attachments.MODULE)) continue;
                    if (subDeployment.hasAttachment(Attachments.DEPLOYMENT_ROOT)) {
                        this.processLoggingProfiles(subDeployment, (ResourceRoot)subDeployment.getAttachment(Attachments.DEPLOYMENT_ROOT));
                    }
                    if (LoggingDeploymentUnitProcessor.hasRegisteredLogContext(subDeployment)) continue;
                    Module subDeploymentModule = (Module)subDeployment.getAttachment(Attachments.MODULE);
                    LoggingLogger.ROOT_LOGGER.tracef("Registering log context '%s' on '%s' for profile '%s'", logContext, subDeployment.getAttachment(Attachments.DEPLOYMENT_ROOT), loggingProfile);
                    this.registerLogContext(subDeployment, subDeploymentModule, logContext);
                }
            } else {
                LoggingLogger.ROOT_LOGGER.loggingProfileNotFound(loggingProfile, root);
            }
        } else {
            for (DeploymentUnit subDeployment : subDeployments) {
                if (!subDeployment.hasAttachment(Attachments.MODULE) || !subDeployment.hasAttachment(Attachments.DEPLOYMENT_ROOT)) continue;
                this.processLoggingProfiles(subDeployment, (ResourceRoot)subDeployment.getAttachment(Attachments.DEPLOYMENT_ROOT));
            }
        }
        return LoggingDeploymentUnitProcessor.hasRegisteredLogContext(deploymentUnit);
    }

    private boolean processDeploymentLogging(DeploymentUnit deploymentUnit, ResourceRoot root) throws DeploymentUnitProcessingException {
        block6: {
            if (!Boolean.valueOf(SecurityActions.getSystemProperty(PER_DEPLOYMENT_LOGGING, Boolean.toString(true))).booleanValue()) break block6;
            LoggingLogger.ROOT_LOGGER.trace("Scanning for logging configuration files.");
            List<DeploymentUnit> subDeployments = LoggingDeploymentUnitProcessor.getSubDeployments(deploymentUnit);
            VirtualFile configFile = this.findConfigFile(root);
            if (configFile != null) {
                Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
                LogContext logContext = LoggingDeploymentUnitProcessor.isLog4jConfiguration(configFile.getName()) ? LogContext.create((boolean)true) : LogContext.create();
                if (!this.configure(configFile, (ClassLoader)module.getClassLoader(), logContext)) {
                    return false;
                }
                this.registerLogContext(deploymentUnit, module, logContext);
                for (DeploymentUnit subDeployment : subDeployments) {
                    Module subDeploymentModule;
                    if (subDeployment.hasAttachment(Attachments.DEPLOYMENT_ROOT)) {
                        this.processDeploymentLogging(subDeployment, (ResourceRoot)subDeployment.getAttachment(Attachments.DEPLOYMENT_ROOT));
                    }
                    if (!subDeployment.hasAttachment(Attachments.MODULE) || LoggingDeploymentUnitProcessor.hasRegisteredLogContext(subDeployment) || (subDeploymentModule = (Module)subDeployment.getAttachment(Attachments.MODULE)) == null) continue;
                    this.registerLogContext(subDeployment, subDeploymentModule, logContext);
                }
            } else {
                for (DeploymentUnit subDeployment : subDeployments) {
                    if (!subDeployment.hasAttachment(Attachments.DEPLOYMENT_ROOT)) continue;
                    this.processDeploymentLogging(subDeployment, (ResourceRoot)subDeployment.getAttachment(Attachments.DEPLOYMENT_ROOT));
                }
            }
        }
        return LoggingDeploymentUnitProcessor.hasRegisteredLogContext(deploymentUnit);
    }

    private String findLoggingProfile(ResourceRoot resourceRoot) {
        String loggingProfile;
        Manifest manifest = (Manifest)resourceRoot.getAttachment(Attachments.MANIFEST);
        if (manifest != null && (loggingProfile = manifest.getMainAttributes().getValue(LOGGING_PROFILE)) != null) {
            LoggingLogger.ROOT_LOGGER.debugf("Logging profile '%s' found in '%s'.", loggingProfile, resourceRoot);
            return loggingProfile;
        }
        return null;
    }

    private VirtualFile findConfigFile(ResourceRoot resourceRoot) throws DeploymentUnitProcessingException {
        VirtualFile root = resourceRoot.getRoot();
        VirtualFile file = root.getChild("META-INF");
        VirtualFile result = this.findConfigFile(file);
        if (result == null) {
            file = root.getChild("WEB-INF/classes");
            result = this.findConfigFile(file);
        }
        return result;
    }

    private VirtualFile findConfigFile(VirtualFile file) throws DeploymentUnitProcessingException {
        VirtualFile result = null;
        try {
            List configFiles = file.getChildren((VirtualFileFilter)ConfigFilter.INSTANCE);
            for (VirtualFile configFile : configFiles) {
                String fileName = configFile.getName();
                if (DEFAULT_PROPERTIES.equals(fileName) || JBOSS_PROPERTIES.equals(fileName)) {
                    if (result != null) {
                        LoggingLogger.ROOT_LOGGER.debugf("The previously found configuration file '%s' is being ignored in favour of '%s'", result, configFile);
                    }
                    return configFile;
                }
                if (!LOG4J_PROPERTIES.equals(fileName) && !LOG4J_XML.equals(fileName) && !JBOSS_LOG4J_XML.equals(fileName)) continue;
                result = configFile;
            }
        }
        catch (IOException e) {
            throw LoggingMessages.MESSAGES.errorProcessingLoggingConfiguration(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean configure(VirtualFile configFile, ClassLoader classLoader, LogContext logContext) throws DeploymentUnitProcessingException {
        InputStream configStream;
        boolean result;
        block12: {
            result = false;
            configStream = null;
            try {
                LoggingLogger.ROOT_LOGGER.debugf("Found logging configuration file: %s", configFile);
                String fileName = configFile.getName();
                configStream = configFile.openStream();
                if (LoggingDeploymentUnitProcessor.isLog4jConfiguration(fileName)) {
                    ClassLoader current = SecurityActions.getThreadContextClassLoader();
                    LogContext old = LoggingExtension.THREAD_LOCAL_CONTEXT_SELECTOR.getAndSet(CONTEXT_LOCK, logContext);
                    try {
                        SecurityActions.setThreadContextClassLoader(classLoader);
                        if (LOG4J_XML.equals(fileName) || JBOSS_LOG4J_XML.equals(fileName)) {
                            new DOMConfigurator().doConfigure(configStream, JBossLogManagerFacade.getLoggerRepository((LogContext)logContext));
                        } else {
                            Properties properties = new Properties();
                            properties.load(new InputStreamReader(configStream, ENCODING));
                            new org.apache.log4j.PropertyConfigurator().doConfigure(properties, JBossLogManagerFacade.getLoggerRepository((LogContext)logContext));
                        }
                    }
                    finally {
                        LoggingExtension.THREAD_LOCAL_CONTEXT_SELECTOR.getAndSet(CONTEXT_LOCK, old);
                        SecurityActions.setThreadContextClassLoader(current);
                    }
                    result = true;
                    break block12;
                }
                Properties properties = new Properties();
                properties.load(new InputStreamReader(configStream, ENCODING));
                if (LoggingDeploymentUnitProcessor.isJulConfiguration(properties)) {
                    LoggingLogger.ROOT_LOGGER.julConfigurationFileFound(configFile.getName());
                    break block12;
                }
                PropertyConfigurator propertyConfigurator = new PropertyConfigurator(logContext);
                propertyConfigurator.configure(properties);
                result = true;
            }
            catch (Exception e) {
                try {
                    throw LoggingMessages.MESSAGES.failedToConfigureLogging(e, configFile.getName());
                }
                catch (Throwable throwable) {
                    LoggingDeploymentUnitProcessor.safeClose(configStream);
                    throw throwable;
                }
            }
        }
        LoggingDeploymentUnitProcessor.safeClose(configStream);
        return result;
    }

    private void registerLogContext(DeploymentUnit deploymentUnit, final Module module, final LogContext logContext) {
        LoggingLogger.ROOT_LOGGER.tracef("Registering LogContext %s for deployment %s", logContext, deploymentUnit.getName());
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    LoggingExtension.CONTEXT_SELECTOR.registerLogContext((ClassLoader)module.getClassLoader(), logContext);
                    return null;
                }
            });
        } else {
            LoggingExtension.CONTEXT_SELECTOR.registerLogContext((ClassLoader)module.getClassLoader(), logContext);
        }
        deploymentUnit.putAttachment(LOG_CONTEXT_KEY, (Object)logContext);
    }

    private void unregisterLogContext(DeploymentUnit deploymentUnit, final Module module) {
        final LogContext logContext = (LogContext)deploymentUnit.removeAttachment(LOG_CONTEXT_KEY);
        boolean success = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return LoggingExtension.CONTEXT_SELECTOR.unregisterLogContext((ClassLoader)module.getClassLoader(), logContext);
            }
        }).booleanValue() : LoggingExtension.CONTEXT_SELECTOR.unregisterLogContext((ClassLoader)module.getClassLoader(), logContext);
        if (success) {
            LoggingLogger.ROOT_LOGGER.tracef("Removed LogContext '%s' from '%s'", logContext, module);
        } else {
            LoggingLogger.ROOT_LOGGER.logContextNotRemoved(logContext, deploymentUnit.getName());
        }
    }

    private static List<DeploymentUnit> getSubDeployments(DeploymentUnit deploymentUnit) {
        ArrayList<DeploymentUnit> result = new ArrayList<DeploymentUnit>();
        if (deploymentUnit.hasAttachment(Attachments.SUB_DEPLOYMENTS)) {
            result.addAll(deploymentUnit.getAttachmentList(Attachments.SUB_DEPLOYMENTS));
        }
        return result;
    }

    private static void safeClose(Closeable closable) {
        if (closable != null) {
            try {
                closable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean isLog4jConfiguration(String fileName) {
        return LOG4J_PROPERTIES.equals(fileName) || LOG4J_XML.equals(fileName) || JBOSS_LOG4J_XML.equals(fileName);
    }

    private static boolean isJulConfiguration(Properties properties) {
        String prop;
        if (properties.containsKey(".level")) {
            return true;
        }
        if (properties.containsKey("handlers") && (prop = properties.getProperty("handlers", "")) != null && !prop.trim().isEmpty()) {
            String[] handlers;
            for (String handler : handlers = prop.split("\\s*,\\s*")) {
                String key = String.format("handler.%s", handler);
                if (properties.containsKey(key)) continue;
                return true;
            }
        }
        return false;
    }

    private static class ConfigFilter
    implements VirtualFileFilter {
        static final ConfigFilter INSTANCE = new ConfigFilter();
        private final Set<String> configFiles = new HashSet<String>(Arrays.asList("log4j.properties", "log4j.xml", "jboss-log4j.xml", "jboss-logging.properties", "logging.properties"));

        private ConfigFilter() {
        }

        public boolean accepts(VirtualFile file) {
            return this.configFiles.contains(file.getName());
        }
    }
}

