/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.store.FileStoreOutputStream;
import org.h2.store.LobStorage;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueLob;

public class ValueLobDb
extends Value
implements Value.ValueClob,
Value.ValueBlob {
    private final int type;
    private long precision;
    private int tableId;
    private int hash;
    private LobStorage lobStorage;
    private long lobId;
    private byte[] hmac;
    private byte[] small;
    private DataHandler handler;
    private FileStore tempFile;
    private String fileName;

    private ValueLobDb(int type, LobStorage lobStorage, int tableId, long lobId, byte[] hmac, long precision) {
        this.type = type;
        this.lobStorage = lobStorage;
        this.tableId = tableId;
        this.lobId = lobId;
        this.hmac = hmac;
        this.precision = precision;
    }

    private ValueLobDb(int type, byte[] small, long precision) {
        this.type = type;
        this.small = small;
        this.precision = precision;
    }

    public static ValueLobDb create(int type, LobStorage lobStorage, int tableId, long id, byte[] hmac, long precision) {
        return new ValueLobDb(type, lobStorage, tableId, id, hmac, precision);
    }

    public static ValueLobDb createSmallLob(int type, byte[] small, long precision) {
        return new ValueLobDb(type, small, precision);
    }

    @Override
    public Value convertTo(int t) {
        if (t == this.type) {
            return this;
        }
        if (t == 16) {
            if (this.lobStorage != null) {
                Value copy = this.lobStorage.createClob(this.getReader(), -1L);
                return copy;
            }
            if (this.small != null) {
                return LobStorage.createSmallLob(t, this.small);
            }
        } else if (t == 15) {
            if (this.lobStorage != null) {
                Value copy = this.lobStorage.createBlob(this.getInputStream(), -1L);
                return copy;
            }
            if (this.small != null) {
                return LobStorage.createSmallLob(t, this.small);
            }
        }
        return super.convertTo(t);
    }

    @Override
    public boolean isLinked() {
        return this.tableId != -1 && this.small == null;
    }

    public boolean isStored() {
        return this.small == null && this.fileName == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.fileName != null) {
            if (this.tempFile != null) {
                this.tempFile.stopAutoDelete();
            }
            Object object = this.handler.getLobSyncObject();
            synchronized (object) {
                FileUtils.delete(this.fileName);
            }
        }
        if (this.lobStorage != null) {
            this.lobStorage.removeLob(this.lobId);
            this.lobStorage = null;
        }
    }

    @Override
    public void unlink() {
        if (this.small == null && this.tableId != -1) {
            this.lobStorage.setTable(this.lobId, -1);
            this.tableId = -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Value link(DataHandler h, int tabId) {
        if (this.small == null) {
            if (this.tableId != -2) return this.lobStorage.copyLob(this.type, this.lobId, tabId, this.getPrecision());
            this.lobStorage.setTable(this.lobId, tabId);
            this.tableId = tabId;
            return this;
        } else {
            if (this.small.length <= h.getMaxLengthInplaceLob()) return this;
            LobStorage s = h.getLobStorage();
            Value v = this.type == 15 ? s.createBlob(this.getInputStream(), this.getPrecision()) : s.createClob(this.getReader(), this.getPrecision());
            return v.link(h, tabId);
        }
    }

    @Override
    public int getTableId() {
        return this.tableId;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public long getPrecision() {
        return this.precision;
    }

    @Override
    public String getString() {
        int len = this.precision > Integer.MAX_VALUE || this.precision == 0L ? Integer.MAX_VALUE : (int)this.precision;
        try {
            if (this.type == 16) {
                if (this.small != null) {
                    return StringUtils.utf8Decode(this.small);
                }
                return IOUtils.readStringAndClose(this.getReader(), len);
            }
            byte[] buff = this.small != null ? this.small : IOUtils.readBytesAndClose(this.getInputStream(), len);
            return StringUtils.convertBytesToHex(buff);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, this.toString());
        }
    }

    @Override
    public byte[] getBytes() {
        if (this.type == 16) {
            return super.getBytes();
        }
        byte[] data = this.getBytesNoCopy();
        return Utils.cloneByteArray(data);
    }

    @Override
    public byte[] getBytesNoCopy() {
        if (this.type == 16) {
            return super.getBytesNoCopy();
        }
        if (this.small != null) {
            return this.small;
        }
        try {
            return IOUtils.readBytesAndClose(this.getInputStream(), Integer.MAX_VALUE);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, this.toString());
        }
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            if (this.precision > 4096L) {
                return (int)(this.precision ^ this.precision >>> 32);
            }
            this.hash = this.type == 16 ? this.getString().hashCode() : Utils.getByteArrayHash(this.getBytes());
        }
        return this.hash;
    }

    @Override
    protected int compareSecure(Value v, CompareMode mode) {
        Object v2;
        if (v instanceof ValueLobDb) {
            v2 = (ValueLobDb)v;
            if (v == this) {
                return 0;
            }
            if (this.lobId == ((ValueLobDb)v2).lobId && this.small == null && ((ValueLobDb)v2).small == null) {
                return 0;
            }
        }
        if (this.type == 16) {
            return Integer.signum(this.getString().compareTo(v.getString()));
        }
        v2 = v.getBytesNoCopy();
        return Utils.compareNotNull(this.getBytes(), (byte[])v2);
    }

    @Override
    public Object getObject() {
        if (this.type == 16) {
            return this.getReader();
        }
        return this.getInputStream();
    }

    @Override
    public Reader getReader() {
        return IOUtils.getBufferedReader(this.getInputStream());
    }

    @Override
    public InputStream getInputStream() {
        if (this.small != null) {
            return new ByteArrayInputStream(this.small);
        }
        if (this.fileName != null) {
            FileStore store = this.handler.openFile(this.fileName, "r", true);
            boolean alwaysClose = SysProperties.lobCloseBetweenReads;
            return new BufferedInputStream(new FileStoreInputStream(store, this.handler, false, alwaysClose), 4096);
        }
        long byteCount = this.type == 15 ? this.precision : -1L;
        try {
            return this.lobStorage.getInputStream(this.lobId, this.hmac, byteCount);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, this.toString());
        }
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        long p = this.getPrecision();
        if (p > Integer.MAX_VALUE || p <= 0L) {
            p = -1L;
        }
        if (this.type == 15) {
            prep.setBinaryStream(parameterIndex, this.getInputStream(), (int)p);
        } else {
            prep.setCharacterStream(parameterIndex, this.getReader(), (int)p);
        }
    }

    @Override
    public String getSQL() {
        if (this.type == 16) {
            String s = this.getString();
            return StringUtils.quoteStringSQL(s);
        }
        byte[] buff = this.getBytes();
        String s = StringUtils.convertBytesToHex(buff);
        return "X'" + s + "'";
    }

    @Override
    public String getTraceSQL() {
        if (this.small != null && this.getPrecision() <= SysProperties.MAX_TRACE_DATA_LENGTH) {
            return this.getSQL();
        }
        StringBuilder buff = new StringBuilder();
        if (this.type == 16) {
            buff.append("SPACE(").append(this.getPrecision());
        } else {
            buff.append("CAST(REPEAT('00', ").append(this.getPrecision()).append(") AS BINARY");
        }
        buff.append(" /* table: ").append(this.tableId).append(" id: ").append(this.lobId).append(" */)");
        return buff.toString();
    }

    @Override
    public byte[] getSmall() {
        return this.small;
    }

    @Override
    public int getDisplaySize() {
        return MathUtils.convertLongToInt(this.getPrecision());
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueLobDb && this.compareSecure((Value)other, null) == 0;
    }

    @Override
    public int getMemory() {
        if (this.small != null) {
            return this.small.length + 104;
        }
        return 140;
    }

    @Override
    public ValueLobDb copyToTemp() {
        return this;
    }

    public long getLobId() {
        return this.lobId;
    }

    public void setPrecision(long precision) {
        this.precision = precision;
    }

    @Override
    public String toString() {
        return "lob: " + this.fileName + " table: " + this.tableId + " id: " + this.lobId;
    }

    public static ValueLobDb createTempClob(Reader in, long length, DataHandler handler) {
        try {
            char[] buff;
            int len;
            boolean compress = handler.getLobCompressionAlgorithm(16) != null;
            long remaining = Long.MAX_VALUE;
            if (length >= 0L && length < remaining) {
                remaining = length;
            }
            if ((len = ValueLobDb.getBufferSize(handler, compress, remaining)) >= Integer.MAX_VALUE) {
                String data = IOUtils.readStringAndClose(in, -1);
                buff = data.toCharArray();
                len = buff.length;
            } else {
                buff = new char[len];
                int n = len = (len = IOUtils.readFully(in, buff, len)) < 0 ? 0 : len;
            }
            if (len <= handler.getMaxLengthInplaceLob()) {
                byte[] small = StringUtils.utf8Encode(new String(buff, 0, len));
                return ValueLobDb.createSmallLob(16, small, len);
            }
            ValueLobDb lob = new ValueLobDb(16, null, 0L);
            lob.createTempFromReader(buff, len, in, remaining, handler);
            return lob;
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, null);
        }
    }

    public static ValueLobDb createTempBlob(InputStream in, long length, DataHandler handler) {
        try {
            byte[] buff;
            int len;
            boolean compress;
            long remaining = Long.MAX_VALUE;
            boolean bl = compress = handler.getLobCompressionAlgorithm(15) != null;
            if (length >= 0L && length < remaining) {
                remaining = length;
            }
            if ((len = ValueLobDb.getBufferSize(handler, compress, remaining)) >= Integer.MAX_VALUE) {
                buff = IOUtils.readBytesAndClose(in, -1);
                len = buff.length;
            } else {
                buff = Utils.newBytes(len);
                len = IOUtils.readFully(in, buff, 0, len);
            }
            if (len <= handler.getMaxLengthInplaceLob()) {
                byte[] small = Utils.newBytes(len);
                System.arraycopy(buff, 0, small, 0, len);
                return ValueLobDb.createSmallLob(15, small, small.length);
            }
            ValueLobDb lob = new ValueLobDb(15, null, 0L);
            lob.createTempFromStream(buff, len, in, remaining, handler);
            return lob;
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTempFromReader(char[] buff, int len, Reader in, long remaining, DataHandler h) {
        try {
            FileStoreOutputStream out = this.initTemp(h);
            try {
                do {
                    this.precision += (long)len;
                    byte[] b = StringUtils.utf8Encode(new String(buff, 0, len));
                    out.write(b, 0, b.length);
                    if ((remaining -= (long)len) <= 0L) {
                        break;
                    }
                    len = ValueLobDb.getBufferSize(h, false, remaining);
                } while ((len = IOUtils.readFully(in, buff, len)) > 0);
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTempFromStream(byte[] buff, int len, InputStream in, long remaining, DataHandler h) {
        try {
            FileStoreOutputStream out = this.initTemp(h);
            boolean compress = h.getLobCompressionAlgorithm(15) != null;
            try {
                do {
                    this.precision += (long)len;
                    out.write(buff, 0, len);
                    if ((remaining -= (long)len) <= 0L) {
                        break;
                    }
                    len = ValueLobDb.getBufferSize(h, compress, remaining);
                } while ((len = IOUtils.readFully(in, buff, 0, len)) > 0);
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, null);
        }
    }

    private FileStoreOutputStream initTemp(DataHandler h) {
        this.precision = 0L;
        this.handler = h;
        this.lobStorage = h.getLobStorage();
        this.small = null;
        try {
            String path = h.getDatabasePath();
            if (path.length() == 0) {
                path = SysProperties.PREFIX_TEMP_FILE;
            }
            this.fileName = FileUtils.createTempFile(path, ".temp.db", true, true);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, null);
        }
        this.tempFile = h.openFile(this.fileName, "rw", false);
        this.tempFile.autoDelete();
        FileStoreOutputStream out = new FileStoreOutputStream(this.tempFile, null, null);
        return out;
    }

    private static int getBufferSize(DataHandler handler, boolean compress, long remaining) {
        long m;
        long inplace;
        if (remaining < 0L || remaining > Integer.MAX_VALUE) {
            remaining = Integer.MAX_VALUE;
        }
        if ((inplace = (long)handler.getMaxLengthInplaceLob()) >= Integer.MAX_VALUE) {
            inplace = remaining;
        }
        long l = m = compress ? 131072L : 4096L;
        if (m < remaining && m <= inplace) {
            m = Math.min(remaining, inplace + 1L);
            m = MathUtils.roundUpLong(m, 4096L);
        }
        m = Math.min(remaining, m);
        if ((m = (long)MathUtils.convertLongToInt(m)) < 0L) {
            m = Integer.MAX_VALUE;
        }
        return (int)m;
    }

    @Override
    public Value convertPrecision(long precision, boolean force) {
        if (this.precision <= precision) {
            return this;
        }
        ValueLob lob = this.type == 16 ? ValueLob.createClob(this.getReader(), precision, this.handler) : ValueLob.createBlob(this.getInputStream(), precision, this.handler);
        return lob;
    }
}

