/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueBytes;

public class ValueJavaObject
extends ValueBytes {
    private static final ValueJavaObject EMPTY = new ValueJavaObject(Utils.EMPTY_BYTES);

    protected ValueJavaObject(byte[] v) {
        super(v);
    }

    public static ValueJavaObject getNoCopy(Object javaObject, byte[] b) {
        ValueJavaObject obj;
        if (b != null && b.length == 0) {
            return EMPTY;
        }
        if (SysProperties.SERIALIZE_JAVA_OBJECT) {
            if (b == null) {
                b = Utils.serialize(javaObject);
            }
            obj = new ValueJavaObject(b);
        } else {
            obj = new NotSerialized(javaObject, b);
        }
        if (b == null || b.length > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return obj;
        }
        return (ValueJavaObject)Value.cache(obj);
    }

    @Override
    public int getType() {
        return 19;
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        Object obj = Utils.deserialize(this.getBytesNoCopy());
        prep.setObject(parameterIndex, obj, 2000);
    }

    private static class NotSerialized
    extends ValueJavaObject {
        private Object javaObject;
        private int displaySize = -1;

        NotSerialized(Object javaObject, byte[] v) {
            super(v);
            this.javaObject = javaObject;
        }

        @Override
        public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
            prep.setObject(parameterIndex, this.getObject(), 2000);
        }

        @Override
        public byte[] getBytesNoCopy() {
            if (this.value == null) {
                this.value = Utils.serialize(this.javaObject);
            }
            return this.value;
        }

        @Override
        protected int compareSecure(Value v, CompareMode mode) {
            int h2;
            Object o1 = this.getObject();
            Object o2 = v.getObject();
            boolean o1Comparable = o1 instanceof Comparable;
            boolean o2Comparable = o2 instanceof Comparable;
            if (o1Comparable && o2Comparable && Utils.haveCommonComparableSuperclass(o1.getClass(), o2.getClass())) {
                Comparable c1 = (Comparable)o1;
                return c1.compareTo(o2);
            }
            if (o1.getClass() != o2.getClass()) {
                if (o1Comparable != o2Comparable) {
                    return o1Comparable ? -1 : 1;
                }
                return o1.getClass().getName().compareTo(o2.getClass().getName());
            }
            int h1 = this.hashCode();
            if (h1 == (h2 = v.hashCode())) {
                if (o1.equals(o2)) {
                    return 0;
                }
                return Utils.compareNotNull(this.getBytesNoCopy(), v.getBytesNoCopy());
            }
            return h1 > h2 ? 1 : -1;
        }

        @Override
        public String getString() {
            String str = this.getObject().toString();
            if (this.displaySize == -1) {
                this.displaySize = str.length();
            }
            return str;
        }

        @Override
        public long getPrecision() {
            return 0L;
        }

        @Override
        public int hashCode() {
            if (this.hash == 0) {
                this.hash = this.getObject().hashCode();
            }
            return this.hash;
        }

        @Override
        public Object getObject() {
            if (this.javaObject == null) {
                this.javaObject = Utils.deserialize(this.value);
            }
            return this.javaObject;
        }

        @Override
        public int getDisplaySize() {
            if (this.displaySize == -1) {
                this.displaySize = this.getString().length();
            }
            return this.displaySize;
        }

        @Override
        public int getMemory() {
            if (this.value == null) {
                return DataType.getDataType((int)this.getType()).memory;
            }
            int mem = super.getMemory();
            if (this.javaObject != null) {
                mem *= 2;
            }
            return mem;
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof NotSerialized)) {
                return false;
            }
            return this.getObject().equals(((NotSerialized)other).getObject());
        }

        @Override
        public Value convertPrecision(long precision, boolean force) {
            return this;
        }
    }
}

