/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import org.h2.command.Prepared;
import org.h2.command.dml.SetTypes;
import org.h2.engine.Database;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.expression.Expression;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.schema.Schema;
import org.h2.table.Table;
import org.h2.tools.CompressTool;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.ValueInt;

public class Set
extends Prepared {
    private int type;
    private Expression expression;
    private String stringValue;
    private String[] stringValueList;

    public Set(Session session, int type) {
        super(session);
        this.type = type;
    }

    public void setString(String v) {
        this.stringValue = v;
    }

    @Override
    public boolean isTransactional() {
        switch (this.type) {
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 20: 
            case 26: 
            case 28: 
            case 35: 
            case 36: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int update() {
        Database database = this.session.getDatabase();
        String name = SetTypes.getTypeName(this.type);
        block0 : switch (this.type) {
            case 24: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                if (value < 0 || value > 2) {
                    throw DbException.getInvalidValueException("ALLOW_LITERALS", this.getIntValue());
                }
                database.setAllowLiterals(value);
                this.addOrUpdateSetting(name, null, value);
                break;
            }
            case 8: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("CACHE_SIZE", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                database.setCacheSize(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 13: {
                if ("TRUE".equals(this.stringValue)) break;
                String value = StringUtils.quoteStringSQL(this.stringValue);
                if (!value.equals(database.getCluster()) && !value.equals("''")) {
                    this.session.getUser().checkAdmin();
                }
                database.setCluster(value);
                this.addOrUpdateSetting(database.getSystemSession(), name, value, 0);
                database.getSystemSession().commit(true);
                break;
            }
            case 12: {
                CompareMode compareMode;
                this.session.getUser().checkAdmin();
                Table table = database.getFirstUserTable();
                if (table != null) {
                    throw DbException.get(90089, table.getSQL());
                }
                StringBuilder buff = new StringBuilder(this.stringValue);
                if (this.stringValue.equals("OFF")) {
                    compareMode = CompareMode.getInstance(null, 0);
                } else {
                    int strength = this.getIntValue();
                    buff.append(" STRENGTH ");
                    if (strength == 3) {
                        buff.append("IDENTICAL");
                    } else if (strength == 0) {
                        buff.append("PRIMARY");
                    } else if (strength == 1) {
                        buff.append("SECONDARY");
                    } else if (strength == 2) {
                        buff.append("TERTIARY");
                    }
                    compareMode = CompareMode.getInstance(this.stringValue, strength);
                }
                this.addOrUpdateSetting(name, buff.toString(), 0);
                database.setCompareMode(compareMode);
                break;
            }
            case 23: {
                this.session.getUser().checkAdmin();
                int algo = CompressTool.getCompressAlgorithm(this.stringValue);
                database.setLobCompressionAlgorithm(algo == 0 ? null : this.stringValue);
                this.addOrUpdateSetting(name, this.stringValue, 0);
                break;
            }
            case 34: {
                this.session.getUser().checkAdmin();
                if (!database.isStarting()) break;
                int value = this.getIntValue();
                this.addOrUpdateSetting(name, null, value);
                break;
            }
            case 15: {
                this.session.getUser().checkAdmin();
                database.setEventListenerClass(this.stringValue);
                break;
            }
            case 18: {
                int x = this.getIntValue();
                if (x != -1 && x < 0) {
                    throw DbException.getInvalidValueException("DB_CLOSE_DELAY", x);
                }
                this.session.getUser().checkAdmin();
                database.setCloseDelay(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 6: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("DEFAULT_LOCK_TIMEOUT", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 7: {
                this.session.getUser().checkAdmin();
                database.setDefaultTableType(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 33: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                switch (value) {
                    case 0: {
                        database.setExclusiveSession(null, false);
                        break block0;
                    }
                    case 1: {
                        database.setExclusiveSession(this.session, false);
                        break block0;
                    }
                    case 2: {
                        database.setExclusiveSession(this.session, true);
                        break block0;
                    }
                }
                throw DbException.getInvalidValueException("EXCLUSIVE", value);
            }
            case 1: {
                this.session.getUser().checkAdmin();
                database.setIgnoreCase(this.getIntValue() == 1);
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 17: {
                this.session.getUser().checkAdmin();
                database.setLockMode(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 5: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("LOCK_TIMEOUT", this.getIntValue());
                }
                this.session.setLockTimeout(this.getIntValue());
                break;
            }
            case 19: {
                int value = this.getIntValue();
                if (!database.isPersistent() || value == database.getLogMode()) break;
                this.session.getUser().checkAdmin();
                database.setLogMode(value);
                break;
            }
            case 22: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("MAX_LENGTH_INPLACE_LOB", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                database.setMaxLengthInplaceLob(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 2: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("MAX_LOG_SIZE", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                database.setMaxLogSize((long)this.getIntValue() * 1024L * 1024L);
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 16: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("MAX_MEMORY_ROWS", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                database.setMaxMemoryRows(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 21: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("MAX_MEMORY_UNDO", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                database.setMaxMemoryUndo(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 32: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("MAX_OPERATION_MEMORY", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                database.setMaxOperationMemory(value);
                break;
            }
            case 3: {
                Mode mode = Mode.getInstance(this.stringValue);
                if (mode == null) {
                    throw DbException.get(90088, this.stringValue);
                }
                if (database.getMode() == mode) break;
                this.session.getUser().checkAdmin();
                database.setMode(mode);
                break;
            }
            case 25: {
                this.session.getUser().checkAdmin();
                database.setMultiThreaded(this.getIntValue() == 1);
                break;
            }
            case 31: {
                if (database.isMultiVersion() == (this.getIntValue() == 1)) break;
                throw DbException.get(90133, "MVCC");
            }
            case 27: {
                this.session.getUser().checkAdmin();
                database.setOptimizeReuseResults(this.getIntValue() != 0);
                break;
            }
            case 36: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("QUERY_TIMEOUT", this.getIntValue());
                }
                int value = this.getIntValue();
                this.session.setQueryTimeout(value);
                break;
            }
            case 37: {
                int value = this.getIntValue();
                this.session.setRedoLogBinary(value == 1);
                break;
            }
            case 30: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                if (value < 0 || value > 1) {
                    throw DbException.getInvalidValueException("REFERENTIAL_INTEGRITY", this.getIntValue());
                }
                database.setReferentialIntegrity(value == 1);
                break;
            }
            case 26: {
                Schema schema = database.getSchema(this.stringValue);
                this.session.setCurrentSchema(schema);
                break;
            }
            case 28: {
                this.session.setSchemaSearchPath(this.stringValueList);
                break;
            }
            case 10: {
                this.session.getUser().checkAdmin();
                if (this.getCurrentObjectId() != 0) break;
                database.getTraceSystem().setLevelFile(this.getIntValue());
                break;
            }
            case 9: {
                this.session.getUser().checkAdmin();
                if (this.getCurrentObjectId() != 0) break;
                database.getTraceSystem().setLevelSystemOut(this.getIntValue());
                break;
            }
            case 11: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("TRACE_MAX_FILE_SIZE", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                int size = this.getIntValue() * 1024 * 1024;
                database.getTraceSystem().setMaxFileSize(size);
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 20: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("THROTTLE", this.getIntValue());
                }
                this.session.setThrottle(this.getIntValue());
                break;
            }
            case 29: {
                int value = this.getIntValue();
                if (value < 0 || value > 1) {
                    throw DbException.getInvalidValueException("UNDO_LOG", this.getIntValue());
                }
                this.session.setUndoLogEnabled(value == 1);
                break;
            }
            case 35: {
                Expression expr = this.expression.optimize(this.session);
                this.session.setVariable(this.stringValue, expr.getValue(this.session));
                break;
            }
            case 14: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("WRITE_DELAY", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                database.setWriteDelay(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.type);
            }
        }
        database.getNextModificationDataId();
        database.getNextModificationMetaId();
        return 0;
    }

    private int getIntValue() {
        this.expression = this.expression.optimize(this.session);
        return this.expression.getValue(this.session).getInt();
    }

    public void setInt(int value) {
        this.expression = ValueExpression.get(ValueInt.get(value));
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    private void addOrUpdateSetting(String name, String s, int v) {
        this.addOrUpdateSetting(this.session, name, s, v);
    }

    private void addOrUpdateSetting(Session session, String name, String s, int v) {
        Database database = session.getDatabase();
        if (database.isReadOnly()) {
            return;
        }
        Setting setting = database.findSetting(name);
        boolean addNew = false;
        if (setting == null) {
            addNew = true;
            int id = this.getObjectId();
            setting = new Setting(database, id, name);
        }
        if (s != null) {
            if (!addNew && setting.getStringValue().equals(s)) {
                return;
            }
            setting.setStringValue(s);
        } else {
            if (!addNew && setting.getIntValue() == v) {
                return;
            }
            setting.setIntValue(v);
        }
        if (addNew) {
            database.addDatabaseObject(session, setting);
        } else {
            database.update(session, setting);
        }
    }

    @Override
    public boolean needRecompile() {
        return false;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    public void setStringArray(String[] list) {
        this.stringValueList = list;
    }

    @Override
    public int getType() {
        return 67;
    }
}

