/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.h2.command.dml.Optimizer;
import org.h2.command.dml.Query;
import org.h2.command.dml.SelectListColumnResolver;
import org.h2.command.dml.SelectOrderBy;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.ConditionAndOr;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.Wildcard;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.ValueHashMap;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueNull;

public class Select
extends Query {
    private TableFilter topTableFilter;
    private ArrayList<TableFilter> filters = New.arrayList();
    private ArrayList<TableFilter> topFilters = New.arrayList();
    private ArrayList<Expression> expressions;
    private Expression[] expressionArray;
    private Expression having;
    private Expression condition;
    private int visibleColumnCount;
    private int distinctColumnCount;
    private ArrayList<SelectOrderBy> orderList;
    private ArrayList<Expression> group;
    private int[] groupIndex;
    private boolean[] groupByExpression;
    private HashMap<Expression, Object> currentGroup;
    private int havingIndex;
    private boolean isGroupQuery;
    private boolean isGroupSortedQuery;
    private boolean isForUpdate;
    private boolean isForUpdateMvcc;
    private double cost;
    private boolean isQuickAggregateQuery;
    private boolean isDistinctQuery;
    private boolean isPrepared;
    private boolean checkInit;
    private boolean sortUsingIndex;
    private SortOrder sort;
    private int currentGroupRowId;

    public Select(Session session) {
        super(session);
    }

    public void addTableFilter(TableFilter filter, boolean isTop) {
        this.filters.add(filter);
        if (isTop) {
            this.topFilters.add(filter);
        }
    }

    public ArrayList<TableFilter> getTopFilters() {
        return this.topFilters;
    }

    public void setExpressions(ArrayList<Expression> expressions) {
        this.expressions = expressions;
    }

    public void setGroupQuery() {
        this.isGroupQuery = true;
    }

    public void setGroupBy(ArrayList<Expression> group) {
        this.group = group;
    }

    public HashMap<Expression, Object> getCurrentGroup() {
        return this.currentGroup;
    }

    public int getCurrentGroupRowId() {
        return this.currentGroupRowId;
    }

    @Override
    public void setOrder(ArrayList<SelectOrderBy> order) {
        this.orderList = order;
    }

    public void addCondition(Expression cond) {
        this.condition = this.condition == null ? cond : new ConditionAndOr(0, cond, this.condition);
    }

    private void queryGroupSorted(int columnCount, ResultTarget result) {
        int rowNumber = 0;
        this.setCurrentRowNumber(0);
        Object[] previousKeyValues = null;
        while (this.topTableFilter.next()) {
            int i;
            this.setCurrentRowNumber(rowNumber + 1);
            if (this.condition != null && !Boolean.TRUE.equals(this.condition.getBooleanValue(this.session))) continue;
            ++rowNumber;
            Object[] keyValues = new Value[this.groupIndex.length];
            for (i = 0; i < this.groupIndex.length; ++i) {
                int idx = this.groupIndex[i];
                Expression expr = this.expressions.get(idx);
                keyValues[i] = expr.getValue(this.session);
            }
            if (previousKeyValues == null) {
                previousKeyValues = keyValues;
                this.currentGroup = New.hashMap();
            } else if (!Arrays.equals(previousKeyValues, keyValues)) {
                this.addGroupSortedRow((Value[])previousKeyValues, columnCount, result);
                previousKeyValues = keyValues;
                this.currentGroup = New.hashMap();
            }
            ++this.currentGroupRowId;
            for (i = 0; i < columnCount; ++i) {
                if (this.groupByExpression != null && this.groupByExpression[i]) continue;
                Expression expr = this.expressions.get(i);
                expr.updateAggregate(this.session);
            }
        }
        if (previousKeyValues != null) {
            this.addGroupSortedRow((Value[])previousKeyValues, columnCount, result);
        }
    }

    private void addGroupSortedRow(Value[] keyValues, int columnCount, ResultTarget result) {
        int j;
        Value[] row = new Value[columnCount];
        for (j = 0; this.groupIndex != null && j < this.groupIndex.length; ++j) {
            row[this.groupIndex[j]] = keyValues[j];
        }
        for (j = 0; j < columnCount; ++j) {
            if (this.groupByExpression != null && this.groupByExpression[j]) continue;
            Expression expr = this.expressions.get(j);
            row[j] = expr.getValue(this.session);
        }
        if (this.isHavingNullOrFalse(row)) {
            return;
        }
        row = this.keepOnlyDistinct(row, columnCount);
        result.addRow(row);
    }

    private Value[] keepOnlyDistinct(Value[] row, int columnCount) {
        if (columnCount == this.distinctColumnCount) {
            return row;
        }
        Value[] r2 = new Value[this.distinctColumnCount];
        System.arraycopy(row, 0, r2, 0, this.distinctColumnCount);
        return r2;
    }

    private boolean isHavingNullOrFalse(Value[] row) {
        if (this.havingIndex >= 0) {
            Value v = row[this.havingIndex];
            if (v == ValueNull.INSTANCE) {
                return true;
            }
            if (!Boolean.TRUE.equals(v.getBoolean())) {
                return true;
            }
        }
        return false;
    }

    private Index getGroupSortedIndex() {
        if (this.groupIndex == null || this.groupByExpression == null) {
            return null;
        }
        ArrayList<Index> indexes = this.topTableFilter.getTable().getIndexes();
        if (indexes != null) {
            int size = indexes.size();
            for (int i = 0; i < size; ++i) {
                Index index = indexes.get(i);
                if (index.getIndexType().isScan() || !this.isGroupSortedIndex(this.topTableFilter, index)) continue;
                return index;
            }
        }
        return null;
    }

    private boolean isGroupSortedIndex(TableFilter tableFilter, Index index) {
        int i;
        Column[] indexColumns = index.getColumns();
        boolean[] grouped = new boolean[indexColumns.length];
        int size = this.expressions.size();
        block0: for (i = 0; i < size; ++i) {
            if (!this.groupByExpression[i]) continue;
            Expression expr = this.expressions.get(i).getNonAliasExpression();
            if (!(expr instanceof ExpressionColumn)) {
                return false;
            }
            ExpressionColumn exprCol = (ExpressionColumn)expr;
            for (int j = 0; j < indexColumns.length; ++j) {
                if (tableFilter != exprCol.getTableFilter() || !indexColumns[j].equals(exprCol.getColumn())) continue;
                grouped[j] = true;
                continue block0;
            }
            return false;
        }
        for (i = 1; i < grouped.length; ++i) {
            if (grouped[i - 1] || !grouped[i]) continue;
            return false;
        }
        return true;
    }

    private int getGroupByExpressionCount() {
        if (this.groupByExpression == null) {
            return 0;
        }
        int count = 0;
        for (boolean b : this.groupByExpression) {
            if (!b) continue;
            ++count;
        }
        return count;
    }

    private void queryGroup(int columnCount, LocalResult result) {
        ValueHashMap groups = ValueHashMap.newInstance();
        int rowNumber = 0;
        this.setCurrentRowNumber(0);
        ValueArray defaultGroup = ValueArray.get(new Value[0]);
        while (this.topTableFilter.next()) {
            Expression expr;
            ValueArray key;
            this.setCurrentRowNumber(rowNumber + 1);
            if (this.condition != null && !Boolean.TRUE.equals(this.condition.getBooleanValue(this.session))) continue;
            ++rowNumber;
            if (this.groupIndex == null) {
                key = defaultGroup;
            } else {
                Value[] keyValues = new Value[this.groupIndex.length];
                for (int i = 0; i < this.groupIndex.length; ++i) {
                    int idx = this.groupIndex[i];
                    expr = this.expressions.get(idx);
                    keyValues[i] = expr.getValue(this.session);
                }
                key = ValueArray.get(keyValues);
            }
            HashMap values = (HashMap)groups.get(key);
            if (values == null) {
                values = new HashMap();
                groups.put(key, values);
            }
            this.currentGroup = values;
            ++this.currentGroupRowId;
            int len = columnCount;
            for (int i = 0; i < len; ++i) {
                if (this.groupByExpression != null && this.groupByExpression[i]) continue;
                expr = this.expressions.get(i);
                expr.updateAggregate(this.session);
            }
            if (this.sampleSize <= 0 || rowNumber < this.sampleSize) continue;
            break;
        }
        if (this.groupIndex == null && groups.size() == 0) {
            groups.put(defaultGroup, new HashMap());
        }
        ArrayList<Value> keys = groups.keys();
        for (Value v : keys) {
            int j;
            ValueArray key = (ValueArray)v;
            this.currentGroup = (HashMap)groups.get(key);
            Value[] keyValues = key.getList();
            Value[] row = new Value[columnCount];
            for (j = 0; this.groupIndex != null && j < this.groupIndex.length; ++j) {
                row[this.groupIndex[j]] = keyValues[j];
            }
            for (j = 0; j < columnCount; ++j) {
                if (this.groupByExpression != null && this.groupByExpression[j]) continue;
                Expression expr = this.expressions.get(j);
                row[j] = expr.getValue(this.session);
            }
            if (this.isHavingNullOrFalse(row)) continue;
            row = this.keepOnlyDistinct(row, columnCount);
            result.addRow(row);
        }
    }

    private Index getSortIndex() {
        Index index;
        if (this.sort == null) {
            return null;
        }
        ArrayList<Column> sortColumns = New.arrayList();
        for (int idx : this.sort.getIndexes()) {
            if (idx < 0 || idx >= this.expressions.size()) {
                throw DbException.getInvalidValueException("ORDER BY", idx + 1);
            }
            Expression expr = this.expressions.get(idx);
            if ((expr = expr.getNonAliasExpression()).isConstant()) continue;
            if (!(expr instanceof ExpressionColumn)) {
                return null;
            }
            ExpressionColumn exprCol = (ExpressionColumn)expr;
            if (exprCol.getTableFilter() != this.topTableFilter) {
                return null;
            }
            sortColumns.add(exprCol.getColumn());
        }
        Column[] sortCols = sortColumns.toArray(new Column[sortColumns.size()]);
        int[] sortTypes = this.sort.getSortTypes();
        if (sortCols.length == 0) {
            return this.topTableFilter.getTable().getScanIndex(this.session);
        }
        ArrayList<Index> list = this.topTableFilter.getTable().getIndexes();
        if (list != null) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                IndexColumn[] indexCols;
                Index index2 = list.get(i);
                if (index2.getCreateSQL() == null || index2.getIndexType().isHash() || (indexCols = index2.getIndexColumns()).length < sortCols.length) continue;
                boolean ok = true;
                for (int j = 0; j < sortCols.length; ++j) {
                    IndexColumn idxCol = indexCols[j];
                    Column sortCol = sortCols[j];
                    if (idxCol.column != sortCol) {
                        ok = false;
                        break;
                    }
                    if (idxCol.sortType == sortTypes[j]) continue;
                    ok = false;
                    break;
                }
                if (!ok) continue;
                return index2;
            }
        }
        if (sortCols.length == 1 && sortCols[0].getColumnId() == -1 && (index = this.topTableFilter.getTable().getScanIndex(this.session)).isRowIdIndex()) {
            return index;
        }
        return null;
    }

    private void queryDistinct(ResultTarget result, long limitRows) {
        int offset;
        if (limitRows > 0L && this.offsetExpr != null && (offset = this.offsetExpr.getValue(this.session).getInt()) > 0) {
            limitRows += (long)offset;
        }
        int rowNumber = 0;
        this.setCurrentRowNumber(0);
        Index index = this.topTableFilter.getIndex();
        SearchRow first = null;
        int columnIndex = index.getColumns()[0].getColumnId();
        do {
            this.setCurrentRowNumber(rowNumber + 1);
            Cursor cursor = index.findNext(this.session, first, null);
            if (!cursor.next()) break;
            SearchRow found = cursor.getSearchRow();
            Value value = found.getValue(columnIndex);
            if (first == null) {
                first = this.topTableFilter.getTable().getTemplateSimpleRow(true);
            }
            first.setValue(columnIndex, value);
            Value[] row = new Value[]{value};
            result.addRow(row);
        } while ((this.sort != null && !this.sortUsingIndex || limitRows <= 0L || (long)(++rowNumber) < limitRows) && (this.sampleSize <= 0 || rowNumber < this.sampleSize));
    }

    private void queryFlat(int columnCount, ResultTarget result, long limitRows) {
        int offset;
        if (limitRows > 0L && this.offsetExpr != null && (offset = this.offsetExpr.getValue(this.session).getInt()) > 0) {
            limitRows += (long)offset;
        }
        int rowNumber = 0;
        this.setCurrentRowNumber(0);
        ArrayList<Row> forUpdateRows = null;
        if (this.isForUpdateMvcc) {
            forUpdateRows = New.arrayList();
        }
        while (this.topTableFilter.next()) {
            this.setCurrentRowNumber(rowNumber + 1);
            if (this.condition != null && !Boolean.TRUE.equals(this.condition.getBooleanValue(this.session))) continue;
            Value[] row = new Value[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                Expression expr = this.expressions.get(i);
                row[i] = expr.getValue(this.session);
            }
            if (this.isForUpdateMvcc) {
                this.topTableFilter.lockRowAdd(forUpdateRows);
            }
            result.addRow(row);
            if ((this.sort != null && !this.sortUsingIndex || limitRows <= 0L || (long)result.getRowCount() < limitRows) && (this.sampleSize <= 0 || ++rowNumber < this.sampleSize)) continue;
            break;
        }
        if (this.isForUpdateMvcc) {
            this.topTableFilter.lockRows(forUpdateRows);
        }
    }

    private void queryQuick(int columnCount, ResultTarget result) {
        Value[] row = new Value[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            Expression expr = this.expressions.get(i);
            row[i] = expr.getValue(this.session);
        }
        result.addRow(row);
    }

    @Override
    public ResultInterface queryMeta() {
        LocalResult result = new LocalResult(this.session, this.expressionArray, this.visibleColumnCount);
        result.done();
        return result;
    }

    @Override
    protected LocalResult queryWithoutCache(int maxRows, ResultTarget target) {
        ResultTarget to;
        boolean exclusive;
        int limitRows;
        int n = limitRows = maxRows == 0 ? -1 : maxRows;
        if (this.limitExpr != null) {
            int l;
            Value v = this.limitExpr.getValue(this.session);
            int n2 = l = v == ValueNull.INSTANCE ? -1 : v.getInt();
            if (limitRows < 0) {
                limitRows = l;
            } else if (l >= 0) {
                limitRows = Math.min(l, limitRows);
            }
        }
        int columnCount = this.expressions.size();
        LocalResult result = null;
        if (target == null || !this.session.getDatabase().getSettings().optimizeInsertFromSelect) {
            result = this.createLocalResult(result);
        }
        if (this.sort != null && (!this.sortUsingIndex || this.distinct)) {
            result = this.createLocalResult(result);
            result.setSortOrder(this.sort);
        }
        if (this.distinct && !this.isDistinctQuery) {
            result = this.createLocalResult(result);
            result.setDistinct();
        }
        if (this.randomAccessResult) {
            result = this.createLocalResult(result);
            result.setRandomAccess();
        }
        if (this.isGroupQuery && !this.isGroupSortedQuery) {
            result = this.createLocalResult(result);
        }
        if (limitRows >= 0 || this.offsetExpr != null) {
            result = this.createLocalResult(result);
        }
        this.topTableFilter.startQuery(this.session);
        this.topTableFilter.reset();
        boolean bl = exclusive = this.isForUpdate && !this.isForUpdateMvcc;
        if (this.isForUpdateMvcc) {
            if (this.isGroupQuery) {
                throw DbException.getUnsupportedException("FOR UPDATE && GROUP");
            }
            if (this.distinct) {
                throw DbException.getUnsupportedException("FOR UPDATE && DISTINCT");
            }
            if (this.isQuickAggregateQuery) {
                throw DbException.getUnsupportedException("FOR UPDATE && AGGREGATE");
            }
            if (this.topTableFilter.getJoin() != null) {
                throw DbException.getUnsupportedException("FOR UPDATE && JOIN");
            }
            if (this.topTableFilter.getJoin() != null) {
                throw DbException.getUnsupportedException("FOR UPDATE && JOIN");
            }
        }
        this.topTableFilter.lock(this.session, exclusive, exclusive);
        ResultTarget resultTarget = to = result != null ? result : target;
        if (limitRows != 0) {
            if (this.isQuickAggregateQuery) {
                this.queryQuick(columnCount, to);
            } else if (this.isGroupQuery) {
                if (this.isGroupSortedQuery) {
                    this.queryGroupSorted(columnCount, to);
                } else {
                    this.queryGroup(columnCount, result);
                }
            } else if (this.isDistinctQuery) {
                this.queryDistinct(to, limitRows);
            } else {
                this.queryFlat(columnCount, to, limitRows);
            }
        }
        if (this.offsetExpr != null) {
            result.setOffset(this.offsetExpr.getValue(this.session).getInt());
        }
        if (limitRows >= 0) {
            result.setLimit(limitRows);
        }
        if (result != null) {
            result.done();
            if (target != null) {
                while (result.next()) {
                    target.addRow(result.currentRow());
                }
                result.close();
                return null;
            }
            return result;
        }
        return null;
    }

    private LocalResult createLocalResult(LocalResult old) {
        return old != null ? old : new LocalResult(this.session, this.expressionArray, this.visibleColumnCount);
    }

    private void expandColumnList() {
        Database db = this.session.getDatabase();
        for (int i = 0; i < this.expressions.size(); ++i) {
            Column[] columns;
            Expression expr = this.expressions.get(i);
            if (!expr.isWildcard()) continue;
            String schemaName = expr.getSchemaName();
            String tableAlias = expr.getTableAlias();
            if (tableAlias == null) {
                int temp = i;
                this.expressions.remove(i);
                for (TableFilter filter : this.filters) {
                    Wildcard c2 = new Wildcard(filter.getTable().getSchema().getName(), filter.getTableAlias());
                    this.expressions.add(i++, c2);
                }
                i = temp - 1;
                continue;
            }
            TableFilter filter = null;
            for (TableFilter f : this.filters) {
                if (!db.equalsIdentifiers(tableAlias, f.getTableAlias()) || schemaName != null && !db.equalsIdentifiers(schemaName, f.getSchemaName())) continue;
                filter = f;
                break;
            }
            if (filter == null) {
                throw DbException.get(42102, tableAlias);
            }
            Table t = filter.getTable();
            String alias = filter.getTableAlias();
            this.expressions.remove(i);
            for (Column c : columns = t.getColumns()) {
                if (filter.isNaturalJoinColumn(c)) continue;
                ExpressionColumn ec = new ExpressionColumn(this.session.getDatabase(), null, alias, c.getName());
                this.expressions.add(i++, ec);
            }
            --i;
        }
    }

    @Override
    public void init() {
        ArrayList<String> expressionSQL;
        if (SysProperties.CHECK && this.checkInit) {
            DbException.throwInternalError();
        }
        this.expandColumnList();
        this.visibleColumnCount = this.expressions.size();
        if (this.orderList != null || this.group != null) {
            expressionSQL = New.arrayList();
            for (int i = 0; i < this.visibleColumnCount; ++i) {
                Expression expr = this.expressions.get(i);
                expr = expr.getNonAliasExpression();
                String sql = expr.getSQL();
                expressionSQL.add(sql);
            }
        } else {
            expressionSQL = null;
        }
        if (this.orderList != null) {
            Select.initOrder(this.session, this.expressions, expressionSQL, this.orderList, this.visibleColumnCount, this.distinct, this.filters);
        }
        this.distinctColumnCount = this.expressions.size();
        if (this.having != null) {
            this.expressions.add(this.having);
            this.havingIndex = this.expressions.size() - 1;
            this.having = null;
        } else {
            this.havingIndex = -1;
        }
        Database db = this.session.getDatabase();
        if (this.group != null) {
            int size = this.group.size();
            int expSize = expressionSQL.size();
            this.groupIndex = new int[size];
            for (int i = 0; i < size; ++i) {
                int j;
                Expression expr = this.group.get(i);
                String sql = expr.getSQL();
                int found = -1;
                for (j = 0; j < expSize; ++j) {
                    String s2 = expressionSQL.get(j);
                    if (!db.equalsIdentifiers(s2, sql)) continue;
                    found = j;
                    break;
                }
                if (found < 0) {
                    for (j = 0; j < expSize; ++j) {
                        Expression e = this.expressions.get(j);
                        if (!db.equalsIdentifiers(sql, e.getAlias())) continue;
                        found = j;
                        break;
                    }
                }
                if (found < 0) {
                    int index;
                    this.groupIndex[i] = index = this.expressions.size();
                    this.expressions.add(expr);
                    continue;
                }
                this.groupIndex[i] = found;
            }
            this.groupByExpression = new boolean[this.expressions.size()];
            for (int gi : this.groupIndex) {
                this.groupByExpression[gi] = true;
            }
            this.group = null;
        }
        for (TableFilter f : this.filters) {
            for (Expression expr : this.expressions) {
                expr.mapColumns(f, 0);
            }
            if (this.condition == null) continue;
            this.condition.mapColumns(f, 0);
        }
        if (this.havingIndex >= 0) {
            Expression expr = this.expressions.get(this.havingIndex);
            SelectListColumnResolver res = new SelectListColumnResolver(this);
            expr.mapColumns(res, 0);
        }
        this.checkInit = true;
    }

    @Override
    public void prepare() {
        Index current;
        Index index;
        if (this.isPrepared) {
            return;
        }
        if (SysProperties.CHECK && !this.checkInit) {
            DbException.throwInternalError("not initialized");
        }
        if (this.orderList != null) {
            this.sort = this.prepareOrder(this.orderList, this.expressions.size());
            this.orderList = null;
        }
        for (int i = 0; i < this.expressions.size(); ++i) {
            Expression e = this.expressions.get(i);
            this.expressions.set(i, e.optimize(this.session));
        }
        if (this.condition != null) {
            this.condition = this.condition.optimize(this.session);
            for (TableFilter f : this.filters) {
                if (f.isJoinOuter() || f.isJoinOuterIndirect()) continue;
                this.condition.createIndexConditions(this.session, f);
            }
        }
        if (this.isGroupQuery && this.groupIndex == null && this.havingIndex < 0 && this.filters.size() == 1 && this.condition == null) {
            Table t = this.filters.get(0).getTable();
            ExpressionVisitor optimizable = ExpressionVisitor.getOptimizableVisitor(t);
            this.isQuickAggregateQuery = this.isEverything(optimizable);
        }
        this.cost = this.preparePlan();
        if (this.distinct && this.session.getDatabase().getSettings().optimizeDistinct && !this.isGroupQuery && this.filters.size() == 1 && this.expressions.size() == 1 && this.condition == null) {
            Expression expr = this.expressions.get(0);
            if ((expr = expr.getNonAliasExpression()) instanceof ExpressionColumn) {
                Column column = ((ExpressionColumn)expr).getColumn();
                int selectivity = column.getSelectivity();
                Index columnIndex = this.topTableFilter.getTable().getIndexForColumn(column, true);
                if (columnIndex != null && selectivity != 50 && selectivity < 20) {
                    IndexType type;
                    boolean ascending = columnIndex.getIndexColumns()[0].sortType == 0;
                    Index current2 = this.topTableFilter.getIndex();
                    if (!(!columnIndex.canFindNext() || !ascending || current2 != null && !current2.getIndexType().isScan() && columnIndex != current2 || (type = columnIndex.getIndexType()).isHash() || type.isUnique() && columnIndex.getColumns().length <= 1)) {
                        this.topTableFilter.setIndex(columnIndex);
                        this.isDistinctQuery = true;
                    }
                }
            }
        }
        if (this.sort != null && !this.isQuickAggregateQuery && !this.isGroupQuery && (index = this.getSortIndex()) != null) {
            current = this.topTableFilter.getIndex();
            if (current.getIndexType().isScan() || current == index) {
                this.topTableFilter.setIndex(index);
                if (!this.topTableFilter.hasInComparisons()) {
                    this.sortUsingIndex = true;
                }
            } else if (index.getIndexColumns().length >= current.getIndexColumns().length) {
                IndexColumn[] sortColumns = index.getIndexColumns();
                IndexColumn[] currentColumns = current.getIndexColumns();
                boolean swapIndex = false;
                for (int i = 0; i < currentColumns.length; ++i) {
                    if (sortColumns[i].column != currentColumns[i].column) {
                        swapIndex = false;
                        break;
                    }
                    if (sortColumns[i].sortType == currentColumns[i].sortType) continue;
                    swapIndex = true;
                }
                if (swapIndex) {
                    this.topTableFilter.setIndex(index);
                    this.sortUsingIndex = true;
                }
            }
        }
        if (!this.isQuickAggregateQuery && this.isGroupQuery && this.getGroupByExpressionCount() > 0) {
            index = this.getGroupSortedIndex();
            current = this.topTableFilter.getIndex();
            if (index != null && (current.getIndexType().isScan() || current == index)) {
                this.topTableFilter.setIndex(index);
                this.isGroupSortedQuery = true;
            }
        }
        this.expressionArray = new Expression[this.expressions.size()];
        this.expressions.toArray(this.expressionArray);
        this.isPrepared = true;
    }

    @Override
    public double getCost() {
        return this.cost;
    }

    @Override
    public HashSet<Table> getTables() {
        HashSet<Table> set = New.hashSet();
        for (TableFilter filter : this.filters) {
            set.add(filter.getTable());
        }
        return set;
    }

    @Override
    public void fireBeforeSelectTriggers() {
        int size = this.filters.size();
        for (int i = 0; i < size; ++i) {
            TableFilter filter = this.filters.get(i);
            filter.getTable().fire(this.session, 8, true);
        }
    }

    private double preparePlan() {
        TableFilter[] topArray;
        for (TableFilter t : topArray = this.topFilters.toArray(new TableFilter[this.topFilters.size()])) {
            t.setFullCondition(this.condition);
        }
        Optimizer optimizer = new Optimizer(topArray, this.condition, this.session);
        optimizer.optimize();
        this.topTableFilter = optimizer.getTopFilter();
        double planCost = optimizer.getCost();
        this.setEvaluatableRecursive(this.topTableFilter);
        this.topTableFilter.prepare();
        return planCost;
    }

    private void setEvaluatableRecursive(TableFilter f) {
        while (f != null) {
            Expression on;
            TableFilter n;
            f.setEvaluatable(f, true);
            if (this.condition != null) {
                this.condition.setEvaluatable(f, true);
            }
            if ((n = f.getNestedJoin()) != null) {
                this.setEvaluatableRecursive(n);
            }
            if ((on = f.getJoinCondition()) != null && !on.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR)) {
                if (this.session.getDatabase().getSettings().nestedJoins) {
                    on = on.optimize(this.session);
                    if (!f.isJoinOuter() && !f.isJoinOuterIndirect()) {
                        f.removeJoinCondition();
                        this.addCondition(on);
                    }
                } else {
                    if (f.isJoinOuter()) {
                        on = on.optimize(this.session);
                        throw DbException.get(90136, on.getSQL());
                    }
                    f.removeJoinCondition();
                    on = on.optimize(this.session);
                    this.addCondition(on);
                }
            }
            if ((on = f.getFilterCondition()) != null && !on.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR)) {
                f.removeFilterCondition();
                this.addCondition(on);
            }
            for (Expression e : this.expressions) {
                e.setEvaluatable(f, true);
            }
            f = f.getJoin();
        }
    }

    @Override
    public String getPlanSQL() {
        int i;
        Expression[] exprList = this.expressions.toArray(new Expression[this.expressions.size()]);
        StatementBuilder buff = new StatementBuilder("SELECT");
        if (this.distinct) {
            buff.append(" DISTINCT");
        }
        for (int i2 = 0; i2 < this.visibleColumnCount; ++i2) {
            buff.appendExceptFirst(",");
            buff.append('\n');
            buff.append(StringUtils.indent(exprList[i2].getSQL(), 4, false));
        }
        buff.append("\nFROM ");
        TableFilter filter = this.topTableFilter;
        if (filter != null) {
            buff.resetCount();
            i = 0;
            do {
                buff.appendExceptFirst("\n");
                buff.append(filter.getPlanSQL(i++ > 0));
            } while ((filter = filter.getJoin()) != null);
        } else {
            buff.resetCount();
            i = 0;
            for (TableFilter f : this.topFilters) {
                do {
                    buff.appendExceptFirst("\n");
                    buff.append(f.getPlanSQL(i++ > 0));
                } while ((f = f.getJoin()) != null);
            }
        }
        if (this.condition != null) {
            buff.append("\nWHERE ").append(StringUtils.unEnclose(this.condition.getSQL()));
        }
        if (this.groupIndex != null) {
            buff.append("\nGROUP BY ");
            buff.resetCount();
            for (int gi : this.groupIndex) {
                Expression g = exprList[gi];
                g = g.getNonAliasExpression();
                buff.appendExceptFirst(", ");
                buff.append(StringUtils.unEnclose(g.getSQL()));
            }
        }
        if (this.group != null) {
            buff.append("\nGROUP BY ");
            buff.resetCount();
            for (Expression g : this.group) {
                buff.appendExceptFirst(", ");
                buff.append(StringUtils.unEnclose(g.getSQL()));
            }
        }
        if (this.having != null) {
            Expression h = this.having;
            buff.append("\nHAVING ").append(StringUtils.unEnclose(h.getSQL()));
        } else if (this.havingIndex >= 0) {
            Expression h = exprList[this.havingIndex];
            buff.append("\nHAVING ").append(StringUtils.unEnclose(h.getSQL()));
        }
        if (this.sort != null) {
            buff.append("\nORDER BY ").append(this.sort.getSQL(exprList, this.visibleColumnCount));
        }
        if (this.orderList != null) {
            buff.append("\nORDER BY ");
            buff.resetCount();
            for (SelectOrderBy o : this.orderList) {
                buff.appendExceptFirst(", ");
                buff.append(StringUtils.unEnclose(o.getSQL()));
            }
        }
        if (this.limitExpr != null) {
            buff.append("\nLIMIT ").append(StringUtils.unEnclose(this.limitExpr.getSQL()));
            if (this.offsetExpr != null) {
                buff.append(" OFFSET ").append(StringUtils.unEnclose(this.offsetExpr.getSQL()));
            }
        }
        if (this.sampleSize != 0) {
            buff.append("\nSAMPLE_SIZE ").append(this.sampleSize);
        }
        if (this.isForUpdate) {
            buff.append("\nFOR UPDATE");
        }
        if (this.isQuickAggregateQuery) {
            buff.append("\n/* direct lookup */");
        }
        if (this.isDistinctQuery) {
            buff.append("\n/* distinct */");
        }
        if (this.sortUsingIndex) {
            buff.append("\n/* index sorted */");
        }
        if (this.isGroupQuery && this.isGroupSortedQuery) {
            buff.append("\n/* group sorted */");
        }
        return buff.toString();
    }

    public void setHaving(Expression having) {
        this.having = having;
    }

    @Override
    public int getColumnCount() {
        return this.visibleColumnCount;
    }

    public TableFilter getTopTableFilter() {
        return this.topTableFilter;
    }

    @Override
    public ArrayList<Expression> getExpressions() {
        return this.expressions;
    }

    @Override
    public void setForUpdate(boolean b) {
        this.isForUpdate = b;
        if (this.session.getDatabase().getSettings().selectForUpdateMvcc && this.session.getDatabase().isMultiVersion()) {
            this.isForUpdateMvcc = b;
        }
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level) {
        for (Expression e : this.expressions) {
            e.mapColumns(resolver, level);
        }
        if (this.condition != null) {
            this.condition.mapColumns(resolver, level);
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        for (Expression e : this.expressions) {
            e.setEvaluatable(tableFilter, b);
        }
        if (this.condition != null) {
            this.condition.setEvaluatable(tableFilter, b);
        }
    }

    public boolean isQuickAggregateQuery() {
        return this.isQuickAggregateQuery;
    }

    @Override
    public void addGlobalCondition(Parameter param, int columnId, int comparisonType) {
        this.addParameter(param);
        Expression col = this.expressions.get(columnId);
        col = col.getNonAliasExpression();
        Expression comp = col.isEverything(ExpressionVisitor.QUERY_COMPARABLE_VISITOR) ? new Comparison(this.session, comparisonType, col, param) : new Comparison(this.session, 16, param, param);
        comp = ((Expression)comp).optimize(this.session);
        boolean addToCondition = true;
        if (this.isGroupQuery) {
            addToCondition = false;
            for (int i = 0; this.groupIndex != null && i < this.groupIndex.length; ++i) {
                if (this.groupIndex[i] != columnId) continue;
                addToCondition = true;
                break;
            }
            if (!addToCondition) {
                if (this.havingIndex >= 0) {
                    this.having = this.expressions.get(this.havingIndex);
                }
                this.having = this.having == null ? comp : new ConditionAndOr(0, this.having, comp);
            }
        }
        if (addToCondition) {
            this.condition = this.condition == null ? comp : new ConditionAndOr(0, this.condition, comp);
        }
    }

    @Override
    public void updateAggregate(Session s) {
        for (Expression e : this.expressions) {
            e.updateAggregate(s);
        }
        if (this.condition != null) {
            this.condition.updateAggregate(s);
        }
        if (this.having != null) {
            this.having.updateAggregate(s);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.getType()) {
            case 2: {
                TableFilter f;
                int i;
                if (this.isForUpdate) {
                    return false;
                }
                int size = this.filters.size();
                for (i = 0; i < size; ++i) {
                    f = this.filters.get(i);
                    if (f.getTable().isDeterministic()) continue;
                    return false;
                }
                break;
            }
            case 4: {
                TableFilter f;
                int i;
                int size = this.filters.size();
                for (i = 0; i < size; ++i) {
                    f = this.filters.get(i);
                    long m = f.getTable().getMaxDataModificationId();
                    visitor.addDataModificationId(m);
                }
                break;
            }
            case 3: {
                if (this.session.getDatabase().getSettings().optimizeEvaluatableSubqueries) break;
                return false;
            }
            case 7: {
                TableFilter f;
                int i;
                int size = this.filters.size();
                for (i = 0; i < size; ++i) {
                    f = this.filters.get(i);
                    Table table = f.getTable();
                    visitor.addDependency(table);
                    table.addDependencies(visitor.getDependencies());
                }
                break;
            }
        }
        ExpressionVisitor v2 = visitor.incrementQueryLevel(1);
        boolean result = true;
        int size = this.expressions.size();
        for (int i = 0; i < size; ++i) {
            Expression e = this.expressions.get(i);
            if (e.isEverything(v2)) continue;
            result = false;
            break;
        }
        if (result && this.condition != null && !this.condition.isEverything(v2)) {
            result = false;
        }
        if (result && this.having != null && !this.having.isEverything(v2)) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean isReadOnly() {
        return this.isEverything(ExpressionVisitor.READONLY_VISITOR);
    }

    @Override
    public boolean isCacheable() {
        return !this.isForUpdate;
    }

    @Override
    public int getType() {
        return 66;
    }

    @Override
    public boolean allowGlobalConditions() {
        return this.offsetExpr == null && (this.limitExpr == null || this.sort == null);
    }
}

