/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import org.h2.command.Command;
import org.h2.command.Prepared;
import org.h2.command.dml.Query;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.Parameter;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.value.Value;

public class Insert
extends Prepared
implements ResultTarget {
    private Table table;
    private Column[] columns;
    private ArrayList<Expression[]> list = New.arrayList();
    private Query query;
    private boolean sortedInsertMode;
    private int rowNumber;
    private boolean insertFromSelect;

    public Insert(Session session) {
        super(session);
    }

    @Override
    public void setCommand(Command command) {
        super.setCommand(command);
        if (this.query != null) {
            this.query.setCommand(command);
        }
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(Column[] columns) {
        this.columns = columns;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void addRow(Expression[] expr) {
        this.list.add(expr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update() {
        Index index = null;
        if (this.sortedInsertMode) {
            index = this.table.getScanIndex(this.session);
            index.setSortedInsertMode(true);
        }
        try {
            int n = this.insertRows();
            return n;
        }
        finally {
            if (index != null) {
                index.setSortedInsertMode(false);
            }
        }
    }

    private int insertRows() {
        this.session.getUser().checkRight(this.table, 4);
        this.setCurrentRowNumber(0);
        this.table.fire(this.session, 1, true);
        this.rowNumber = 0;
        int listSize = this.list.size();
        if (listSize > 0) {
            int columnLen = this.columns.length;
            for (int x = 0; x < listSize; ++x) {
                Row newRow = this.table.getTemplateRow();
                Expression[] expr = this.list.get(x);
                this.setCurrentRowNumber(x + 1);
                for (int i = 0; i < columnLen; ++i) {
                    Column c = this.columns[i];
                    int index = c.getColumnId();
                    Expression e = expr[i];
                    if (e == null) continue;
                    e = e.optimize(this.session);
                    try {
                        Value v = c.convert(e.getValue(this.session));
                        newRow.setValue(index, v);
                        continue;
                    }
                    catch (DbException ex) {
                        throw this.setRow(ex, x, Insert.getSQL(expr));
                    }
                }
                ++this.rowNumber;
                this.table.validateConvertUpdateSequence(this.session, newRow);
                boolean done = this.table.fireBeforeRow(this.session, null, newRow);
                if (done) continue;
                this.table.lock(this.session, true, false);
                this.table.addRow(this.session, newRow);
                this.session.log(this.table, (short)0, newRow);
                this.table.fireAfterRow(this.session, null, newRow, false);
            }
        } else {
            this.table.lock(this.session, true, false);
            if (this.insertFromSelect) {
                this.query.query(0, this);
            } else {
                LocalResult rows = this.query.query(0);
                while (rows.next()) {
                    Value[] r = rows.currentRow();
                    this.addRow(r);
                }
                rows.close();
            }
        }
        this.table.fire(this.session, 1, false);
        return this.rowNumber;
    }

    @Override
    public void addRow(Value[] values) {
        Row newRow = this.table.getTemplateRow();
        this.setCurrentRowNumber(++this.rowNumber);
        int len = this.columns.length;
        for (int j = 0; j < len; ++j) {
            Column c = this.columns[j];
            int index = c.getColumnId();
            try {
                Value v = c.convert(values[j]);
                newRow.setValue(index, v);
                continue;
            }
            catch (DbException ex) {
                throw this.setRow(ex, this.rowNumber, Insert.getSQL(values));
            }
        }
        this.table.validateConvertUpdateSequence(this.session, newRow);
        boolean done = this.table.fireBeforeRow(this.session, null, newRow);
        if (!done) {
            this.table.addRow(this.session, newRow);
            this.session.log(this.table, (short)0, newRow);
            this.table.fireAfterRow(this.session, null, newRow, false);
        }
    }

    @Override
    public int getRowCount() {
        return this.rowNumber;
    }

    @Override
    public String getPlanSQL() {
        StatementBuilder buff = new StatementBuilder("INSERT INTO ");
        buff.append(this.table.getSQL()).append('(');
        for (Column c : this.columns) {
            buff.appendExceptFirst(", ");
            buff.append(c.getSQL());
        }
        buff.append(")\n");
        if (this.insertFromSelect) {
            buff.append("DIRECT ");
        }
        if (this.sortedInsertMode) {
            buff.append("SORTED ");
        }
        if (this.list.size() > 0) {
            buff.append("VALUES ");
            int row = 0;
            if (this.list.size() > 1) {
                buff.append('\n');
            }
            for (Expression[] expr : this.list) {
                if (row++ > 0) {
                    buff.append(",\n");
                }
                buff.append('(');
                buff.resetCount();
                for (Expression e : expr) {
                    buff.appendExceptFirst(", ");
                    if (e == null) {
                        buff.append("DEFAULT");
                        continue;
                    }
                    buff.append(e.getSQL());
                }
                buff.append(')');
            }
        } else {
            buff.append(this.query.getPlanSQL());
        }
        return buff.toString();
    }

    @Override
    public void prepare() {
        if (this.columns == null) {
            this.columns = this.list.size() > 0 && this.list.get(0).length == 0 ? new Column[0] : this.table.getColumns();
        }
        if (this.list.size() > 0) {
            for (Expression[] expr : this.list) {
                if (expr.length != this.columns.length) {
                    throw DbException.get(21002);
                }
                int len = expr.length;
                for (int i = 0; i < len; ++i) {
                    Expression e = expr[i];
                    if (e == null) continue;
                    if ((e = e.optimize(this.session)) instanceof Parameter) {
                        Parameter p = (Parameter)e;
                        p.setColumn(this.columns[i]);
                    }
                    expr[i] = e;
                }
            }
        } else {
            this.query.prepare();
            if (this.query.getColumnCount() != this.columns.length) {
                throw DbException.get(21002);
            }
        }
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    public void setSortedInsertMode(boolean sortedInsertMode) {
        this.sortedInsertMode = sortedInsertMode;
    }

    @Override
    public int getType() {
        return 61;
    }

    public void setInsertFromSelect(boolean value) {
        this.insertFromSelect = value;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }
}

