/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.AbstractMap;
import java.util.Map;
import java.util.TreeMap;
import org.h2.command.Prepared;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.store.PageStore;
import org.h2.table.Column;
import org.h2.value.Value;
import org.h2.value.ValueString;

public class Explain
extends Prepared {
    private Prepared command;
    private LocalResult result;
    private boolean executeCommand;

    public Explain(Session session) {
        super(session);
    }

    public void setCommand(Prepared command) {
        this.command = command;
    }

    @Override
    public void prepare() {
        this.command.prepare();
    }

    public void setExecuteCommand(boolean executeCommand) {
        this.executeCommand = executeCommand;
    }

    @Override
    public ResultInterface queryMeta() {
        return this.query(-1);
    }

    @Override
    public ResultInterface query(int maxrows) {
        Column column = new Column("PLAN", 13);
        Database db = this.session.getDatabase();
        ExpressionColumn expr = new ExpressionColumn(db, column);
        Expression[] expressions = new Expression[]{expr};
        this.result = new LocalResult(this.session, expressions, 1);
        if (maxrows >= 0) {
            String plan;
            if (this.executeCommand) {
                AbstractMap statistics;
                PageStore store;
                PageStore pageStore = store = db.isPersistent() ? db.getPageStore() : null;
                if (store != null) {
                    store.statisticsStart();
                }
                if (this.command.isQuery()) {
                    this.command.query(maxrows);
                } else {
                    this.command.update();
                }
                plan = this.command.getPlanSQL();
                AbstractMap abstractMap = statistics = store == null ? null : store.statisticsEnd();
                if (statistics != null) {
                    int total = 0;
                    for (Map.Entry e : statistics.entrySet()) {
                        total += ((Integer)e.getValue()).intValue();
                    }
                    if (total > 0) {
                        statistics = new TreeMap<String, Integer>(statistics);
                        StringBuilder buff = new StringBuilder();
                        buff.append("total: ").append(total).append('\n');
                        for (Map.Entry e : statistics.entrySet()) {
                            int value = (Integer)e.getValue();
                            int percent = (int)(100L * (long)value / (long)total);
                            buff.append((String)e.getKey()).append(": ").append(value).append(" (").append(percent).append("%)\n");
                        }
                        plan = plan + "\n/*\n" + buff.toString() + "*/";
                    }
                }
            } else {
                plan = this.command.getPlanSQL();
            }
            this.add(plan);
        }
        this.result.done();
        return this.result;
    }

    private void add(String text) {
        Value[] row = new Value[]{ValueString.get(text)};
        this.result.addRow(row);
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return this.command.isReadOnly();
    }

    @Override
    public int getType() {
        return 60;
    }
}

