/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import org.jboss.resteasy.core.ValueInjector;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InternalServerErrorException;
import org.jboss.resteasy.spi.MethodInjector;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.validation.ValidatorAdapter;
import org.jboss.resteasy.util.Types;

public class MethodInjectorImpl
implements MethodInjector {
    protected Method method;
    protected Method invokedMethod;
    protected Class rootClass;
    protected ValueInjector[] params;
    protected ResteasyProviderFactory factory;
    protected ValidatorAdapter validatorAdapter;

    public MethodInjectorImpl(Class root, Method method, ResteasyProviderFactory factory) {
        this.method = method;
        this.rootClass = root;
        this.invokedMethod = MethodInjectorImpl.findInterfaceBasedMethod(root, method);
        this.factory = factory;
        this.params = new ValueInjector[method.getParameterTypes().length];
        Method actualMethod = null;
        actualMethod = Proxy.isProxyClass(root) ? method : Types.getImplementingMethod(root, method);
        Type[] genericParameterTypes = actualMethod.getGenericParameterTypes();
        for (int i = 0; i < actualMethod.getParameterTypes().length; ++i) {
            Class<?> type;
            Type genericType;
            if (actualMethod.getGenericParameterTypes()[i] instanceof TypeVariable) {
                genericType = Types.getActualValueOfTypeVariable(root, (TypeVariable)genericParameterTypes[i]);
                type = Types.getRawType(genericType);
            } else {
                type = actualMethod.getParameterTypes()[i];
                genericType = genericParameterTypes[i];
            }
            Annotation[] annotations = method.getParameterAnnotations()[i];
            this.params[i] = factory.getInjectorFactory().createParameterExtractor(root, method, type, genericType, annotations);
        }
        ContextResolver<ValidatorAdapter> contextResolver = factory.getContextResolver(ValidatorAdapter.class, MediaType.WILDCARD_TYPE);
        if (contextResolver == null) {
            return;
        }
        this.validatorAdapter = (ValidatorAdapter)contextResolver.getContext(null);
    }

    public static Method findInterfaceBasedMethod(Class root, Method method) {
        if (method.getDeclaringClass().isInterface() || root.isInterface()) {
            return method;
        }
        for (Class<?> intf : root.getInterfaces()) {
            try {
                return intf.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException ignored) {
            }
        }
        if (root.getSuperclass() == null || root.getSuperclass().equals(Object.class)) {
            return method;
        }
        return MethodInjectorImpl.findInterfaceBasedMethod(root.getSuperclass(), method);
    }

    @Override
    public ValueInjector[] getParams() {
        return this.params;
    }

    @Override
    public Object[] injectArguments(HttpRequest input, HttpResponse response) {
        try {
            Object[] args = null;
            if (this.params != null && this.params.length > 0) {
                args = new Object[this.params.length];
                int i = 0;
                for (ValueInjector extractor : this.params) {
                    args[i++] = extractor.inject(input, response);
                }
            }
            return args;
        }
        catch (WebApplicationException we) {
            throw we;
        }
        catch (Failure f) {
            throw f;
        }
        catch (Exception e) {
            BadRequestException badRequest = new BadRequestException(Messages.MESSAGES.failedProcessingArguments(this.method.toString()), e);
            badRequest.setLoggable(true);
            throw badRequest;
        }
    }

    @Override
    public Object invoke(HttpRequest request, HttpResponse httpResponse, Object resource) throws Failure, ApplicationException, WebApplicationException {
        Object[] args = this.injectArguments(request, httpResponse);
        if (this.validatorAdapter != null) {
            this.validatorAdapter.applyValidation(resource, this.invokedMethod, args);
        }
        try {
            return this.invokedMethod.invoke(resource, args);
        }
        catch (IllegalAccessException e) {
            throw new InternalServerErrorException(Messages.MESSAGES.notAllowedToReflectOnMethod(this.method.toString()), e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof WebApplicationException) {
                WebApplicationException wae = (WebApplicationException)cause;
                throw wae;
            }
            throw new ApplicationException(cause);
        }
        catch (IllegalArgumentException e) {
            String msg = Messages.MESSAGES.badArguments(this.method.toString()) + "  (";
            if (args != null) {
                boolean first = false;
                for (Object arg : args) {
                    if (!first) {
                        first = true;
                    } else {
                        msg = msg + ",";
                    }
                    msg = arg == null ? msg + " null" : msg + " " + arg.getClass().getName() + " " + arg;
                }
            }
            msg = msg + " )";
            throw new InternalServerErrorException(msg, e);
        }
    }
}

