/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.mapping;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.v3.client.config.UDDIClerk;
import org.apache.juddi.v3.client.mapping.BPEL2UDDI;
import org.apache.juddi.v3.client.mapping.RegistrationInfo;
import org.apache.juddi.v3.client.mapping.RegistrationType;
import org.apache.juddi.v3.client.mapping.ServiceLocator;
import org.apache.juddi.v3.client.mapping.URLLocalizer;
import org.apache.juddi.v3.client.mapping.WSDL2UDDI;
import org.uddi.api_v3.BindingTemplate;

public class AsyncRegistration
implements Runnable {
    private static Log log = LogFactory.getLog(AsyncRegistration.class);
    private UDDIClerk clerk;
    private URLLocalizer urlLocalizer;
    private Properties properties;
    private static Map<String, ServiceLocator> serviceLocators = new HashMap<String, ServiceLocator>();
    private RegistrationInfo registrationInfo;

    public AsyncRegistration(UDDIClerk clerk, URLLocalizer urlLocalizer, Properties properties, RegistrationInfo registrationInfo) {
        this.clerk = clerk;
        this.urlLocalizer = urlLocalizer;
        this.properties = properties;
        this.registrationInfo = registrationInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ServiceLocator serviceLocator = null;
            Map<String, ServiceLocator> map = serviceLocators;
            synchronized (map) {
                if (!serviceLocators.containsKey(this.clerk.getName())) {
                    serviceLocator = new ServiceLocator(this.clerk, this.urlLocalizer, this.properties);
                    serviceLocators.put(this.clerk.getName(), serviceLocator);
                } else {
                    serviceLocator = serviceLocators.get(this.clerk.getName());
                }
            }
            if (RegistrationType.WSDL.equals((Object)this.registrationInfo.getRegistrationType())) {
                WSDL2UDDI wsdl2UDDI = new WSDL2UDDI(this.clerk, this.urlLocalizer, this.properties);
                BindingTemplate binding = wsdl2UDDI.register(this.registrationInfo.getServiceQName(), this.registrationInfo.getPortName(), this.registrationInfo.getServiceUrl(), this.registrationInfo.getWsdlDefinition());
                serviceLocator.addService(binding.getServiceKey());
            } else if (RegistrationType.BPEL.equals((Object)this.registrationInfo.getRegistrationType())) {
                BPEL2UDDI bpel2UDDI = new BPEL2UDDI(this.clerk, this.urlLocalizer, this.properties);
                BindingTemplate binding = bpel2UDDI.register(this.registrationInfo.getServiceQName(), this.registrationInfo.getPortName(), this.registrationInfo.getServiceUrl(), this.registrationInfo.getWsdlDefinition());
                serviceLocator.addService(binding.getServiceKey());
            } else {
                log.error((Object)("Registration error, due to unsupported registration type of " + (Object)((Object)this.registrationInfo.getRegistrationType())));
            }
        }
        catch (Exception e) {
            log.error((Object)("Not able to register " + (Object)((Object)this.registrationInfo.getRegistrationType()) + " endpoint " + this.registrationInfo.getServiceQName() + " to UDDI Registry. " + e.getMessage()), (Throwable)e);
        }
    }

    public ServiceLocator getServiceLocator(String clerkName) {
        return serviceLocators.get(clerkName);
    }
}

