/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function.distance;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.spatial.DistanceUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.MultiValueSource;
import org.apache.solr.search.function.ValueSource;

public class HaversineFunction
extends ValueSource {
    private MultiValueSource p1;
    private MultiValueSource p2;
    private boolean convertToRadians = false;
    private double radius;

    public HaversineFunction(MultiValueSource p1, MultiValueSource p2, double radius) {
        this(p1, p2, radius, false);
    }

    public HaversineFunction(MultiValueSource p1, MultiValueSource p2, double radius, boolean convertToRads) {
        this.p1 = p1;
        this.p2 = p2;
        if (p1.dimension() != 2 || p2.dimension() != 2) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Illegal dimension for value sources");
        }
        this.radius = radius;
        this.convertToRadians = convertToRads;
    }

    protected String name() {
        return "hsin";
    }

    protected double distance(int doc, DocValues p1DV, DocValues p2DV) {
        double x2;
        double y2;
        double x1;
        double y1;
        double[] p1D = new double[2];
        double[] p2D = new double[2];
        p1DV.doubleVal(doc, p1D);
        p2DV.doubleVal(doc, p2D);
        if (this.convertToRadians) {
            y1 = p1D[0] * (Math.PI / 180);
            x1 = p1D[1] * (Math.PI / 180);
            y2 = p2D[0] * (Math.PI / 180);
            x2 = p2D[1] * (Math.PI / 180);
        } else {
            y1 = p1D[0];
            x1 = p1D[1];
            y2 = p2D[0];
            x2 = p2D[1];
        }
        return DistanceUtils.haversine((double)y1, (double)x1, (double)y2, (double)x2, (double)this.radius);
    }

    @Override
    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        final DocValues vals1 = this.p1.getValues(context, reader);
        final DocValues vals2 = this.p2.getValues(context, reader);
        return new DocValues(){

            @Override
            public float floatVal(int doc) {
                return (float)this.doubleVal(doc);
            }

            @Override
            public int intVal(int doc) {
                return (int)this.doubleVal(doc);
            }

            @Override
            public long longVal(int doc) {
                return (long)this.doubleVal(doc);
            }

            @Override
            public double doubleVal(int doc) {
                return HaversineFunction.this.distance(doc, vals1, vals2);
            }

            @Override
            public String strVal(int doc) {
                return Double.toString(this.doubleVal(doc));
            }

            @Override
            public String toString(int doc) {
                StringBuilder sb = new StringBuilder();
                sb.append(HaversineFunction.this.name()).append('(');
                sb.append(vals1.toString(doc)).append(',').append(vals2.toString(doc));
                sb.append(')');
                return sb.toString();
            }
        };
    }

    @Override
    public void createWeight(Map context, Searcher searcher) throws IOException {
        this.p1.createWeight(context, searcher);
        this.p2.createWeight(context, searcher);
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        HaversineFunction other = (HaversineFunction)o;
        return this.name().equals(other.name()) && this.p1.equals(other.p1) && this.p2.equals(other.p2) && this.radius == other.radius;
    }

    @Override
    public int hashCode() {
        int result = this.p1.hashCode();
        result = 31 * result + this.p2.hashCode();
        result = 31 * result + this.name().hashCode();
        long temp = Double.doubleToRawLongBits(this.radius);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public String description() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name()).append('(');
        sb.append(this.p1).append(',').append(this.p2);
        sb.append(')');
        return sb.toString();
    }
}

