/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Searcher;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.ValueSource;

public class LinearFloatFunction
extends ValueSource {
    protected final ValueSource source;
    protected final float slope;
    protected final float intercept;

    public LinearFloatFunction(ValueSource source, float slope, float intercept) {
        this.source = source;
        this.slope = slope;
        this.intercept = intercept;
    }

    @Override
    public String description() {
        return this.slope + "*float(" + this.source.description() + ")+" + this.intercept;
    }

    @Override
    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        final DocValues vals = this.source.getValues(context, reader);
        return new DocValues(){

            @Override
            public float floatVal(int doc) {
                return vals.floatVal(doc) * LinearFloatFunction.this.slope + LinearFloatFunction.this.intercept;
            }

            @Override
            public int intVal(int doc) {
                return (int)this.floatVal(doc);
            }

            @Override
            public long longVal(int doc) {
                return (long)this.floatVal(doc);
            }

            @Override
            public double doubleVal(int doc) {
                return this.floatVal(doc);
            }

            @Override
            public String strVal(int doc) {
                return Float.toString(this.floatVal(doc));
            }

            @Override
            public String toString(int doc) {
                return LinearFloatFunction.this.slope + "*float(" + vals.toString(doc) + ")+" + LinearFloatFunction.this.intercept;
            }
        };
    }

    @Override
    public void createWeight(Map context, Searcher searcher) throws IOException {
        this.source.createWeight(context, searcher);
    }

    @Override
    public int hashCode() {
        int h = Float.floatToIntBits(this.slope);
        h = h >>> 2 | h << 30;
        h += Float.floatToIntBits(this.intercept);
        h ^= h << 14 | h >>> 19;
        return h + this.source.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (LinearFloatFunction.class != o.getClass()) {
            return false;
        }
        LinearFloatFunction other = (LinearFloatFunction)o;
        return this.slope == other.slope && this.intercept == other.intercept && this.source.equals(other.source);
    }
}

