/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.highlight;

import java.text.BreakIterator;
import java.util.Locale;
import org.apache.lucene.search.vectorhighlight.BoundaryScanner;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.highlight.SolrBoundaryScanner;

public class BreakIteratorBoundaryScanner
extends SolrBoundaryScanner {
    @Override
    protected BoundaryScanner get(String fieldName, SolrParams params) {
        String language = params.getFieldParam(fieldName, "hl.bs.language");
        String country = params.getFieldParam(fieldName, "hl.bs.country");
        if (country != null && language == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "hl.bs.language parameter cannot be null when you specify hl.bs.country");
        }
        Locale locale = null;
        if (language != null) {
            locale = country == null ? new Locale(language) : new Locale(language, country);
        }
        String type = params.getFieldParam(fieldName, "hl.bs.type", "WORD").toLowerCase();
        BreakIterator bi = null;
        if (type.equals("character")) {
            bi = locale == null ? BreakIterator.getCharacterInstance() : BreakIterator.getCharacterInstance(locale);
        } else if (type.equals("word")) {
            bi = locale == null ? BreakIterator.getWordInstance() : BreakIterator.getWordInstance(locale);
        } else if (type.equals("line")) {
            bi = locale == null ? BreakIterator.getLineInstance() : BreakIterator.getLineInstance(locale);
        } else if (type.equals("sentence")) {
            bi = locale == null ? BreakIterator.getSentenceInstance() : BreakIterator.getSentenceInstance(locale);
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, type + " is invalid for parameter " + "hl.bs.type");
        }
        return new org.apache.lucene.search.vectorhighlight.BreakIteratorBoundaryScanner(bi);
    }

    @Override
    public String getDescription() {
        return "BreakIteratorBoundaryScanner";
    }

    @Override
    public String getSource() {
        return "$URL$";
    }

    @Override
    public String getSourceId() {
        return "$Id$";
    }

    @Override
    public String getVersion() {
        return "$Revision$";
    }
}

