/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.Map;
import org.apache.solr.analysis.CharFilterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCharFilterFactory
implements CharFilterFactory {
    public static final Logger log = LoggerFactory.getLogger(BaseCharFilterFactory.class);
    protected Map<String, String> args;

    @Override
    public Map<String, String> getArgs() {
        return this.args;
    }

    @Override
    public void init(Map<String, String> args) {
        this.args = args;
    }

    protected int getInt(String name) {
        return this.getInt(name, -1, false);
    }

    protected int getInt(String name, int defaultVal) {
        return this.getInt(name, defaultVal, true);
    }

    protected int getInt(String name, int defaultVal, boolean useDefault) {
        String s = this.args.get(name);
        if (s == null) {
            if (useDefault) {
                return defaultVal;
            }
            throw new RuntimeException("Configuration Error: missing parameter '" + name + "'");
        }
        return Integer.parseInt(s);
    }
}

