/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import com.ibm.icu.text.Transliterator;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.icu.ICUTransformFilter;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.analysis.MultiTermAwareComponent;
import org.apache.solr.common.SolrException;

public class ICUTransformFilterFactory
extends BaseTokenFilterFactory
implements MultiTermAwareComponent {
    private Transliterator transliterator;

    public void init(Map<String, String> args) {
        int dir;
        super.init(args);
        String id = args.get("id");
        if (id == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "id is required.");
        }
        String direction = args.get("direction");
        if (direction == null || direction.equalsIgnoreCase("forward")) {
            dir = 0;
        } else if (direction.equalsIgnoreCase("reverse")) {
            dir = 1;
        } else {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "invalid direction: " + direction);
        }
        this.transliterator = Transliterator.getInstance((String)id, (int)dir);
    }

    public TokenStream create(TokenStream input) {
        return new ICUTransformFilter(input, this.transliterator);
    }

    public Object getMultiTermComponent() {
        return this;
    }
}

