/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.canonical;

import nu.xom.MalformedURIException;

class URIJoiner {
    URIJoiner() {
    }

    static String absolutize(String baseURI, String spec) {
        if ("".equals(baseURI) || baseURI == null) {
            return spec;
        }
        ParsedURI base = new ParsedURI(baseURI);
        if (base.path.endsWith("/..")) {
            base.path = base.path + '/';
        }
        ParsedURI R = new ParsedURI(spec);
        ParsedURI T = new ParsedURI();
        if (R.scheme != null) {
            T.scheme = R.scheme;
            T.authority = R.authority;
            T.query = R.query;
            T.path = URIJoiner.removeDotSegments(R.path);
        } else {
            if (R.authority != null) {
                T.authority = R.authority;
                T.query = R.query;
                T.path = URIJoiner.removeDotSegments(R.path);
            } else {
                if ("".equals(R.path)) {
                    T.path = base.path;
                    T.query = R.query != null ? R.query : base.query;
                } else {
                    if (R.path.startsWith("/")) {
                        T.path = URIJoiner.removeDotSegments(R.path);
                    } else {
                        T.path = URIJoiner.merge(base, R.path);
                        T.path = URIJoiner.removeDotSegments(T.path);
                    }
                    T.query = R.query;
                }
                T.authority = base.authority;
            }
            T.scheme = base.scheme;
        }
        T.fragment = R.fragment;
        return T.toString();
    }

    static String merge(ParsedURI base, String relativePath) {
        if (base.authority != null && "".equals(base.path) && !"".equals(base.authority)) {
            return "/" + relativePath;
        }
        int lastSlash = base.path.lastIndexOf(47);
        if (lastSlash == -1) {
            return relativePath;
        }
        String topPath = base.path.substring(0, lastSlash + 1);
        return topPath + relativePath;
    }

    static String removeDotSegments(String path) {
        StringBuffer output = new StringBuffer();
        while (path.length() > 0) {
            if (path.startsWith("/./")) {
                path = '/' + path.substring(3);
                continue;
            }
            if (path.equals("/.")) {
                path = "/";
                continue;
            }
            if (path.equals("/..")) {
                path = "/";
                int lastSlash = output.toString().lastIndexOf(47);
                if (lastSlash == -1) continue;
                output.setLength(lastSlash);
                continue;
            }
            if (path.equals(".")) {
                path = "";
                continue;
            }
            if (path.startsWith("./")) {
                path = path.substring(2);
                continue;
            }
            int nextSlash = path.indexOf(47);
            if (nextSlash == 0) {
                nextSlash = path.indexOf(47, 1);
            }
            if (nextSlash == -1) {
                output.append(path);
                path = "";
                continue;
            }
            output.append(path.substring(0, nextSlash));
            path = path.substring(nextSlash);
        }
        return output.toString();
    }

    static class ParsedURI {
        String scheme;
        String schemeSpecificPart;
        String query;
        String fragment;
        String authority;
        String path = "";

        ParsedURI(String spec) {
            int colon = spec.indexOf(58);
            int sharp = spec.lastIndexOf(35);
            int question = sharp == -1 ? spec.indexOf(63) : spec.substring(0, sharp).indexOf(63);
            if (colon != -1) {
                this.scheme = spec.substring(0, colon);
            }
            if (question == -1 && sharp == -1) {
                this.schemeSpecificPart = spec.substring(colon + 1);
            } else if (question != -1) {
                if (question < colon) {
                    MalformedURIException ex = new MalformedURIException("Unparseable URI");
                    ex.setData(spec);
                    throw ex;
                }
                this.schemeSpecificPart = spec.substring(colon + 1, question);
            } else {
                if (sharp < colon) {
                    MalformedURIException ex = new MalformedURIException("Unparseable URI");
                    ex.setData(spec);
                    throw ex;
                }
                this.schemeSpecificPart = spec.substring(colon + 1, sharp);
            }
            if (sharp != -1) {
                this.fragment = spec.substring(sharp + 1);
            }
            if (question != -1) {
                this.query = sharp == -1 ? spec.substring(question + 1) : spec.substring(question + 1, sharp);
            }
            if (this.schemeSpecificPart.startsWith("//")) {
                int authorityBegin = 2;
                int authorityEnd = this.schemeSpecificPart.indexOf(47, authorityBegin);
                if (authorityEnd == -1) {
                    this.authority = this.schemeSpecificPart.substring(2);
                    this.path = "";
                } else {
                    this.authority = this.schemeSpecificPart.substring(authorityBegin, authorityEnd);
                    this.path = this.schemeSpecificPart.substring(authorityEnd);
                }
            } else {
                this.path = this.schemeSpecificPart;
            }
        }

        ParsedURI() {
        }

        public String toString() {
            StringBuffer result = new StringBuffer(30);
            if (this.scheme != null) {
                result.append(this.scheme);
                result.append(':');
            }
            if (this.schemeSpecificPart != null) {
                result.append(this.schemeSpecificPart);
            } else {
                if (this.scheme != null) {
                    result.append("//");
                }
                if (this.authority != null) {
                    result.append(this.authority);
                }
                result.append(this.path);
            }
            if (this.query != null) {
                result.append('?');
                result.append(this.query);
            }
            if (this.fragment != null) {
                result.append('#');
                result.append(this.fragment);
            }
            return result.toString();
        }
    }
}

