/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Driver;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.spi.ManagedConnectionFactory;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.logging.ConnectorMessages;
import org.jboss.as.connector.services.driver.InstalledDriver;
import org.jboss.as.connector.services.driver.registry.DriverRegistry;
import org.jboss.as.connector.util.Injection;
import org.jboss.jca.adapters.jdbc.BaseWrapperManagedConnectionFactory;
import org.jboss.jca.adapters.jdbc.local.LocalManagedConnectionFactory;
import org.jboss.jca.adapters.jdbc.spi.ClassLoaderPlugin;
import org.jboss.jca.adapters.jdbc.xa.XAManagedConnectionFactory;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.ds.CommonDataSource;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.api.metadata.ra.ConfigProperty;
import org.jboss.jca.common.api.metadata.ra.XsdString;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.ds.DatasourcesImpl;
import org.jboss.jca.common.metadata.ds.DriverImpl;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.mdr.NotFoundException;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.deployers.DeployersLogger;
import org.jboss.jca.deployers.common.AbstractDsDeployer;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.DeployException;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.SubjectFactory;

public abstract class AbstractDataSourceService
implements Service<javax.sql.DataSource> {
    public static final ServiceName SERVICE_NAME_BASE = ServiceName.JBOSS.append(new String[]{"data-source"});
    private static final DeployersLogger DEPLOYERS_LOGGER = (DeployersLogger)Logger.getMessageLogger(DeployersLogger.class, (String)AS7DataSourceDeployer.class.getName());
    protected final InjectedValue<TransactionIntegration> transactionIntegrationValue = new InjectedValue();
    private final InjectedValue<Driver> driverValue = new InjectedValue();
    private final InjectedValue<ManagementRepository> managementRepositoryValue = new InjectedValue();
    private final InjectedValue<SubjectFactory> subjectFactory = new InjectedValue();
    private final InjectedValue<DriverRegistry> driverRegistry = new InjectedValue();
    private final InjectedValue<CachedConnectionManager> ccmValue = new InjectedValue();
    private final InjectedValue<ExecutorService> executor = new InjectedValue();
    private final String jndiName;
    protected CommonDeployment deploymentMD;
    private javax.sql.DataSource sqlDataSource;
    private final ClassLoader classLoader;
    private static final SetContextLoaderAction CLEAR_ACTION = new SetContextLoaderAction(null);

    protected AbstractDataSourceService(String jndiName, ClassLoader classLoader) {
        this.jndiName = jndiName;
        this.classLoader = classLoader;
    }

    public synchronized void start(StartContext startContext) throws StartException {
        try {
            ServiceContainer container = startContext.getController().getServiceContainer();
            this.deploymentMD = this.getDeployer().deploy(container);
            if (this.deploymentMD.getCfs().length != 1) {
                throw ConnectorMessages.MESSAGES.cannotStartDs();
            }
            this.sqlDataSource = (javax.sql.DataSource)this.deploymentMD.getCfs()[0];
            ConnectorLogger.DS_DEPLOYER_LOGGER.debugf("Adding datasource: %s", this.deploymentMD.getCfJndiNames()[0]);
        }
        catch (Throwable t) {
            throw ConnectorMessages.MESSAGES.deploymentError(t, this.jndiName);
        }
    }

    protected abstract AS7DataSourceDeployer getDeployer() throws ValidateException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(final StopContext stopContext) {
        Runnable r;
        ExecutorService executorService = (ExecutorService)this.executor.getValue();
        Runnable runnable = r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    try {
                        AbstractDataSourceService.this.stopService();
                    }
                    finally {
                        stopContext.complete();
                    }
                }
            }
        };
        synchronized (runnable) {
            executorService.execute(r);
            stopContext.asynchronous();
        }
    }

    protected synchronized void stopService() {
        if (this.deploymentMD != null) {
            if (this.deploymentMD.getDataSources() != null && this.managementRepositoryValue.getValue() != null) {
                for (org.jboss.jca.core.api.management.DataSource dataSource : this.deploymentMD.getDataSources()) {
                    ((ManagementRepository)this.managementRepositoryValue.getValue()).getDataSources().remove(dataSource);
                }
            }
            if (this.deploymentMD.getConnectionManagers() != null) {
                for (org.jboss.jca.core.api.management.DataSource dataSource : this.deploymentMD.getConnectionManagers()) {
                    dataSource.shutdown();
                }
            }
        }
        this.sqlDataSource = null;
    }

    public CommonDeployment getDeploymentMD() {
        return this.deploymentMD;
    }

    public synchronized javax.sql.DataSource getValue() throws IllegalStateException, IllegalArgumentException {
        return this.sqlDataSource;
    }

    public Injector<TransactionIntegration> getTransactionIntegrationInjector() {
        return this.transactionIntegrationValue;
    }

    public Injector<Driver> getDriverInjector() {
        return this.driverValue;
    }

    public Injector<ManagementRepository> getManagementRepositoryInjector() {
        return this.managementRepositoryValue;
    }

    public Injector<DriverRegistry> getDriverRegistryInjector() {
        return this.driverRegistry;
    }

    public Injector<SubjectFactory> getSubjectFactoryInjector() {
        return this.subjectFactory;
    }

    public Injector<CachedConnectionManager> getCcmInjector() {
        return this.ccmValue;
    }

    public Injector<ExecutorService> getExecutorServiceInjector() {
        return this.executor;
    }

    protected String buildConfigPropsString(Map<String, String> configProps) {
        StringBuffer valueBuf = new StringBuffer();
        for (Map.Entry<String, String> connProperty : configProps.entrySet()) {
            valueBuf.append(connProperty.getKey());
            valueBuf.append("=");
            valueBuf.append(connProperty.getValue());
            valueBuf.append(";");
        }
        return valueBuf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransactionIntegration getTransactionIntegration() {
        AccessController.doPrivileged(new SetContextLoaderAction(TransactionIntegration.class.getClassLoader()));
        try {
            TransactionIntegration transactionIntegration = (TransactionIntegration)this.transactionIntegrationValue.getValue();
            return transactionIntegration;
        }
        finally {
            AccessController.doPrivileged(CLEAR_ACTION);
        }
    }

    private ClassLoader driverClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        return ((Driver)this.driverValue.getValue()).getClass().getClassLoader();
    }

    private class MyXaMCF
    extends XAManagedConnectionFactory {
        private static final long serialVersionUID = 4876371551002746953L;

        private MyXaMCF() {
        }

        public void setXaProps(Map<String, String> inputProperties) {
            this.xaProps.putAll(inputProperties);
        }
    }

    protected class AS7DataSourceDeployer
    extends AbstractDsDeployer {
        private final DataSource dataSourceConfig;
        private final XaDataSource xaDataSourceConfig;
        private ServiceContainer serviceContainer;

        public AS7DataSourceDeployer(XaDataSource xaDataSourceConfig) {
            this.xaDataSourceConfig = xaDataSourceConfig;
            this.dataSourceConfig = null;
        }

        public AS7DataSourceDeployer(DataSource dataSourceConfig) {
            this.dataSourceConfig = dataSourceConfig;
            this.xaDataSourceConfig = null;
        }

        public CommonDeployment deploy(ServiceContainer serviceContainer) throws DeployException {
            try {
                String driverName;
                if (serviceContainer == null) {
                    throw new DeployException(ConnectorMessages.MESSAGES.nullVar("ServiceContainer"));
                }
                this.serviceContainer = serviceContainer;
                HashMap<String, DriverImpl> drivers = new HashMap<String, DriverImpl>(1);
                DatasourcesImpl dataSources = null;
                if (this.dataSourceConfig != null) {
                    driverName = this.dataSourceConfig.getDriver();
                    InstalledDriver installedDriver = ((DriverRegistry)AbstractDataSourceService.this.driverRegistry.getValue()).getInstalledDriver(driverName);
                    if (installedDriver != null) {
                        String moduleName = installedDriver.getModuleName() != null ? installedDriver.getModuleName().getName() : null;
                        DriverImpl driver = new DriverImpl(installedDriver.getDriverName(), Integer.valueOf(installedDriver.getMajorVersion()), Integer.valueOf(installedDriver.getMinorVersion()), moduleName, installedDriver.getDriverClassName(), installedDriver.getDataSourceClassName(), installedDriver.getXaDataSourceClassName());
                        drivers.put(driverName, driver);
                    }
                    dataSources = new DatasourcesImpl(Arrays.asList(this.dataSourceConfig), null, drivers);
                } else if (this.xaDataSourceConfig != null) {
                    driverName = this.xaDataSourceConfig.getDriver();
                    InstalledDriver installedDriver = ((DriverRegistry)AbstractDataSourceService.this.driverRegistry.getValue()).getInstalledDriver(driverName);
                    if (installedDriver != null) {
                        String moduleName = installedDriver.getModuleName() != null ? installedDriver.getModuleName().getName() : null;
                        DriverImpl driver = new DriverImpl(installedDriver.getDriverName(), Integer.valueOf(installedDriver.getMajorVersion()), Integer.valueOf(installedDriver.getMinorVersion()), moduleName, installedDriver.getDriverClassName(), installedDriver.getDataSourceClassName(), installedDriver.getXaDataSourceClassName());
                        drivers.put(driverName, driver);
                    }
                    dataSources = new DatasourcesImpl(null, Arrays.asList(this.xaDataSourceConfig), drivers);
                }
                CommonDeployment c = this.createObjectsAndInjectValue(new URL("file://DataSourceDeployment"), AbstractDataSourceService.this.jndiName, "uniqueJdbcLocalId", "uniqueJdbcXAId", (DataSources)dataSources, AbstractDataSourceService.class.getClassLoader());
                return c;
            }
            catch (MalformedURLException e) {
                throw ConnectorMessages.MESSAGES.cannotDeploy(e);
            }
            catch (ValidateException e) {
                throw ConnectorMessages.MESSAGES.cannotDeployAndValidate(e);
            }
        }

        protected ClassLoader getDeploymentClassLoader(String uniqueId) {
            return AbstractDataSourceService.this.driverClassLoader();
        }

        protected String[] bindConnectionFactory(String deployment, String jndi, Object cf) throws Throwable {
            if (cf instanceof Referenceable) {
                ((Referenceable)cf).setReference(new Reference(jndi));
            }
            return new String[]{jndi};
        }

        protected Object initAndInject(String className, List<? extends ConfigProperty> configs, ClassLoader cl) throws DeployException {
            try {
                Class<?> clz = Class.forName(className, true, cl);
                Object o = clz.newInstance();
                if (configs != null) {
                    Injection injector = new Injection();
                    for (ConfigProperty configProperty : configs) {
                        if (!configProperty.isValueSet()) continue;
                        if (XsdString.isNull((XsdString)configProperty.getConfigPropertyType())) {
                            injector.inject(o, configProperty.getConfigPropertyName().getValue(), configProperty.getConfigPropertyValue().getValue());
                            continue;
                        }
                        injector.inject(o, configProperty.getConfigPropertyName().getValue(), configProperty.getConfigPropertyValue().getValue(), configProperty.getConfigPropertyType().getValue());
                    }
                }
                return o;
            }
            catch (Throwable t) {
                throw ConnectorMessages.MESSAGES.deploymentFailed(t, className);
            }
        }

        protected SubjectFactory getSubjectFactory(String securityDomain) throws DeployException {
            if (securityDomain == null || securityDomain.trim().equals("")) {
                return null;
            }
            return (SubjectFactory)AbstractDataSourceService.this.subjectFactory.getValue();
        }

        public CachedConnectionManager getCachedConnectionManager() {
            return (CachedConnectionManager)AbstractDataSourceService.this.ccmValue.getOptionalValue();
        }

        public ManagementRepository getManagementRepository() {
            return (ManagementRepository)AbstractDataSourceService.this.managementRepositoryValue.getValue();
        }

        protected void initAndInjectClassLoaderPlugin(ManagedConnectionFactory mcf, CommonDataSource dsMetadata) throws DeployException {
            ((BaseWrapperManagedConnectionFactory)mcf).setClassLoaderPlugin(new ClassLoaderPlugin(){

                public ClassLoader getClassLoader() {
                    return AbstractDataSourceService.this.driverClassLoader();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TransactionIntegration getTransactionIntegration() {
            AccessController.doPrivileged(new SetContextLoaderAction(TransactionIntegration.class.getClassLoader()));
            try {
                TransactionIntegration transactionIntegration = (TransactionIntegration)AbstractDataSourceService.this.transactionIntegrationValue.getValue();
                return transactionIntegration;
            }
            finally {
                AccessController.doPrivileged(CLEAR_ACTION);
            }
        }

        protected ManagedConnectionFactory createMcf(XaDataSource arg0, String arg1, ClassLoader arg2) throws NotFoundException, DeployException {
            MyXaMCF xaManagedConnectionFactory = new MyXaMCF();
            if (this.xaDataSourceConfig.getUrlDelimiter() != null) {
                xaManagedConnectionFactory.setURLDelimiter(this.xaDataSourceConfig.getUrlDelimiter());
            }
            if (this.xaDataSourceConfig.getXaDataSourceClass() != null) {
                xaManagedConnectionFactory.setXADataSourceClass(this.xaDataSourceConfig.getXaDataSourceClass());
            }
            if (this.xaDataSourceConfig.getXaDataSourceProperty() != null) {
                xaManagedConnectionFactory.setXaProps(this.xaDataSourceConfig.getXaDataSourceProperty());
            }
            if (this.xaDataSourceConfig.getUrlSelectorStrategyClassName() != null) {
                xaManagedConnectionFactory.setUrlSelectorStrategyClassName(this.xaDataSourceConfig.getUrlSelectorStrategyClassName());
            }
            if (this.xaDataSourceConfig.getXaPool() != null && this.xaDataSourceConfig.getXaPool().isSameRmOverride() != null) {
                xaManagedConnectionFactory.setIsSameRMOverrideValue(this.xaDataSourceConfig.getXaPool().isSameRmOverride());
            }
            if (this.xaDataSourceConfig.getNewConnectionSql() != null) {
                xaManagedConnectionFactory.setNewConnectionSQL(this.xaDataSourceConfig.getNewConnectionSql());
            }
            if (this.xaDataSourceConfig.getUrlSelectorStrategyClassName() != null) {
                xaManagedConnectionFactory.setUrlSelectorStrategyClassName(this.xaDataSourceConfig.getUrlSelectorStrategyClassName());
            }
            this.setMcfProperties((BaseWrapperManagedConnectionFactory)xaManagedConnectionFactory, (CommonDataSource)this.xaDataSourceConfig, this.xaDataSourceConfig.getStatement());
            xaManagedConnectionFactory.setUserTransactionJndiName("java:jboss/UserTransaction");
            return xaManagedConnectionFactory;
        }

        protected ManagedConnectionFactory createMcf(DataSource arg0, String arg1, ClassLoader arg2) throws NotFoundException, DeployException {
            LocalManagedConnectionFactory managedConnectionFactory = new LocalManagedConnectionFactory();
            managedConnectionFactory.setUserTransactionJndiName("java:jboss/UserTransaction");
            managedConnectionFactory.setDriverClass(this.dataSourceConfig.getDriverClass());
            if (this.dataSourceConfig.getUrlDelimiter() != null) {
                try {
                    managedConnectionFactory.setURLDelimiter(this.dataSourceConfig.getUrlDelimiter());
                }
                catch (Exception e) {
                    throw ConnectorMessages.MESSAGES.failedToGetUrlDelimiter(e);
                }
            }
            if (this.dataSourceConfig.getDataSourceClass() != null) {
                managedConnectionFactory.setDataSourceClass(this.dataSourceConfig.getDataSourceClass());
            }
            if (this.dataSourceConfig.getConnectionProperties() != null) {
                managedConnectionFactory.setConnectionProperties(AbstractDataSourceService.this.buildConfigPropsString(this.dataSourceConfig.getConnectionProperties()));
            }
            if (this.dataSourceConfig.getConnectionUrl() != null) {
                managedConnectionFactory.setConnectionURL(this.dataSourceConfig.getConnectionUrl());
            }
            if (this.dataSourceConfig.getNewConnectionSql() != null) {
                managedConnectionFactory.setNewConnectionSQL(this.dataSourceConfig.getNewConnectionSql());
            }
            if (this.dataSourceConfig.getUrlSelectorStrategyClassName() != null) {
                managedConnectionFactory.setUrlSelectorStrategyClassName(this.dataSourceConfig.getUrlSelectorStrategyClassName());
            }
            this.setMcfProperties((BaseWrapperManagedConnectionFactory)managedConnectionFactory, (CommonDataSource)this.dataSourceConfig, this.dataSourceConfig.getStatement());
            return managedConnectionFactory;
        }

        private void setMcfProperties(BaseWrapperManagedConnectionFactory managedConnectionFactory, CommonDataSource dataSourceConfig, Statement statement) {
            Validation validation;
            TimeOut timeOut;
            DsSecurity security;
            if (dataSourceConfig.getTransactionIsolation() != null) {
                managedConnectionFactory.setTransactionIsolation(dataSourceConfig.getTransactionIsolation().name());
            }
            if ((security = dataSourceConfig.getSecurity()) != null) {
                if (security.getUserName() != null) {
                    managedConnectionFactory.setUserName(security.getUserName());
                }
                if (security.getPassword() != null) {
                    managedConnectionFactory.setPassword(security.getPassword());
                }
            }
            if ((timeOut = dataSourceConfig.getTimeOut()) != null) {
                if (timeOut.getUseTryLock() != null) {
                    managedConnectionFactory.setUseTryLock(Integer.valueOf(timeOut.getUseTryLock().intValue()));
                }
                if (timeOut.getQueryTimeout() != null) {
                    managedConnectionFactory.setQueryTimeout(Integer.valueOf(timeOut.getQueryTimeout().intValue()));
                }
                if (timeOut.isSetTxQueryTimeout().booleanValue()) {
                    managedConnectionFactory.setTransactionQueryTimeout(Boolean.valueOf(true));
                }
            }
            if (statement != null) {
                if (statement.getTrackStatements() != null) {
                    managedConnectionFactory.setTrackStatements(statement.getTrackStatements().name());
                }
                if (statement.isSharePreparedStatements() != null) {
                    managedConnectionFactory.setSharePreparedStatements(statement.isSharePreparedStatements());
                }
                if (statement.getPreparedStatementsCacheSize() != null) {
                    managedConnectionFactory.setPreparedStatementCacheSize(Integer.valueOf(statement.getPreparedStatementsCacheSize().intValue()));
                }
            }
            if ((validation = dataSourceConfig.getValidation()) != null) {
                Extension staleConnectionChecker;
                Extension exceptionSorter;
                Extension validConnectionChecker;
                if (validation.isValidateOnMatch() != null) {
                    managedConnectionFactory.setValidateOnMatch(validation.isValidateOnMatch());
                }
                if (validation.getCheckValidConnectionSql() != null) {
                    managedConnectionFactory.setCheckValidConnectionSQL(validation.getCheckValidConnectionSql());
                }
                if ((validConnectionChecker = validation.getValidConnectionChecker()) != null) {
                    if (validConnectionChecker.getClassName() != null) {
                        managedConnectionFactory.setValidConnectionCheckerClassName(validConnectionChecker.getClassName());
                    }
                    if (validConnectionChecker.getConfigPropertiesMap() != null) {
                        managedConnectionFactory.setValidConnectionCheckerProperties(AbstractDataSourceService.this.buildConfigPropsString(validConnectionChecker.getConfigPropertiesMap()));
                    }
                }
                if ((exceptionSorter = validation.getExceptionSorter()) != null) {
                    if (exceptionSorter.getClassName() != null) {
                        managedConnectionFactory.setExceptionSorterClassName(exceptionSorter.getClassName());
                    }
                    if (exceptionSorter.getConfigPropertiesMap() != null) {
                        managedConnectionFactory.setExceptionSorterProperties(AbstractDataSourceService.this.buildConfigPropsString(exceptionSorter.getConfigPropertiesMap()));
                    }
                }
                if ((staleConnectionChecker = validation.getStaleConnectionChecker()) != null) {
                    if (staleConnectionChecker.getClassName() != null) {
                        managedConnectionFactory.setStaleConnectionCheckerClassName(staleConnectionChecker.getClassName());
                    }
                    if (staleConnectionChecker.getConfigPropertiesMap() != null) {
                        managedConnectionFactory.setStaleConnectionCheckerProperties(AbstractDataSourceService.this.buildConfigPropsString(staleConnectionChecker.getConfigPropertiesMap()));
                    }
                }
            }
        }

        protected String buildJndiName(String rawJndiName, Boolean javaContext) {
            String jndiName = !rawJndiName.startsWith("java:") && javaContext.booleanValue() ? (rawJndiName.startsWith("jboss/") ? "java:" + rawJndiName : "java:/" + rawJndiName) : rawJndiName;
            return jndiName;
        }

        protected DeployersLogger getLogger() {
            return DEPLOYERS_LOGGER;
        }
    }

    private static class SetContextLoaderAction
    implements PrivilegedAction<Void> {
        private final ClassLoader classLoader;

        public SetContextLoaderAction(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public Void run() {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            return null;
        }
    }
}

