/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.parser.sax;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jboss.logging.Logger;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.parser.JBossXBParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class SaxJBossXBParser
implements JBossXBParser,
ContentHandler,
LexicalHandler,
ErrorHandler {
    private static final Logger log = Logger.getLogger((String)"org.jboss.xb.binding.parser.sax.SaxJBossXBParser");
    private static final SAXParserFactory saxFactory = SAXParserFactory.newInstance();
    private final SAXParser parser;
    private final XMLReader reader;
    private JBossXBParser.ContentHandler contentHandler;
    private boolean trace = log.isTraceEnabled();
    private boolean warnOnParserErrors;
    private Locator locator;

    public SaxJBossXBParser() throws JBossXBException {
        try {
            this.parser = saxFactory.newSAXParser();
            this.reader = this.parser.getXMLReader();
        }
        catch (Exception e) {
            throw new JBossXBException("Failed to create a new SAX parser", e);
        }
        this.reader.setContentHandler(this);
        this.reader.setErrorHandler(this);
        this.reader.setEntityResolver(new EntityResolver(){
            private EntityResolver delegate;

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (this.delegate == null) {
                    this.delegate = new JBossEntityResolver();
                }
                return this.delegate.resolveEntity(publicId, systemId);
            }
        });
        try {
            this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        }
        catch (Exception e) {
            log.trace((Object)"LexicalHandler", (Throwable)e);
        }
    }

    @Override
    public void setWarnOnParserErrors(boolean value) {
        this.warnOnParserErrors = value;
    }

    @Override
    public boolean getWarnOnParserErrors() {
        return this.warnOnParserErrors;
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) throws JBossXBException {
        this.reader.setEntityResolver(entityResolver);
    }

    @Override
    public void setProperty(String name, Object value) {
        try {
            this.reader.setProperty(name, value);
        }
        catch (SAXException e) {
            throw new JBossXBRuntimeException("Failed to set property on the XML reader", e);
        }
    }

    @Override
    public void setFeature(String name, boolean value) {
        try {
            this.reader.setFeature(name, value);
            if (this.trace) {
                log.trace((Object)(name + " set to: " + this.reader.getFeature(name)));
            }
        }
        catch (SAXException e) {
            throw new JBossXBRuntimeException("Failed to set feature on the XMLReader", e);
        }
    }

    @Override
    public void parse(String systemId, JBossXBParser.ContentHandler handler) throws JBossXBException {
        this.contentHandler = handler;
        if (this.trace) {
            this.logParserInfo();
        }
        try {
            this.reader.parse(systemId);
        }
        catch (Throwable e) {
            throw new JBossXBException("Failed to parse source: " + this.getLocationAsString(systemId), e);
        }
    }

    @Override
    public void parse(InputStream is, JBossXBParser.ContentHandler handler) throws JBossXBException {
        this.parse(new InputSource(is), handler);
    }

    @Override
    public void parse(Reader reader, JBossXBParser.ContentHandler handler) throws JBossXBException {
        this.parse(new InputSource(reader), handler);
    }

    @Override
    public void parse(InputSource source, JBossXBParser.ContentHandler handler) throws JBossXBException {
        this.contentHandler = handler;
        if (this.trace) {
            this.logParserInfo();
        }
        try {
            this.reader.parse(source);
        }
        catch (Throwable e) {
            String str = this.locator != null ? this.getLocationAsString(null) : (source.getSystemId() != null ? source.getSystemId() : (source.getByteStream() != null ? source.getByteStream().toString() : (source.getCharacterStream() != null ? source.getCharacterStream().toString() : "")));
            throw new JBossXBException("Failed to parse source: " + str, e);
        }
    }

    public String getLocationAsString(String fileName) {
        if (this.locator == null) {
            return fileName;
        }
        JBossStringBuilder buffer = new JBossStringBuilder();
        String id = this.locator.getSystemId();
        if (id == null) {
            id = this.locator.getPublicId();
        }
        if (id == null) {
            id = "xml_stream";
        }
        buffer.append(id).append('@');
        buffer.append(this.locator.getLineNumber());
        buffer.append(',');
        buffer.append(this.locator.getColumnNumber());
        return buffer.toString();
    }

    private void logParserInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("Created parser: ").append(this.parser).append(", isNamespaceAware: ").append(this.parser.isNamespaceAware()).append(", isValidating: ").append(this.parser.isValidating()).append(", isXIncludeAware: ");
        try {
            sb.append(this.parser.isXIncludeAware());
        }
        catch (UnsupportedOperationException e) {
            sb.append("unsupported operation '").append(e.getMessage()).append('\'');
        }
        log.trace((Object)sb.toString());
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.contentHandler instanceof JBossXBParser.DtdAwareContentHandler) {
            JBossXBParser.DtdAwareContentHandler dach = (JBossXBParser.DtdAwareContentHandler)this.contentHandler;
            dach.startDTD(name, publicId, systemId);
        }
    }

    @Override
    public void endDTD() throws SAXException {
        if (this.contentHandler instanceof JBossXBParser.DtdAwareContentHandler) {
            JBossXBParser.DtdAwareContentHandler dach = (JBossXBParser.DtdAwareContentHandler)this.contentHandler;
            dach.endDTD();
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.contentHandler.characters(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    @Override
    public void endPrefixMapping(String prefix) {
        this.contentHandler.endPrefixMapping(prefix);
    }

    @Override
    public void skippedEntity(String name) {
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void processingInstruction(String target, String data) {
        this.contentHandler.processingInstruction(target, data);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        if (this.trace) {
            String name = localName.length() == 0 ? qName : namespaceURI + ':' + localName;
            log.trace((Object)("Enter endElement " + name));
            try {
                this.contentHandler.endElement(namespaceURI, localName, qName);
            }
            finally {
                log.trace((Object)("Exit endElement  " + name));
            }
        } else {
            this.contentHandler.endElement(namespaceURI, localName, qName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        if (this.trace) {
            String name = localName.length() == 0 ? qName : namespaceURI + ':' + localName;
            log.trace((Object)("Enter startElement " + name));
            try {
                this.contentHandler.startElement(namespaceURI, localName, qName, atts);
            }
            finally {
                log.trace((Object)("Exit startElement  " + name));
            }
        } else {
            this.contentHandler.startElement(namespaceURI, localName, qName, atts);
        }
    }

    @Override
    public void warning(SAXParseException exception) {
        log.warn((Object)this.formatMessage(exception));
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        if (!this.warnOnParserErrors) {
            throw new SAXException(this.formatMessage(exception));
        }
        log.warn((Object)this.formatMessage(exception));
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        throw new SAXException(this.formatMessage(exception));
    }

    public String formatMessage(SAXParseException exception) {
        StringBuffer buffer = new StringBuffer(50);
        buffer.append(exception.getMessage()).append(" @ ");
        String location = exception.getPublicId();
        if (location != null) {
            buffer.append(location);
        } else {
            location = exception.getSystemId();
            if (location != null) {
                buffer.append(location);
            } else {
                buffer.append("*unknown*");
            }
        }
        buffer.append('[');
        buffer.append(exception.getLineNumber()).append(',');
        buffer.append(exception.getColumnNumber()).append(']');
        return buffer.toString();
    }

    static {
        saxFactory.setValidating(true);
        saxFactory.setNamespaceAware(true);
        try {
            saxFactory.setXIncludeAware(true);
        }
        catch (UnsupportedOperationException e) {
            log.trace((Object)"setXIncludeAware is not supported by the SAXParserFactory", (Throwable)e);
        }
    }
}

