/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.introspection;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.introspection.ClassInfo;
import org.jboss.xb.util.NoopMap;

public class ClassInfos {
    private static final Map<ClassLoader, Map<String, WeakReference<ClassInfo>>> NO_CACHE = new NoopMap<ClassLoader, Map<String, WeakReference<ClassInfo>>>();
    private static Map<ClassLoader, Map<String, WeakReference<ClassInfo>>> classloaderCache = new WeakHashMap<ClassLoader, Map<String, WeakReference<ClassInfo>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disableCache() {
        Map<ClassLoader, Map<String, WeakReference<ClassInfo>>> map = classloaderCache;
        synchronized (map) {
            classloaderCache = NO_CACHE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableCache() {
        Map<ClassLoader, Map<String, WeakReference<ClassInfo>>> map = classloaderCache;
        synchronized (map) {
            if (!ClassInfos.isCacheEnabled()) {
                classloaderCache = new WeakHashMap<ClassLoader, Map<String, WeakReference<ClassInfo>>>();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCacheEnabled() {
        Map<ClassLoader, Map<String, WeakReference<ClassInfo>>> map = classloaderCache;
        synchronized (map) {
            return classloaderCache != NO_CACHE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushCache() {
        Map<ClassLoader, Map<String, WeakReference<ClassInfo>>> map = classloaderCache;
        synchronized (map) {
            classloaderCache.clear();
        }
    }

    public static void flushCache(String cls) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Map<String, WeakReference<ClassInfo>> classLoaderCache = ClassInfos.getClassLoaderCache(cl);
        classLoaderCache.remove(cls);
    }

    public static void flushCache(Class<?> cls) {
        Map<String, WeakReference<ClassInfo>> classLoaderCache = ClassInfos.getClassLoaderCache(cls.getClassLoader());
        classLoaderCache.remove(cls.getName());
    }

    public static ClassInfo getClassInfo(Class<?> cls) {
        Object result;
        Map<String, WeakReference<ClassInfo>> classLoaderCache = ClassInfos.getClassLoaderCache(cls.getClassLoader());
        WeakReference<ClassInfo> weak = classLoaderCache.get(cls.getName());
        if (weak != null && (result = weak.get()) != null) {
            return (ClassInfo)result;
        }
        ClassInfo clsInfo = new ClassInfo(cls);
        weak = new WeakReference<ClassInfo>(clsInfo);
        classLoaderCache.put(cls.getName(), weak);
        return clsInfo;
    }

    public static ClassInfo getClassInfo(String name, boolean required) {
        Object result;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Map<String, WeakReference<ClassInfo>> classLoaderCache = ClassInfos.getClassLoaderCache(cl);
        WeakReference<ClassInfo> weak = classLoaderCache.get(name);
        if (weak != null && (result = weak.get()) != null) {
            return (ClassInfo)result;
        }
        try {
            ClassInfo clsInfo = new ClassInfo(cl.loadClass(name));
            weak = new WeakReference<ClassInfo>(clsInfo);
            classLoaderCache.put(name, weak);
            return clsInfo;
        }
        catch (ClassNotFoundException e) {
            if (required) {
                throw new JBossXBRuntimeException("Failed to load class " + name);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, WeakReference<ClassInfo>> getClassLoaderCache(ClassLoader cl) {
        Map<ClassLoader, Map<String, WeakReference<ClassInfo>>> map = classloaderCache;
        synchronized (map) {
            Map<String, WeakReference<ClassInfo>> result = classloaderCache.get(cl);
            if (result == null) {
                result = new ConcurrentHashMap<String, WeakReference<ClassInfo>>();
                classloaderCache.put(cl, result);
            }
            return result;
        }
    }
}

