/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy.writercache.cl2o;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.writercache.cl2o.CharBlockArray;
import org.apache.lucene.facet.taxonomy.writercache.cl2o.CompactLabelToOrdinal;

public class CollisionMap {
    private int capacity;
    private float loadFactor;
    private int size;
    private int threshold;
    private CharBlockArray labelRepository;
    private Entry[] entries;

    public CollisionMap(CharBlockArray labelRepository) {
        this(16384, 0.75f, labelRepository);
    }

    public CollisionMap(int initialCapacity, CharBlockArray labelRepository) {
        this(initialCapacity, 0.75f, labelRepository);
    }

    private CollisionMap(int initialCapacity, float loadFactor, CharBlockArray labelRepository) {
        this.labelRepository = labelRepository;
        this.loadFactor = loadFactor;
        this.capacity = CompactLabelToOrdinal.determineCapacity(2, initialCapacity);
        this.entries = new Entry[this.capacity];
        this.threshold = (int)((float)this.capacity * this.loadFactor);
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity;
    }

    private void grow() {
        int newCapacity = this.capacity * 2;
        Entry[] newEntries = new Entry[newCapacity];
        Entry[] src = this.entries;
        for (int j = 0; j < src.length; ++j) {
            Entry next;
            Entry e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next = e.next;
                int hash = e.hash;
                int i = CollisionMap.indexFor(hash, newCapacity);
                e.next = newEntries[i];
                newEntries[i] = e;
            } while ((e = next) != null);
        }
        this.capacity = newCapacity;
        this.entries = newEntries;
        this.threshold = (int)((float)this.capacity * this.loadFactor);
    }

    public int get(CategoryPath label, int hash) {
        int bucketIndex = CollisionMap.indexFor(hash, this.capacity);
        Entry e = this.entries[bucketIndex];
        while (!(e == null || hash == e.hash && label.equalsToSerialized(this.labelRepository, e.offset))) {
            e = e.next;
        }
        if (e == null) {
            return -2;
        }
        return e.cid;
    }

    public int get(CategoryPath label, int prefixLen, int hash) {
        int bucketIndex = CollisionMap.indexFor(hash, this.capacity);
        Entry e = this.entries[bucketIndex];
        while (!(e == null || hash == e.hash && label.equalsToSerialized(prefixLen, this.labelRepository, e.offset))) {
            e = e.next;
        }
        if (e == null) {
            return -2;
        }
        return e.cid;
    }

    public int addLabel(CategoryPath label, int hash, int cid) {
        int bucketIndex = CollisionMap.indexFor(hash, this.capacity);
        Entry e = this.entries[bucketIndex];
        while (e != null) {
            if (e.hash == hash && label.equalsToSerialized(this.labelRepository, e.offset)) {
                return e.cid;
            }
            e = e.next;
        }
        int offset = this.labelRepository.length();
        try {
            label.serializeAppendTo(this.labelRepository);
        }
        catch (IOException e2) {
            // empty catch block
        }
        this.addEntry(offset, cid, hash, bucketIndex);
        return cid;
    }

    public int addLabel(CategoryPath label, int prefixLen, int hash, int cid) {
        int bucketIndex = CollisionMap.indexFor(hash, this.capacity);
        Entry e = this.entries[bucketIndex];
        while (e != null) {
            if (e.hash == hash && label.equalsToSerialized(prefixLen, this.labelRepository, e.offset)) {
                return e.cid;
            }
            e = e.next;
        }
        int offset = this.labelRepository.length();
        try {
            label.serializeAppendTo(prefixLen, this.labelRepository);
        }
        catch (IOException e2) {
            // empty catch block
        }
        this.addEntry(offset, cid, hash, bucketIndex);
        return cid;
    }

    public void addLabelOffset(int hash, int offset, int cid) {
        int bucketIndex = CollisionMap.indexFor(hash, this.capacity);
        this.addEntry(offset, cid, hash, bucketIndex);
    }

    private void addEntry(int offset, int cid, int hash, int bucketIndex) {
        Entry e = this.entries[bucketIndex];
        this.entries[bucketIndex] = new Entry(offset, cid, hash, e);
        if (this.size++ >= this.threshold) {
            this.grow();
        }
    }

    Iterator<Entry> entryIterator() {
        return new EntryIterator(this.entries, this.size);
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    int getMemoryUsage() {
        int memoryUsage = 0;
        if (this.entries != null) {
            for (Entry e : this.entries) {
                if (e == null) continue;
                memoryUsage += 16;
                Entry ee = e.next;
                while (ee != null) {
                    memoryUsage += 16;
                    ee = ee.next;
                }
            }
        }
        return memoryUsage;
    }

    private class EntryIterator
    implements Iterator<Entry> {
        Entry next;
        int index;
        Entry[] ents;

        EntryIterator(Entry[] entries, int size) {
            this.ents = entries;
            Entry[] t = entries;
            int i = t.length;
            Entry n = null;
            if (size != 0) {
                while (i > 0 && (n = t[--i]) == null) {
                }
            }
            this.next = n;
            this.index = i;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Entry next() {
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            Entry n = e.next;
            Entry[] t = this.ents;
            int i = this.index;
            while (n == null && i > 0) {
                n = t[--i];
            }
            this.index = i;
            this.next = n;
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class Entry {
        int offset;
        int cid;
        Entry next;
        int hash;

        Entry(int offset, int cid, int h, Entry e) {
            this.offset = offset;
            this.cid = cid;
            this.next = e;
            this.hash = h;
        }
    }
}

