/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search.params.association;

import java.io.IOException;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.aggregator.Aggregator;
import org.apache.lucene.facet.search.aggregator.association.AssociationFloatSumAggregator;
import org.apache.lucene.facet.search.params.FacetRequest;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.IndexReader;

public class AssociationFloatSumFacetRequest
extends FacetRequest {
    public AssociationFloatSumFacetRequest(CategoryPath path, int num) {
        super(path, num);
    }

    @Override
    public Aggregator createAggregator(boolean useComplements, FacetArrays arrays, IndexReader reader, TaxonomyReader taxonomy) throws IOException {
        assert (!useComplements) : "complements are not supported by this FacetRequest";
        return new AssociationFloatSumAggregator(reader, arrays.getFloatArray());
    }

    @Override
    public double getValueOf(FacetArrays arrays, int ordinal) {
        return arrays.getFloatArray()[ordinal];
    }

    @Override
    public boolean supportsComplements() {
        return false;
    }

    @Override
    public boolean requireDocumentScore() {
        return false;
    }
}

