/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search.aggregator.association;

import java.io.IOException;
import org.apache.lucene.facet.enhancements.association.AssociationsPayloadIterator;
import org.apache.lucene.facet.index.params.CategoryListParams;
import org.apache.lucene.facet.search.aggregator.Aggregator;
import org.apache.lucene.index.IndexReader;

public class AssociationFloatSumAggregator
implements Aggregator {
    protected final String field;
    protected final float[] sumArray;
    protected final AssociationsPayloadIterator associationsPayloadIterator;

    public AssociationFloatSumAggregator(IndexReader reader, float[] sumArray) throws IOException {
        this(CategoryListParams.DEFAULT_TERM.field(), reader, sumArray);
    }

    public AssociationFloatSumAggregator(String field, IndexReader reader, float[] sumArray) throws IOException {
        this.field = field;
        this.associationsPayloadIterator = new AssociationsPayloadIterator(reader, field);
        this.sumArray = sumArray;
    }

    @Override
    public void aggregate(int ordinal) {
        long association = this.associationsPayloadIterator.getAssociation(ordinal);
        if (association != Integer.MIN_VALUE) {
            int n = ordinal;
            this.sumArray[n] = this.sumArray[n] + Float.intBitsToFloat((int)association);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AssociationFloatSumAggregator that = (AssociationFloatSumAggregator)obj;
        return that.field.equals(this.field) && that.sumArray == this.sumArray;
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    @Override
    public void setNextDoc(int docid, float score) throws IOException {
        this.associationsPayloadIterator.setNextDoc(docid);
    }
}

