/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.deployment.SimpleAttachable;
import org.jboss.as.server.deployment.module.FilterSpecification;
import org.jboss.as.server.deployment.module.MountHandle;
import org.jboss.vfs.VirtualFile;

public final class ResourceRoot
extends SimpleAttachable {
    private final String rootName;
    private final VirtualFile root;
    private final MountHandle mountHandle;
    private final List<FilterSpecification> exportFilters = new ArrayList<FilterSpecification>();
    private boolean usePhysicalCodeSource;

    public ResourceRoot(VirtualFile root, MountHandle mountHandle) {
        this(root.getName(), root, mountHandle);
    }

    public ResourceRoot(String rootName, VirtualFile root, MountHandle mountHandle) {
        this.rootName = rootName;
        this.root = root;
        this.mountHandle = mountHandle;
    }

    public String getRootName() {
        return this.rootName;
    }

    public VirtualFile getRoot() {
        return this.root;
    }

    public MountHandle getMountHandle() {
        return this.mountHandle;
    }

    public List<FilterSpecification> getExportFilters() {
        return this.exportFilters;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ResourceRoot [");
        if (this.root != null) {
            builder.append("root=").append(this.root);
        }
        builder.append("]");
        return builder.toString();
    }

    public void setUsePhysicalCodeSource(boolean usePhysicalCodeSource) {
        this.usePhysicalCodeSource = usePhysicalCodeSource;
    }

    public boolean isUsePhysicalCodeSource() {
        return this.usePhysicalCodeSource;
    }

    public void merge(ResourceRoot additionalResourceRoot) {
        if (!additionalResourceRoot.getRoot().equals(this.root)) {
            throw ServerMessages.MESSAGES.cannotMergeResourceRoot(this.root, additionalResourceRoot.getRoot());
        }
        this.usePhysicalCodeSource = additionalResourceRoot.usePhysicalCodeSource;
        if (additionalResourceRoot.getExportFilters().isEmpty()) {
            this.exportFilters.clear();
        } else {
            this.exportFilters.addAll(additionalResourceRoot.getExportFilters());
        }
    }
}

