/*
 * Decompiled with CFR 0.152.
 */
package org.apache.neethi.builders.converters;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class AbstractStaxConverter {
    public QName getQName(XMLStreamReader s) {
        if (s.getEventType() == 7) {
            try {
                s.nextTag();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }
        return new QName(s.getNamespaceURI(), s.getLocalName());
    }

    public Map<QName, String> getAttributes(XMLStreamReader s) {
        HashMap<QName, String> mp = new HashMap<QName, String>();
        for (int x = 0; x < s.getAttributeCount(); ++x) {
            mp.put(new QName(s.getAttributeNamespace(x), s.getAttributeLocalName(x)), s.getAttributeValue(x));
        }
        return mp;
    }

    public Iterator<XMLStreamReader> getChildren(final XMLStreamReader s) {
        final QName base = s.getName();
        try {
            int evt = s.getEventType();
            if (s.hasNext()) {
                evt = s.next();
            }
            while (s.hasNext() && evt != 2 && evt != 1) {
                evt = s.next();
            }
        }
        catch (Exception ex) {
            return null;
        }
        return new Iterator<XMLStreamReader>(){
            boolean first = true;

            @Override
            public boolean hasNext() {
                if (this.first) {
                    this.first = false;
                    return s.getEventType() != 2;
                }
                try {
                    int evt = s.next();
                    while (s.hasNext() && evt != 2 && evt != 1) {
                        evt = s.next();
                    }
                    if (evt == 2 && !s.getName().equals(base)) {
                        evt = s.next();
                        while (s.hasNext() && evt != 2 && evt != 1) {
                            evt = s.next();
                        }
                    }
                    return evt == 1;
                }
                catch (Exception ex) {
                    return false;
                }
            }

            @Override
            public XMLStreamReader next() {
                return s;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

