/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueBytes
extends Value {
    private static final ValueBytes EMPTY = new ValueBytes(Utils.EMPTY_BYTES);
    protected byte[] value;
    protected int hash;

    protected ValueBytes(byte[] v) {
        this.value = v;
    }

    public static ValueBytes get(byte[] b) {
        if (b.length == 0) {
            return EMPTY;
        }
        b = Utils.cloneByteArray(b);
        return ValueBytes.getNoCopy(b);
    }

    public static ValueBytes getNoCopy(byte[] b) {
        if (b.length == 0) {
            return EMPTY;
        }
        ValueBytes obj = new ValueBytes(b);
        if (b.length > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return obj;
        }
        return (ValueBytes)Value.cache(obj);
    }

    @Override
    public int getType() {
        return 12;
    }

    @Override
    public String getSQL() {
        return "X'" + StringUtils.convertBytesToHex(this.getBytesNoCopy()) + "'";
    }

    @Override
    public byte[] getBytesNoCopy() {
        return this.value;
    }

    @Override
    public byte[] getBytes() {
        return Utils.cloneByteArray(this.getBytesNoCopy());
    }

    @Override
    protected int compareSecure(Value v, CompareMode mode) {
        byte[] v2 = ((ValueBytes)v).value;
        return Utils.compareNotNull(this.value, v2);
    }

    @Override
    public String getString() {
        return StringUtils.convertBytesToHex(this.value);
    }

    @Override
    public long getPrecision() {
        return this.value.length;
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Utils.getByteArrayHash(this.value);
        }
        return this.hash;
    }

    @Override
    public Object getObject() {
        return this.getBytes();
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setBytes(parameterIndex, this.value);
    }

    @Override
    public int getDisplaySize() {
        return MathUtils.convertLongToInt((long)this.value.length * 2L);
    }

    @Override
    public int getMemory() {
        return this.value.length + 24;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueBytes && Utils.compareNotNull(this.value, ((ValueBytes)other).value) == 0;
    }

    @Override
    public Value convertPrecision(long precision, boolean force) {
        if ((long)this.value.length <= precision) {
            return this;
        }
        int len = MathUtils.convertLongToInt(precision);
        byte[] buff = new byte[len];
        System.arraycopy(this.value, 0, buff, 0, len);
        return ValueBytes.get(buff);
    }
}

