/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.h2.message.DbException;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.New;
import org.h2.util.StringUtils;
import org.h2.util.Task;
import org.h2.util.Utils;

public class SourceCompiler {
    private static final Class<?> JAVAC_SUN;
    HashMap<String, String> sources = New.hashMap();
    HashMap<String, Class<?>> compiled = New.hashMap();
    private String compileDir = Utils.getProperty("java.io.tmpdir", ".");

    public void setSource(String className, String source) {
        this.sources.put(className, source);
        this.compiled.clear();
    }

    public Class<?> getClass(String packageAndClassName) throws ClassNotFoundException {
        Class<?> compiledClass = this.compiled.get(packageAndClassName);
        if (compiledClass != null) {
            return compiledClass;
        }
        ClassLoader classLoader = new ClassLoader(this.getClass().getClassLoader()){

            @Override
            public Class<?> findClass(String name) throws ClassNotFoundException {
                Class<?> classInstance = SourceCompiler.this.compiled.get(name);
                if (classInstance == null) {
                    String className;
                    String source = SourceCompiler.this.sources.get(name);
                    String packageName = null;
                    int idx = name.lastIndexOf(46);
                    if (idx >= 0) {
                        packageName = name.substring(0, idx);
                        className = name.substring(idx + 1);
                    } else {
                        className = name;
                    }
                    byte[] data = SourceCompiler.this.javacCompile(packageName, className, source);
                    if (data == null) {
                        classInstance = this.findSystemClass(name);
                    } else {
                        classInstance = this.defineClass(name, data, 0, data.length);
                        SourceCompiler.this.compiled.put(name, classInstance);
                    }
                }
                return classInstance;
            }
        };
        return classLoader.loadClass(packageAndClassName);
    }

    public Method getMethod(String className) throws ClassNotFoundException {
        Method[] methods;
        Class<?> clazz = this.getClass(className);
        for (Method m : methods = clazz.getDeclaredMethods()) {
            int modifiers = m.getModifiers();
            if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) continue;
            return m;
        }
        return null;
    }

    byte[] javacCompile(String packageName, String className, String source) {
        File dir = new File(this.compileDir);
        if (packageName != null) {
            dir = new File(dir, packageName.replace('.', '/'));
            FileUtils.createDirectories(dir.getAbsolutePath());
        }
        File javaFile = new File(dir, className + ".java");
        File classFile = new File(dir, className + ".class");
        try {
            OutputStream f = FileUtils.newOutputStream(javaFile.getAbsolutePath(), false);
            PrintWriter out = new PrintWriter(IOUtils.getBufferedWriter(f));
            classFile.delete();
            if (source.startsWith("package ")) {
                out.println(source);
            } else {
                int endImport = source.indexOf("@CODE");
                String importCode = "import java.util.*;\nimport java.math.*;\nimport java.sql.*;\n";
                if (endImport >= 0) {
                    importCode = source.substring(0, endImport);
                    source = source.substring("@CODE".length() + endImport);
                }
                if (packageName != null) {
                    out.println("package " + packageName + ";");
                }
                out.println(importCode);
                out.println("public class " + className + " {\n" + "    public static " + source + "\n" + "}\n");
            }
            out.close();
            if (JAVAC_SUN != null) {
                this.javacSun(javaFile);
            } else {
                this.javacProcess(javaFile);
            }
            byte[] data = new byte[(int)classFile.length()];
            DataInputStream in = new DataInputStream(new FileInputStream(classFile));
            in.readFully(data);
            in.close();
            byte[] byArray = data;
            return byArray;
        }
        catch (Exception e) {
            throw DbException.convert(e);
        }
        finally {
            javaFile.delete();
            classFile.delete();
        }
    }

    private void javacProcess(File javaFile) {
        this.exec("javac", "-sourcepath", this.compileDir, "-d", this.compileDir, "-encoding", "UTF-8", javaFile.getAbsolutePath());
    }

    private int exec(String ... args) {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        try {
            Process p = Runtime.getRuntime().exec(args);
            SourceCompiler.copyInThread(p.getInputStream(), buff);
            SourceCompiler.copyInThread(p.getErrorStream(), buff);
            p.waitFor();
            String err = new String(buff.toByteArray(), "UTF-8");
            this.throwSyntaxError(err);
            return p.exitValue();
        }
        catch (Exception e) {
            throw DbException.convert(e);
        }
    }

    private static void copyInThread(final InputStream in, final OutputStream out) {
        new Task(){

            @Override
            public void call() throws IOException {
                IOUtils.copy(in, out);
            }
        }.execute();
    }

    private void javacSun(File javaFile) {
        PrintStream old = System.err;
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        PrintStream temp = new PrintStream(buff);
        try {
            System.setErr(temp);
            Method compile = JAVAC_SUN.getMethod("compile", String[].class);
            Object javac = JAVAC_SUN.newInstance();
            compile.invoke(javac, new Object[]{new String[]{"-sourcepath", this.compileDir, "-d", this.compileDir, "-encoding", "UTF-8", javaFile.getAbsolutePath()}});
            String err = new String(buff.toByteArray(), "UTF-8");
            this.throwSyntaxError(err);
        }
        catch (Exception e) {
            throw DbException.convert(e);
        }
        finally {
            System.setErr(old);
        }
    }

    private void throwSyntaxError(String err) {
        if (!err.startsWith("Note:") && err.length() > 0) {
            err = StringUtils.replaceAll(err, this.compileDir, "");
            throw DbException.get(42000, err);
        }
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.sun.tools.javac.Main");
        }
        catch (Exception e) {
            clazz = null;
        }
        JAVAC_SUN = clazz;
    }
}

