/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import org.h2.result.SearchRow;
import org.h2.util.StatementBuilder;
import org.h2.value.Value;

public class SimpleRow
implements SearchRow {
    private long key;
    private int version;
    private Value[] data;
    private int memory;

    public SimpleRow(Value[] data) {
        this.data = data;
    }

    @Override
    public int getColumnCount() {
        return this.data.length;
    }

    @Override
    public long getKey() {
        return this.key;
    }

    @Override
    public void setKey(long key) {
        this.key = key;
    }

    @Override
    public void setKeyAndVersion(SearchRow row) {
        this.key = row.getKey();
        this.version = row.getVersion();
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setValue(int i, Value v) {
        this.data[i] = v;
    }

    @Override
    public Value getValue(int i) {
        return this.data[i];
    }

    public String toString() {
        StatementBuilder buff = new StatementBuilder("( /* key:");
        buff.append(this.getKey());
        if (this.version != 0) {
            buff.append(" v:" + this.version);
        }
        buff.append(" */ ");
        for (Value v : this.data) {
            buff.appendExceptFirst(", ");
            buff.append(v == null ? "null" : v.getTraceSQL());
        }
        return buff.append(')').toString();
    }

    @Override
    public int getMemory() {
        if (this.memory == 0) {
            int len = this.data.length;
            this.memory = 24 + len * 8;
            for (int i = 0; i < len; ++i) {
                Value v = this.data[i];
                if (v == null) continue;
                this.memory += v.getMemory();
            }
        }
        return this.memory;
    }
}

