/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import org.h2.engine.Database;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.table.Table;

public class Setting
extends DbObjectBase {
    private int intValue;
    private String stringValue;

    public Setting(Database database, int id, String settingName) {
        this.initDbObjectBase(database, id, settingName, "setting");
    }

    public void setIntValue(int value) {
        this.intValue = value;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public void setStringValue(String value) {
        this.stringValue = value;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    @Override
    public String getCreateSQLForCopy(Table table, String quotedName) {
        throw DbException.throwInternalError();
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public String getCreateSQL() {
        StringBuilder buff = new StringBuilder("SET ");
        buff.append(this.getSQL()).append(' ');
        if (this.stringValue != null) {
            buff.append(this.stringValue);
        } else {
            buff.append(this.intValue);
        }
        return buff.toString();
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.database.removeMeta(session, this.getId());
        this.invalidate();
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("RENAME");
    }
}

