/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import org.h2.command.Command;
import org.h2.command.CommandInterface;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.command.dml.SetTypes;
import org.h2.constant.SysProperties;
import org.h2.constraint.Constraint;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Database;
import org.h2.engine.Engine;
import org.h2.engine.Procedure;
import org.h2.engine.SessionInterface;
import org.h2.engine.SessionWithState;
import org.h2.engine.Setting;
import org.h2.engine.UndoLog;
import org.h2.engine.UndoLogRecord;
import org.h2.engine.User;
import org.h2.index.Index;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.store.DataHandler;
import org.h2.store.InDoubtTransaction;
import org.h2.table.Table;
import org.h2.util.New;
import org.h2.util.SmallLRUCache;
import org.h2.value.Value;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

public class Session
extends SessionWithState {
    public static final int LOG_WRITTEN = -1;
    private static final String SYSTEM_IDENTIFIER_PREFIX = "_";
    private static int nextSerialId;
    private final int serialId = nextSerialId++;
    private Database database;
    private ConnectionInfo connectionInfo;
    private User user;
    private int id;
    private ArrayList<Table> locks = New.arrayList();
    private UndoLog undoLog;
    private boolean autoCommit = true;
    private Random random;
    private int lockTimeout;
    private Value lastIdentity = ValueLong.get(0L);
    private Value scopeIdentity = ValueLong.get(0L);
    private int firstUncommittedLog = -1;
    private int firstUncommittedPos = -1;
    private HashMap<String, Integer> savepoints;
    private HashMap<String, Table> localTempTables;
    private HashMap<String, Index> localTempTableIndexes;
    private HashMap<String, Constraint> localTempTableConstraints;
    private int throttle;
    private long lastThrottle;
    private Command currentCommand;
    private boolean allowLiterals;
    private String currentSchemaName;
    private String[] schemaSearchPath;
    private Trace trace;
    private HashMap<String, Value> unlinkLobMap;
    private int systemIdentifier;
    private HashMap<String, Procedure> procedures;
    private boolean undoLogEnabled = true;
    private boolean redoLogBinary = true;
    private boolean autoCommitAtTransactionEnd;
    private String currentTransactionName;
    private volatile long cancelAt;
    private boolean closed;
    private long sessionStart = System.currentTimeMillis();
    private long transactionStart;
    private long currentCommandStart;
    private HashMap<String, Value> variables;
    private HashSet<ResultInterface> temporaryResults;
    private int queryTimeout;
    private boolean commitOrRollbackDisabled;
    private Table waitForLock;
    private int modificationId;
    private int modificationIdState;
    private int objectId;
    private final int queryCacheSize;
    private SmallLRUCache<String, Command> queryCache;

    public Session(Database database, User user, int id) {
        this.database = database;
        this.queryTimeout = database.getSettings().maxQueryTimeout;
        this.queryCacheSize = database.getSettings().queryCacheSize;
        this.undoLog = new UndoLog(this);
        this.user = user;
        this.id = id;
        Setting setting = database.findSetting(SetTypes.getTypeName(6));
        this.lockTimeout = setting == null ? 2000 : setting.getIntValue();
        this.currentSchemaName = "PUBLIC";
    }

    public boolean setCommitOrRollbackDisabled(boolean x) {
        boolean old = this.commitOrRollbackDisabled;
        this.commitOrRollbackDisabled = x;
        return old;
    }

    private void initVariables() {
        if (this.variables == null) {
            this.variables = this.database.newStringMap();
        }
    }

    public void setVariable(String name, Value value) {
        Value old;
        this.initVariables();
        ++this.modificationId;
        if (value == ValueNull.INSTANCE) {
            old = this.variables.remove(name);
        } else {
            value = value.link(this.database, -1);
            old = this.variables.put(name, value);
        }
        if (old != null) {
            old.unlink();
            old.close();
        }
    }

    public Value getVariable(String name) {
        this.initVariables();
        Value v = this.variables.get(name);
        return v == null ? ValueNull.INSTANCE : v;
    }

    public String[] getVariableNames() {
        if (this.variables == null) {
            return new String[0];
        }
        String[] list = new String[this.variables.size()];
        this.variables.keySet().toArray(list);
        return list;
    }

    public Table findLocalTempTable(String name) {
        if (this.localTempTables == null) {
            return null;
        }
        return this.localTempTables.get(name);
    }

    public ArrayList<Table> getLocalTempTables() {
        if (this.localTempTables == null) {
            return New.arrayList();
        }
        return New.arrayList(this.localTempTables.values());
    }

    public void addLocalTempTable(Table table) {
        if (this.localTempTables == null) {
            this.localTempTables = this.database.newStringMap();
        }
        if (this.localTempTables.get(table.getName()) != null) {
            throw DbException.get(42101, table.getSQL());
        }
        ++this.modificationId;
        this.localTempTables.put(table.getName(), table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalTempTable(Table table) {
        ++this.modificationId;
        this.localTempTables.remove(table.getName());
        Database database = this.database;
        synchronized (database) {
            table.removeChildrenAndResources(this);
        }
    }

    public Index findLocalTempTableIndex(String name) {
        if (this.localTempTableIndexes == null) {
            return null;
        }
        return this.localTempTableIndexes.get(name);
    }

    public HashMap<String, Index> getLocalTempTableIndexes() {
        if (this.localTempTableIndexes == null) {
            return New.hashMap();
        }
        return this.localTempTableIndexes;
    }

    public void addLocalTempTableIndex(Index index) {
        if (this.localTempTableIndexes == null) {
            this.localTempTableIndexes = this.database.newStringMap();
        }
        if (this.localTempTableIndexes.get(index.getName()) != null) {
            throw DbException.get(42111, index.getSQL());
        }
        this.localTempTableIndexes.put(index.getName(), index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalTempTableIndex(Index index) {
        if (this.localTempTableIndexes != null) {
            this.localTempTableIndexes.remove(index.getName());
            Database database = this.database;
            synchronized (database) {
                index.removeChildrenAndResources(this);
            }
        }
    }

    public Constraint findLocalTempTableConstraint(String name) {
        if (this.localTempTableConstraints == null) {
            return null;
        }
        return this.localTempTableConstraints.get(name);
    }

    public HashMap<String, Constraint> getLocalTempTableConstraints() {
        if (this.localTempTableConstraints == null) {
            return New.hashMap();
        }
        return this.localTempTableConstraints;
    }

    public void addLocalTempTableConstraint(Constraint constraint) {
        String name;
        if (this.localTempTableConstraints == null) {
            this.localTempTableConstraints = this.database.newStringMap();
        }
        if (this.localTempTableConstraints.get(name = constraint.getName()) != null) {
            throw DbException.get(90045, constraint.getSQL());
        }
        this.localTempTableConstraints.put(name, constraint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLocalTempTableConstraint(Constraint constraint) {
        if (this.localTempTableConstraints != null) {
            this.localTempTableConstraints.remove(constraint.getName());
            Database database = this.database;
            synchronized (database) {
                constraint.removeChildrenAndResources(this);
            }
        }
    }

    @Override
    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public User getUser() {
        return this.user;
    }

    @Override
    public void setAutoCommit(boolean b) {
        this.autoCommit = b;
    }

    public int getLockTimeout() {
        return this.lockTimeout;
    }

    public void setLockTimeout(int lockTimeout) {
        this.lockTimeout = lockTimeout;
    }

    @Override
    public synchronized CommandInterface prepareCommand(String sql, int fetchSize) {
        return this.prepareLocal(sql);
    }

    public Prepared prepare(String sql) {
        return this.prepare(sql, false);
    }

    public Prepared prepare(String sql, boolean rightsChecked) {
        Parser parser = new Parser(this);
        parser.setRightsChecked(rightsChecked);
        return parser.prepare(sql);
    }

    public Command prepareLocal(String sql) {
        Command command;
        if (this.closed) {
            throw DbException.get(90067, "session closed");
        }
        if (this.queryCacheSize > 0) {
            if (this.queryCache == null) {
                this.queryCache = SmallLRUCache.newInstance(this.queryCacheSize);
            } else {
                command = (Command)this.queryCache.get(sql);
                if (command != null && command.canReuse()) {
                    command.reuse();
                    return command;
                }
            }
        }
        Parser parser = new Parser(this);
        command = parser.prepareCommand(sql);
        if (this.queryCache != null && command.isCacheable()) {
            this.queryCache.put(sql, command);
        }
        return command;
    }

    public Database getDatabase() {
        return this.database;
    }

    @Override
    public int getPowerOffCount() {
        return this.database.getPowerOffCount();
    }

    @Override
    public void setPowerOffCount(int count) {
        this.database.setPowerOffCount(count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(boolean ddl) {
        this.checkCommitRollback();
        this.currentTransactionName = null;
        this.transactionStart = 0L;
        if (this.containsUncommitted()) {
            this.database.commit(this);
        }
        if (this.undoLog.size() > 0) {
            if (this.database.isMultiVersion()) {
                ArrayList rows = New.arrayList();
                Database database = this.database;
                synchronized (database) {
                    while (this.undoLog.size() > 0) {
                        UndoLogRecord entry = this.undoLog.getLast();
                        entry.commit();
                        rows.add(entry.getRow());
                        this.undoLog.removeLast(false);
                    }
                    int size = rows.size();
                    for (int i = 0; i < size; ++i) {
                        Row r = (Row)rows.get(i);
                        r.commit();
                    }
                }
            }
            this.undoLog.clear();
        }
        if (!ddl) {
            this.cleanTempTables(false);
            if (this.autoCommitAtTransactionEnd) {
                this.autoCommit = true;
                this.autoCommitAtTransactionEnd = false;
            }
        }
        if (this.unlinkLobMap != null && this.unlinkLobMap.size() > 0) {
            this.database.flush();
            for (Value v : this.unlinkLobMap.values()) {
                v.unlink();
                v.close();
            }
            this.unlinkLobMap = null;
        }
        this.unlockAll();
    }

    private void checkCommitRollback() {
        if (this.commitOrRollbackDisabled && this.locks.size() > 0) {
            throw DbException.get(90058);
        }
    }

    public void rollback() {
        this.checkCommitRollback();
        this.currentTransactionName = null;
        boolean needCommit = false;
        if (this.undoLog.size() > 0) {
            this.rollbackTo(0, false);
            needCommit = true;
        }
        if (this.locks.size() > 0 || needCommit) {
            this.database.commit(this);
        }
        this.cleanTempTables(false);
        this.unlockAll();
        if (this.autoCommitAtTransactionEnd) {
            this.autoCommit = true;
            this.autoCommitAtTransactionEnd = false;
        }
    }

    public void rollbackTo(int index, boolean trimToSize) {
        while (this.undoLog.size() > index) {
            UndoLogRecord entry = this.undoLog.getLast();
            entry.undo(this);
            this.undoLog.removeLast(trimToSize);
        }
        if (this.savepoints != null) {
            String[] names = new String[this.savepoints.size()];
            this.savepoints.keySet().toArray(names);
            for (String name : names) {
                Integer savepointIndex = this.savepoints.get(name);
                if (savepointIndex <= index) continue;
                this.savepoints.remove(name);
            }
        }
    }

    @Override
    public int getUndoLogPos() {
        return this.undoLog.size();
    }

    public int getId() {
        return this.id;
    }

    @Override
    public void cancel() {
        this.cancelAt = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed) {
            try {
                this.database.checkPowerOff();
                this.cleanTempTables(true);
                this.undoLog.clear();
                this.database.removeSession(this);
            }
            finally {
                this.closed = true;
            }
        }
    }

    public void addLock(Table table) {
        if (SysProperties.CHECK && this.locks.indexOf(table) >= 0) {
            DbException.throwInternalError();
        }
        this.locks.add(table);
    }

    public void log(Table table, short operation, Row row) {
        if (this.undoLogEnabled) {
            int lockMode;
            UndoLogRecord log = new UndoLogRecord(table, operation, row);
            if (SysProperties.CHECK && (lockMode = this.database.getLockMode()) != 0 && !this.database.isMultiVersion()) {
                String tableType = log.getTable().getTableType();
                if (this.locks.indexOf(log.getTable()) < 0 && !"TABLE LINK".equals(tableType) && !"EXTERNAL".equals(tableType)) {
                    DbException.throwInternalError();
                }
            }
            this.undoLog.add(log);
        } else {
            ArrayList<Index> indexes = table.getIndexes();
            int size = indexes.size();
            for (int i = 0; i < size; ++i) {
                Index index = indexes.get(i);
                index.commit(operation, row);
            }
            row.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockReadLocks() {
        if (this.database.isMultiVersion()) {
            return;
        }
        for (int i = 0; i < this.locks.size(); ++i) {
            Table t = this.locks.get(i);
            if (t.isLockedExclusively()) continue;
            Database database = this.database;
            synchronized (database) {
                t.unlock(this);
                this.locks.remove(i);
            }
            --i;
        }
    }

    void unlock(Table t) {
        this.locks.remove(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockAll() {
        if (SysProperties.CHECK && this.undoLog.size() > 0) {
            DbException.throwInternalError();
        }
        if (this.locks.size() > 0) {
            Database database = this.database;
            synchronized (database) {
                int size = this.locks.size();
                for (int i = 0; i < size; ++i) {
                    Table t = this.locks.get(i);
                    t.unlock(this);
                }
                this.locks.clear();
            }
        }
        this.savepoints = null;
        if (this.modificationIdState != this.modificationId) {
            this.sessionStateChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanTempTables(boolean closeSession) {
        if (this.localTempTables != null && this.localTempTables.size() > 0) {
            Database database = this.database;
            synchronized (database) {
                for (Table table : New.arrayList(this.localTempTables.values())) {
                    if (closeSession || table.getOnCommitDrop()) {
                        ++this.modificationId;
                        table.setModified();
                        this.localTempTables.remove(table.getName());
                        table.removeChildrenAndResources(this);
                        continue;
                    }
                    if (!table.getOnCommitTruncate()) continue;
                    table.truncate(this);
                }
            }
        }
    }

    public Random getRandom() {
        if (this.random == null) {
            this.random = new Random();
        }
        return this.random;
    }

    @Override
    public Trace getTrace() {
        if (this.trace != null && !this.closed) {
            return this.trace;
        }
        String traceModuleName = "jdbc[" + this.id + "]";
        if (this.closed) {
            return new TraceSystem(null).getTrace(traceModuleName);
        }
        this.trace = this.database.getTrace(traceModuleName);
        return this.trace;
    }

    public void setLastIdentity(Value last) {
        this.scopeIdentity = last;
        this.lastIdentity = last;
    }

    public Value getLastIdentity() {
        return this.lastIdentity;
    }

    public void addLogPos(int logId, int pos) {
        if (this.firstUncommittedLog == -1) {
            this.firstUncommittedLog = logId;
            this.firstUncommittedPos = pos;
        }
    }

    public int getFirstUncommittedLog() {
        return this.firstUncommittedLog;
    }

    void setAllCommitted() {
        this.firstUncommittedLog = -1;
        this.firstUncommittedPos = -1;
    }

    private boolean containsUncommitted() {
        return this.firstUncommittedLog != -1;
    }

    public void addSavepoint(String name) {
        if (this.savepoints == null) {
            this.savepoints = this.database.newStringMap();
        }
        this.savepoints.put(name, this.getUndoLogPos());
    }

    public void rollbackToSavepoint(String name) {
        this.checkCommitRollback();
        if (this.savepoints == null) {
            throw DbException.get(90063, name);
        }
        Integer savepointIndex = this.savepoints.get(name);
        if (savepointIndex == null) {
            throw DbException.get(90063, name);
        }
        int i = savepointIndex;
        this.rollbackTo(i, false);
    }

    public void prepareCommit(String transactionName) {
        if (this.containsUncommitted()) {
            this.database.prepareCommit(this, transactionName);
        }
        this.currentTransactionName = transactionName;
    }

    public void setPreparedTransaction(String transactionName, boolean commit) {
        if (this.currentTransactionName != null && this.currentTransactionName.equals(transactionName)) {
            if (commit) {
                this.commit(false);
            } else {
                this.rollback();
            }
        } else {
            ArrayList<InDoubtTransaction> list = this.database.getInDoubtTransactions();
            int state = commit ? 1 : 2;
            boolean found = false;
            if (list != null) {
                for (InDoubtTransaction p : list) {
                    if (!p.getTransaction().equals(transactionName)) continue;
                    p.setState(state);
                    found = true;
                    break;
                }
            }
            if (!found) {
                throw DbException.get(90129, transactionName);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public void setThrottle(int throttle) {
        this.throttle = throttle;
    }

    public void throttle() {
        if (this.currentCommandStart == 0L) {
            this.currentCommandStart = System.currentTimeMillis();
        }
        if (this.throttle == 0) {
            return;
        }
        long time = System.currentTimeMillis();
        if (this.lastThrottle + 50L > time) {
            return;
        }
        this.lastThrottle = time + (long)this.throttle;
        try {
            Thread.sleep(this.throttle);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCurrentCommand(Command command) {
        this.currentCommand = command;
        if (this.queryTimeout > 0 && command != null) {
            long now;
            this.currentCommandStart = now = System.currentTimeMillis();
            this.cancelAt = now + (long)this.queryTimeout;
        }
    }

    public void checkCanceled() {
        this.throttle();
        if (this.cancelAt == 0L) {
            return;
        }
        long time = System.currentTimeMillis();
        if (time >= this.cancelAt) {
            this.cancelAt = 0L;
            throw DbException.get(57014);
        }
    }

    public long getCancel() {
        return this.cancelAt;
    }

    public Command getCurrentCommand() {
        return this.currentCommand;
    }

    public long getCurrentCommandStart() {
        return this.currentCommandStart;
    }

    public boolean getAllowLiterals() {
        return this.allowLiterals;
    }

    public void setAllowLiterals(boolean b) {
        this.allowLiterals = b;
    }

    public void setCurrentSchema(Schema schema) {
        ++this.modificationId;
        this.currentSchemaName = schema.getName();
    }

    public String getCurrentSchemaName() {
        return this.currentSchemaName;
    }

    public JdbcConnection createConnection(boolean columnList) {
        String url = columnList ? "jdbc:columnlist:connection" : "jdbc:default:connection";
        return new JdbcConnection(this, this.getUser().getName(), url);
    }

    @Override
    public DataHandler getDataHandler() {
        return this.database;
    }

    public void unlinkAtCommit(Value v) {
        if (SysProperties.CHECK && !v.isLinked()) {
            DbException.throwInternalError();
        }
        if (this.unlinkLobMap == null) {
            this.unlinkLobMap = New.hashMap();
        }
        this.unlinkLobMap.put(v.toString(), v);
    }

    public void unlinkAtCommitStop(Value v) {
        if (this.unlinkLobMap != null) {
            this.unlinkLobMap.remove(v.toString());
        }
    }

    public String getNextSystemIdentifier(String sql) {
        String identifier;
        while (sql.indexOf(identifier = SYSTEM_IDENTIFIER_PREFIX + this.systemIdentifier++) >= 0) {
        }
        return identifier;
    }

    public void addProcedure(Procedure procedure) {
        if (this.procedures == null) {
            this.procedures = this.database.newStringMap();
        }
        this.procedures.put(procedure.getName(), procedure);
    }

    public void removeProcedure(String name) {
        if (this.procedures != null) {
            this.procedures.remove(name);
        }
    }

    public Procedure getProcedure(String name) {
        if (this.procedures == null) {
            return null;
        }
        return this.procedures.get(name);
    }

    public void setSchemaSearchPath(String[] schemas) {
        ++this.modificationId;
        this.schemaSearchPath = schemas;
    }

    public String[] getSchemaSearchPath() {
        return this.schemaSearchPath;
    }

    public int hashCode() {
        return this.serialId;
    }

    public String toString() {
        return "#" + this.serialId + " (user: " + this.user.getName() + ")";
    }

    public void setUndoLogEnabled(boolean b) {
        this.undoLogEnabled = b;
    }

    public void setRedoLogBinary(boolean b) {
        this.redoLogBinary = b;
    }

    public boolean isUndoLogEnabled() {
        return this.undoLogEnabled;
    }

    public void begin() {
        this.autoCommitAtTransactionEnd = true;
        this.autoCommit = false;
    }

    public long getSessionStart() {
        return this.sessionStart;
    }

    public long getTransactionStart() {
        if (this.transactionStart == 0L) {
            this.transactionStart = System.currentTimeMillis();
        }
        return this.transactionStart;
    }

    public Table[] getLocks() {
        ArrayList<Table> copy = New.arrayList();
        for (int i = 0; i < this.locks.size(); ++i) {
            try {
                copy.add(this.locks.get(i));
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        Table[] list = new Table[copy.size()];
        copy.toArray(list);
        return list;
    }

    public void waitIfExclusiveModeEnabled() {
        Session exclusive;
        while ((exclusive = this.database.getExclusiveSession()) != null && exclusive != this && !Thread.holdsLock(exclusive)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void addTemporaryResult(ResultInterface result) {
        if (!result.needToClose()) {
            return;
        }
        if (this.temporaryResults == null) {
            this.temporaryResults = New.hashSet();
        }
        if (this.temporaryResults.size() < 100) {
            this.temporaryResults.add(result);
        }
    }

    public void closeTemporaryResults() {
        if (this.temporaryResults != null) {
            for (ResultInterface result : this.temporaryResults) {
                result.close();
            }
            this.temporaryResults = null;
        }
    }

    public void setQueryTimeout(int queryTimeout) {
        int max = this.database.getSettings().maxQueryTimeout;
        if (max != 0 && (max < queryTimeout || queryTimeout == 0)) {
            queryTimeout = max;
        }
        this.queryTimeout = queryTimeout;
        this.cancelAt = 0L;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setWaitForLock(Table table) {
        this.waitForLock = table;
    }

    public Table getWaitForLock() {
        return this.waitForLock;
    }

    public int getModificationId() {
        return this.modificationId;
    }

    @Override
    public boolean isReconnectNeeded(boolean write) {
        block2: {
            do {
                boolean reconnect;
                if (reconnect = this.database.isReconnectNeeded()) {
                    return true;
                }
                if (!write) break block2;
            } while (!this.database.beforeWriting());
            return false;
        }
        return false;
    }

    @Override
    public void afterWriting() {
        this.database.afterWriting();
    }

    @Override
    public SessionInterface reconnect(boolean write) {
        this.readSessionState();
        this.close();
        Session newSession = Engine.getInstance().createSession(this.connectionInfo);
        newSession.sessionState = this.sessionState;
        newSession.recreateSessionState();
        if (write) {
            while (!newSession.database.beforeWriting()) {
            }
        }
        return newSession;
    }

    public void setConnectionInfo(ConnectionInfo ci) {
        this.connectionInfo = ci;
    }

    public Value getTransactionId() {
        if (this.undoLog.size() == 0 || !this.database.isPersistent()) {
            return ValueNull.INSTANCE;
        }
        return ValueString.get(this.firstUncommittedLog + "-" + this.firstUncommittedPos + "-" + this.id);
    }

    public int nextObjectId() {
        return this.objectId++;
    }

    public void setScopeIdentity(Value scopeIdentity) {
        this.scopeIdentity = scopeIdentity;
    }

    public Value getScopeIdentity() {
        return this.scopeIdentity;
    }

    public boolean isRedoLogBinaryEnabled() {
        return this.redoLogBinary;
    }
}

