/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.el;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.el.GreekLowerCaseFilter;
import org.apache.lucene.analysis.el.GreekStemFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;

public final class GreekAnalyzer
extends StopwordAnalyzerBase {
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";

    public static final Set<?> getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_SET;
    }

    public GreekAnalyzer(Version matchVersion) {
        this(matchVersion, DefaultSetHolder.DEFAULT_SET);
    }

    public GreekAnalyzer(Version matchVersion, Set<?> stopwords) {
        super(matchVersion, stopwords);
    }

    @Deprecated
    public GreekAnalyzer(Version matchVersion, String ... stopwords) {
        this(matchVersion, StopFilter.makeStopSet((Version)matchVersion, (String[])stopwords));
    }

    @Deprecated
    public GreekAnalyzer(Version matchVersion, Map<?, ?> stopwords) {
        this(matchVersion, stopwords.keySet());
    }

    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        StandardTokenizer source = new StandardTokenizer(this.matchVersion, reader);
        TokenFilter result = new GreekLowerCaseFilter(this.matchVersion, (TokenStream)source);
        if (this.matchVersion.onOrAfter(Version.LUCENE_31)) {
            result = new StandardFilter(this.matchVersion, (TokenStream)result);
        }
        result = new StopFilter(this.matchVersion, (TokenStream)result, (Set)this.stopwords);
        if (this.matchVersion.onOrAfter(Version.LUCENE_31)) {
            result = new GreekStemFilter((TokenStream)result);
        }
        return new ReusableAnalyzerBase.TokenStreamComponents((Tokenizer)source, (TokenStream)result);
    }

    private static class DefaultSetHolder {
        private static final Set<?> DEFAULT_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_SET = GreekAnalyzer.loadStopwordSet((boolean)false, (Class)GreekAnalyzer.class, (String)GreekAnalyzer.DEFAULT_STOPWORD_FILE, (String)"#");
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

